/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.EE;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.gradle.BeanProperties;
import aQute.bnd.gradle.BndPluginExtension;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.bnd.repository.fileset.FileSetRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.stream.MapStream;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import biz.aQute.resolve.Bndrun;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.NormalizeLineEndings;

@DisableCachingByDefault(because="Abstract base class; not used directly")
public abstract class AbstractBndrun
extends DefaultTask {
    private final RegularFileProperty bndrun;
    private final ConfigurableFileCollection bundles;
    private boolean ignoreFailures = false;
    private final DirectoryProperty workingDirectory;
    private final String projectName;
    private final Provider<String> targetVersion;
    private final FileCollection artifacts;
    private final MapProperty<String, Object> properties;
    private final Property<Boolean> offline;
    private final Property<aQute.bnd.build.Project> bndProject;
    private final Property<Workspace> bndWorkspace;

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NormalizeLineEndings
    public RegularFileProperty getBndrun() {
        return this.bndrun;
    }

    @Internal
    public ConfigurableFileCollection getBundles() {
        return this.bundles;
    }

    @Classpath
    Provider<List<File>> getBundlesSorted() {
        return this.getBundles().getElements().map(c -> c.stream().map(FileSystemLocation::getAsFile).sorted(IO.fileComparator(File::getAbsolutePath)).collect(Collectors.toList()));
    }

    @Input
    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Internal
    public boolean getIgnoreFailures() {
        return this.isIgnoreFailures();
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Internal
    public DirectoryProperty getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Input
    public MapProperty<String, Object> getProperties() {
        return this.properties;
    }

    @Internal
    String getProjectName() {
        return this.projectName;
    }

    @Internal
    Provider<String> getTargetVersion() {
        return this.targetVersion;
    }

    @Internal
    FileCollection getArtifacts() {
        return this.artifacts;
    }

    @Internal
    Provider<Boolean> getOffline() {
        return this.offline;
    }

    @Internal
    Provider<Workspace> getBndWorkspace() {
        return this.bndWorkspace;
    }

    @Internal
    Provider<aQute.bnd.build.Project> getBndProject() {
        return this.bndProject;
    }

    public AbstractBndrun() {
        Project project = this.getProject();
        this.projectName = project.getName();
        ObjectFactory objects = project.getObjects();
        this.bndrun = objects.fileProperty();
        DirectoryProperty temporaryDirProperty = objects.directoryProperty().fileValue(this.getTemporaryDir());
        this.workingDirectory = objects.directoryProperty().convention(temporaryDirProperty.dir(this.projectName));
        this.bundles = objects.fileCollection();
        SourceSet mainSourceSet = (SourceSet)BndUtils.sourceSets(project).getByName("main");
        this.targetVersion = project.getTasks().named(mainSourceSet.getCompileJavaTaskName(), JavaCompile.class).map(t -> (String)t.getOptions().getRelease().map(Object::toString).getOrElse((Object)t.getTargetCompatibility()));
        Configuration archivesConfiguration = project.getConfigurations().getByName("archives");
        this.artifacts = archivesConfiguration.getArtifacts().getFiles();
        this.properties = objects.mapProperty(String.class, Object.class);
        this.offline = objects.property(Boolean.class).convention((Object)project.getGradle().getStartParameter().isOffline());
        this.bndWorkspace = objects.property(Workspace.class).value((Object)((Workspace)project.findProperty("bndWorkspace")));
        this.bndProject = objects.property(aQute.bnd.build.Project.class);
        if (this.bndWorkspace.isPresent()) {
            this.bundles.disallowChanges();
            this.properties.disallowChanges();
            if (project.getPluginManager().hasPlugin("biz.aQute.bnd")) {
                BndPluginExtension extension = (BndPluginExtension)project.getExtensions().getByType(BndPluginExtension.class);
                this.bndProject.value((Object)extension.getProject());
            }
            this.offline.value(this.bndWorkspace.map(ws -> ws.isOffline()));
        } else {
            this.bundles(mainSourceSet.getRuntimeClasspath());
            this.bundles(this.artifacts);
            this.properties.convention(project.provider(this::getGradleProjectProperties));
        }
    }

    private Map<String, String> getGradleProjectProperties() throws Exception {
        BeanProperties gradleProperties = new BeanProperties();
        gradleProperties.put("project", this.getProject());
        try (Processor processor = new Processor();){
            this.loadBndProperties(processor);
            Map map = (Map)MapStream.ofEntries(processor.getMacroReferences(new Processor.MacroReference[]{Processor.MacroReference.UNKNOWN}).stream().filter(k -> k.startsWith("project.")), k -> MapStream.entry((Object)k, (Object)gradleProperties.getProperty((String)k))).filterValue(Objects::nonNull).collect(MapStream.toMap());
            return map;
        }
    }

    private void loadBndProperties(Processor processor) throws Exception {
        File bndrunFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getBndrun());
        processor.setProperties(bndrunFile, BndUtils.unwrapFile((FileSystemLocation)this.getProject().getLayout().getProjectDirectory()));
    }

    public ConfigurableFileCollection bundles(Object ... paths) {
        return BndUtils.builtBy(this.getBundles().from(paths), paths);
    }

    public void setBundles(Object path) {
        this.getBundles().setFrom(Collections.emptyList());
        this.getBundles().setBuiltBy(Collections.emptyList());
        this.bundles(path);
    }

    @TaskAction
    public void bndrunAction() throws Exception {
        File bndrunFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getBndrun());
        Optional<aQute.bnd.build.Project> project = BndUtils.unwrapOptional(this.getBndProject());
        if (project.map(Processor::getPropertiesFile).filter(bndrunFile::equals).isPresent()) {
            this.worker(project.get());
            return;
        }
        File workingDirFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getWorkingDirectory());
        Optional<Workspace> workspace = BndUtils.unwrapOptional(this.getBndWorkspace());
        try (Bndrun run = this.createBndrun(workspace.orElse(null), bndrunFile);){
            Workspace runWorkspace = run.getWorkspace();
            IO.mkdirs((File)workingDirFile);
            if (workspace.isEmpty()) {
                BeanProperties gradleProperties = new BeanProperties(runWorkspace.getProperties());
                gradleProperties.putAll((Map<?, ?>)((Map)BndUtils.unwrap(this.getProperties())));
                gradleProperties.putIfAbsent("task", (Object)this);
                run.setParent(new Processor((Processor)runWorkspace, (Properties)gradleProperties, false));
                run.clear();
                run.forceRefresh();
            }
            run.setBase(workingDirFile);
            if (run.isStandalone()) {
                runWorkspace.setBase(workingDirFile);
                File cnf = new File(workingDirFile, "cnf");
                IO.mkdirs((File)cnf);
                runWorkspace.setBuildDir(cnf);
                runWorkspace.setOffline(BndUtils.unwrap(this.getOffline()).booleanValue());
                if (workspace.isEmpty()) {
                    FileSetRepository fileSetRepository = new FileSetRepository(this.getName(), (Collection)this.getBundles().getFiles());
                    runWorkspace.addBasicPlugin((Object)fileSetRepository);
                    for (RepositoryPlugin repo : runWorkspace.getRepositories()) {
                        repo.list(null);
                    }
                }
            }
            run.getInfo((Reporter)runWorkspace);
            this.inferRunEE((Processor)run);
            this.inferRunRequires((Processor)run);
            BndUtils.logReport((Report)run, this.getLogger());
            if (!run.isOk()) {
                throw new GradleException(String.format("%s workspace errors", run.getPropertiesFile()));
            }
            this.worker((aQute.bnd.build.Project)run);
        }
    }

    protected Bndrun createBndrun(Workspace workspace, File bndrunFile) throws Exception {
        return Bndrun.createBndrun((Workspace)workspace, (File)bndrunFile);
    }

    protected abstract void worker(aQute.bnd.build.Project var1) throws Exception;

    protected void inferRunEE(Processor run) {
        String runee = run.getProperty("-runee");
        if (Objects.isNull(runee)) {
            runee = Optional.ofNullable((String)this.getTargetVersion().getOrElse((Object)System.getProperty("java.specification.version"))).flatMap(EE::highestFromTargetVersion).orElse(EE.JavaSE_1_8).getEEName();
            run.setProperty("-runee", runee);
            this.getLogger().info("Bnd inferred {}: {}", (Object)"-runee", (Object)run.getProperty("-runee"));
        }
    }

    protected void inferRunRequires(Processor run) {
        String runrequires = run.getProperty("-runrequires");
        if (Objects.isNull(runrequires) && !this.getArtifacts().isEmpty() && !(runrequires = (String)this.getArtifacts().getFiles().stream().filter(File::isFile).map(file -> Optional.of(file).map(FunctionWithException.asFunctionOrElse(Domain::domain, null)).map(Domain::getBundleSymbolicName).map(Map.Entry::getKey).orElseGet(this::getProjectName)).distinct().map(bsn -> String.format("osgi.identity;filter:='(osgi.identity=%s)'", bsn)).collect(Strings.joining())).isEmpty()) {
            run.setProperty("-runrequires", runrequires);
            this.getLogger().info("Bnd inferred {}: {}", (Object)"-runrequires", (Object)run.getProperty("-runrequires"));
        }
    }
}

