/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.gradle.AbstractBndrun;
import aQute.bnd.gradle.BndUtils;
import aQute.lib.io.IO;
import aQute.service.reporter.Report;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Task executes bndrun")
public class Bndrun
extends AbstractBndrun {
    private final Property<JavaLauncher> javaLauncher;

    @Nested
    @Optional
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    public Bndrun() {
        this.setGroup("publishing");
        org.gradle.api.Project project = this.getProject();
        ObjectFactory objects = project.getObjects();
        this.javaLauncher = objects.property(JavaLauncher.class).convention(BndUtils.defaultToolFor(project, JavaToolchainService::launcherFor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void worker(Project run) throws Exception {
        if (this.getJavaLauncher().isPresent() && Objects.equals(run.getProperty("java", "java"), "java")) {
            run.setProperty("java", IO.absolutePath((File)BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getJavaLauncher().map(JavaLauncher::getExecutablePath))));
        }
        this.getLogger().info("Running {} in {}", (Object)run.getPropertiesFile(), (Object)run.getBase());
        this.getLogger().debug("Run properties: {}", (Object)run.getProperties());
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        try (ProjectLauncher pl = run.getProjectLauncher();
             ProjectLauncher.LiveCoding lc = pl.liveCoding((Executor)ForkJoinPool.commonPool(), scheduledExecutor);){
            pl.setTrace(run.isTrace() || run.isRunTrace());
            pl.launch();
        }
        finally {
            scheduledExecutor.shutdownNow();
            BndUtils.logReport((Report)run, this.getLogger());
        }
        if (!this.isIgnoreFailures() && !run.isOk()) {
            throw new GradleException(String.format("%s execution failure", run.getPropertiesFile()));
        }
    }
}

