/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.gradle.Baseline;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.BundleTaskExtension;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public class BndBuilderPlugin
implements Plugin<Project> {
    public static final String PLUGINID = "biz.aQute.bnd.builder";

    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("biz.aQute.bnd")) {
            throw new GradleException("Project already has \"biz.aQute.bnd\" plugin applied.");
        }
        project.getPluginManager().apply("java");
        RegularFile defaultBndfile = project.getLayout().getProjectDirectory().file("bnd.bnd");
        TaskContainer tasks = project.getTasks();
        TaskProvider jar = tasks.named("jar", Jar.class, t -> {
            t.setDescription("Assembles a bundle containing the main classes.");
            BundleTaskExtension extension = (BundleTaskExtension)t.getExtensions().create("bundle", BundleTaskExtension.class, new Object[]{t});
            if (BndUtils.unwrapFile((FileSystemLocation)defaultBndfile).isFile()) {
                extension.getBndfile().convention(defaultBndfile);
            }
            t.doLast("buildBundle", extension.buildAction());
        });
        Configuration baseline = (Configuration)project.getConfigurations().create("baseline");
        baseline.getDependencies().all(dep -> {
            if (dep instanceof ExternalDependency) {
                ExternalDependency externalDependency = (ExternalDependency)dep;
                externalDependency.version(mvc -> mvc.strictly(dep.getVersion()));
            }
            if (dep instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dep;
                moduleDependency.setTransitive(false);
            }
        });
        TaskProvider baselineTask = tasks.register("baseline", Baseline.class, t -> {
            t.setDescription("Baseline the project bundle.");
            t.setBundle(jar);
            t.setBaseline(baseline);
        });
        baseline.defaultDependencies(deps -> {
            Baseline task = (Baseline)((Object)((Object)BndUtils.unwrap(baselineTask)));
            Jar bundleTask = task.getBundleTask();
            if (Objects.nonNull(bundleTask)) {
                String archiveBaseName = (String)BndUtils.unwrap(bundleTask.getArchiveBaseName());
                String archiveVersion = BndUtils.unwrapOptional(bundleTask.getArchiveVersion()).orElse(null);
                String group = project.getGroup().toString();
                task.getLogger().debug("Searching for default baseline {}:{}:(0,{}[", new Object[]{group, archiveBaseName, archiveVersion});
                Dependency baselineDep = project.getDependencies().create((Object)String.format("%s:%s", group, archiveBaseName));
                ((ExternalDependency)baselineDep).version(mvc -> mvc.strictly(String.format("(0,%s[", archiveVersion)));
                ((ExternalDependency)baselineDep).setTransitive(false);
                try {
                    Configuration detached = project.getConfigurations().detachedConfiguration(new Dependency[]{baselineDep});
                    detached.getResolvedConfiguration().rethrowFailure();
                }
                catch (ResolveException e) {
                    task.getLogger().debug("Baseline configuration resolve error {}, adding {} as baseline", new Object[]{e, BndUtils.unwrapFile(task.getBundle()), e});
                    baselineDep = project.getDependencies().create((Object)project.getObjects().fileCollection().from(new Object[]{task.getBundle()}));
                }
                deps.add((Object)baselineDep);
            }
        });
    }
}

