/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Project;
import groovy.lang.MissingPropertyException;
import java.util.Objects;
import org.gradle.api.plugins.ExtensionAware;

public abstract class BndPluginExtension
implements ExtensionAware {
    public static final String NAME = "bnd";
    private final Project project;

    public BndPluginExtension(Project bndProject) {
        this.project = bndProject;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean is(String name) {
        return this.project.is(name);
    }

    public String get(String name) {
        return BndPluginExtension.trimmed(this.project.getProperty(name));
    }

    public Object get(String name, Object defaultValue) {
        String value = this.project.getProperty(name);
        if (Objects.nonNull(value)) {
            return value.trim();
        }
        return BndPluginExtension.trimmed(defaultValue);
    }

    public String merge(String name) {
        return BndPluginExtension.trimmed(this.project.mergeProperties(name));
    }

    public String process(String line) {
        return this.project.getReplacer().process(line);
    }

    public Object unprocessed(String name, Object defaultValue) {
        String value = this.project.getUnexpandedProperty(name);
        if (Objects.nonNull(value)) {
            return value.trim();
        }
        return BndPluginExtension.trimmed(defaultValue);
    }

    private static <O> O trimmed(O value) {
        Object object;
        if (value instanceof String) {
            String string = (String)value;
            object = string.trim();
        } else {
            object = value;
        }
        return object;
    }

    public String propertyMissing(String name) {
        if (Objects.equals(name, "ext") || this.getExtensions().getExtraProperties().has(name) || Objects.nonNull(this.getExtensions().findByName(name))) {
            throw new MissingPropertyException(name, String.class);
        }
        String value = this.get(name);
        if (Objects.nonNull(value)) {
            return value;
        }
        return this.get(name.replace('_', '.'));
    }
}

