/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.make.Make;
import aQute.bnd.service.SignerPlugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.InstructionFilter;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.JarResource;
import aQute.lib.osgi.PreprocessResource;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
extends Analyzer {
    private static final int SPLIT_MERGE_LAST = 1;
    private static final int SPLIT_MERGE_FIRST = 2;
    private static final int SPLIT_ERROR = 3;
    private static final int SPLIT_FIRST = 4;
    private static final int SPLIT_DEFAULT = 0;
    private static final File[] EMPTY_FILE = new File[0];
    List<File> sourcePath = new ArrayList<File>();
    Pattern NAME_URL = Pattern.compile("(.*)(http://.*)");
    Make make = new Make(this);
    boolean firstUse = true;

    public Builder(Processor parent) {
        super(parent);
    }

    public Builder() {
    }

    public Jar build() throws Exception {
        if (this.getProperty("-nope") != null) {
            return null;
        }
        String sub = this.getProperty("-sub");
        if (sub != null && sub.trim().length() > 0) {
            this.error("Specified -sub but calls build() instead of builds() (might be a programmer error)", new Object[0]);
        }
        if (this.getProperty("-conduit") != null) {
            this.error("Specified -conduit but calls build() instead of builds() (might be a programmer error", new Object[0]);
        }
        this.dot = new Jar("dot");
        this.addClose(this.dot);
        try {
            long modified = Long.parseLong(this.getProperty("base.modified"));
            this.dot.updateModified(modified, "Base modified");
        }
        catch (Exception modified) {
            // empty catch block
        }
        this.doExpand(this.dot);
        this.doIncludeResources(this.dot);
        this.doConditional(this.dot);
        Manifest manifest = this.calcManifest();
        String mf = this.getProperty("-manifest");
        if (mf != null) {
            File mff = this.getFile(mf);
            if (mff.isFile()) {
                try {
                    FileInputStream in = new FileInputStream(mff);
                    manifest = new Manifest(in);
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    this.error("-manifest while reading manifest file", e, new Object[0]);
                }
            } else {
                this.error("-manifest, no such file " + mf, new Object[0]);
            }
        }
        if (this.getProperty("-nomanifest") == null) {
            this.dot.setManifest(manifest);
        } else {
            this.dot.setNoManifest(true);
        }
        this.addSources(this.dot);
        if (this.getProperty("-pom") != null) {
            this.doPom(this.dot);
        }
        this.doVerify(this.dot);
        if (this.dot.getResources().isEmpty()) {
            this.error("The JAR is empty", new Object[0]);
        }
        this.dot.updateModified(this.lastModified(), "Last Modified Processor");
        this.dot.setName(this.getBsn());
        this.sign(this.dot);
        return this.dot;
    }

    void sign(Jar jar) throws Exception {
        String signing = this.getProperty("-sign");
        if (signing == null) {
            return;
        }
        this.trace("Signing %s, with %s", this.getBsn(), signing);
        List<SignerPlugin> signers = this.getPlugins(SignerPlugin.class);
        Map<String, Map<String, String>> infos = this.parseHeader(signing);
        for (Map.Entry<String, Map<String, String>> entry : infos.entrySet()) {
            for (SignerPlugin signer : signers) {
                signer.sign(this, entry.getKey());
            }
        }
    }

    public boolean hasSources() {
        return Builder.isTrue(this.getProperty("-sources"));
    }

    @Override
    protected String getImportPackages() {
        String ip = super.getImportPackages();
        if (ip != null) {
            return ip;
        }
        return "*";
    }

    private void doConditional(Jar dot) throws IOException {
        int size;
        Map<String, Map<String, String>> conditionals = this.getHeader("Conditional-Package");
        if (conditionals.isEmpty()) {
            return;
        }
        do {
            size = dot.getDirectories().size();
            this.analyze();
            this.analyzed = false;
            Map<String, Map<String, String>> imports = this.getImports();
            Map<String, Map<String, String>> filtered = Builder.merge("Conditional-Package", conditionals, imports, new HashSet<String>(), null);
            for (Map.Entry<String, Map<String, String>> entry : this.getImports().entrySet()) {
                String type = entry.getValue().get("-import:");
                if (type == null || !type.equals("private")) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            filtered.keySet().removeAll(dot.getPackages());
            this.doExpand(dot, "Conditional-Package Private imports", Builder.replaceWitInstruction(filtered, "Conditional-Package"), false);
        } while (dot.getDirectories().size() > size);
        this.analyzed = true;
    }

    @Override
    public void analyze() throws IOException {
        super.analyze();
        this.cleanupVersion(this.imports);
        this.cleanupVersion(this.exports);
        String version = this.getProperty("Bundle-Version");
        if (version != null) {
            this.setProperty("Bundle-Version", Builder.cleanupVersion(version));
        }
    }

    public void cleanupVersion(Map<String, Map<String, String>> mapOfMap) {
        for (Map.Entry<String, Map<String, String>> entry : mapOfMap.entrySet()) {
            Map<String, String> attributes = entry.getValue();
            if (!attributes.containsKey("version")) continue;
            attributes.put("version", Builder.cleanupVersion(attributes.get("version")));
        }
    }

    private void addSources(Jar dot) {
        if (!this.hasSources()) {
            return;
        }
        HashSet<String> packages = new HashSet<String>();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getProperties().store(out, "Generated by BND, at " + new Date());
            dot.putResource("OSGI-OPT/bnd.bnd", new EmbeddedResource(out.toByteArray(), 0L));
            out.close();
        }
        catch (Exception e) {
            this.error("Can not embed bnd file in JAR: " + e, new Object[0]);
        }
        for (String path : this.classspace.keySet()) {
            String pack = this.getPackage(path = String.valueOf(path.substring(0, path.length() - ".class".length())) + ".java").replace('.', '/');
            if (pack.length() > 1) {
                pack = String.valueOf(pack) + "/";
            }
            boolean found = false;
            String[] fixed = new String[]{"packageinfo", "package.html", "module-info.java", "package-info.java"};
            for (File root : this.getSourcePath()) {
                File f = Builder.getFile(root, path);
                if (!f.exists()) continue;
                found = true;
                if (!packages.contains(pack)) {
                    packages.add(pack);
                    File bdir = Builder.getFile(root, pack);
                    int j = 0;
                    while (j < fixed.length) {
                        File ff = Builder.getFile(bdir, fixed[j]);
                        if (ff.isFile()) {
                            dot.putResource("OSGI-OPT/src/" + pack + fixed[j], new FileResource(ff));
                        }
                        ++j;
                    }
                }
                dot.putResource("OSGI-OPT/src/" + path, new FileResource(f));
            }
            if (!found) {
                for (Jar jar : this.classpath) {
                    Resource resource = jar.getResource(path);
                    if (resource != null) {
                        dot.putResource("OSGI-OPT/src", resource);
                        continue;
                    }
                    resource = jar.getResource("OSGI-OPT/src/" + path);
                    if (resource == null) continue;
                    dot.putResource("OSGI-OPT/src", resource);
                }
            }
            if (!this.getSourcePath().isEmpty()) continue;
            this.warning("Including sources but -sourcepath does not contain any source directories ", new Object[0]);
        }
    }

    public Collection<File> getSourcePath() {
        if (this.firstUse) {
            this.firstUse = false;
            String sp = this.getProperty("-sourcepath");
            if (sp != null) {
                Map<String, Map<String, String>> map = this.parseHeader(sp);
                for (String file : map.keySet()) {
                    if (Builder.isDuplicate(file)) continue;
                    File f = this.getFile(file);
                    if (!f.isDirectory()) {
                        this.error("Adding a sourcepath that is not a directory: " + f, new Object[0]);
                        continue;
                    }
                    this.sourcePath.add(f);
                }
            }
        }
        return this.sourcePath;
    }

    private void doVerify(Jar dot) throws Exception {
        Verifier verifier = new Verifier(dot, this.getProperties());
        verifier.setPedantic(this.isPedantic());
        verifier.setClassSpace(this.classspace, this.contained, this.referred, this.uses);
        verifier.verify();
        this.getInfo(verifier);
    }

    private void doExpand(Jar jar) throws IOException {
        if (this.getClasspath().size() == 0 && (this.getProperty("Export-Package") != null || this.getProperty("Private-Package") != null)) {
            this.warning("Classpath is empty. Private-Package and Export-Package can only expand from the classpath when there is one", new Object[0]);
        }
        Map<Instruction, Map<String, String>> privateMap = Builder.replaceWitInstruction(this.getHeader("Private-Package"), "Private-Package");
        Map<Instruction, Map<String, String>> exportMap = Builder.replaceWitInstruction(this.getHeader("Export-Package"), "Export-Package");
        if (Builder.isTrue(this.getProperty("-undertest"))) {
            privateMap.putAll(Builder.replaceWitInstruction(this.parseHeader(this.getProperty("-testpackages", "test;presence:=optional")), "-testpackages"));
        }
        if (!privateMap.isEmpty()) {
            this.doExpand(jar, "Private-Package, or -testpackages", privateMap, true);
        }
        if (!exportMap.isEmpty()) {
            Jar exports = new Jar("exports");
            this.doExpand(exports, "Export-Package", exportMap, true);
            jar.addAll(exports);
            exports.close();
        }
        if (privateMap.isEmpty() && exportMap.isEmpty() && !this.isResourceOnly()) {
            this.warning("Neither Export-Package, Private-Package, -testpackages is set, therefore no packages will be included", new Object[0]);
        }
    }

    private void doExpand(Jar jar, String name, Map<Instruction, Map<String, String>> instructions, boolean mandatory) {
        Set<Instruction> superfluous = this.removeMarkedDuplicates((Collection<Instruction>)instructions.keySet());
        for (Jar now : this.getClasspath()) {
            this.doExpand(jar, instructions, now, superfluous);
        }
        if (mandatory && superfluous.size() > 0) {
            StringBuffer sb = new StringBuffer();
            String del = "Instructions in " + name + " that are never used: ";
            for (Instruction p : superfluous) {
                sb.append(del);
                sb.append(p.getPattern());
                del = ", ";
            }
            this.warning(sb.toString(), new Object[0]);
        }
    }

    private void doExpand(Jar jar, Map<Instruction, Map<String, String>> included, Jar classpathEntry, Set<Instruction> superfluous) {
        block6: for (Map.Entry<String, Map<String, Resource>> directory : classpathEntry.getDirectories().entrySet()) {
            String pack;
            Instruction instr;
            String path = directory.getKey();
            if (doNotCopy.matcher(this.getName(path)).matches() || directory.getValue() == null || (instr = this.matches(included, pack = path.replace('/', '.'), superfluous)) == null || instr.isNegated()) continue;
            Map<String, Resource> contents = directory.getValue();
            boolean overwriteResource = true;
            if (jar.hasDirectory(path)) {
                Map<String, String> directives = included.get(instr);
                switch (this.getSplitStrategy(directives.get("-split-package:"))) {
                    case 1: {
                        overwriteResource = true;
                        break;
                    }
                    case 2: {
                        overwriteResource = false;
                        break;
                    }
                    case 3: {
                        this.error(this.diagnostic(pack, this.getClasspath(), classpathEntry.source), new Object[0]);
                        continue block6;
                    }
                    case 4: {
                        continue block6;
                    }
                    default: {
                        this.warning(this.diagnostic(pack, this.getClasspath(), classpathEntry.source), new Object[0]);
                        overwriteResource = false;
                    }
                }
            }
            jar.addDirectory(contents, overwriteResource);
            String key = String.valueOf(path) + "/bnd.info";
            Resource r = jar.getResource(key);
            if (r != null) {
                jar.putResource(key, new PreprocessResource(this, r));
            }
            if (!this.hasSources()) continue;
            String srcPath = "OSGI-OPT/src/" + path;
            Map<String, Resource> srcContents = classpathEntry.getDirectories().get(srcPath);
            if (srcContents == null) continue;
            jar.addDirectory(srcContents, overwriteResource);
        }
    }

    private String diagnostic(String pack, List<Jar> classpath, File source) {
        pack = pack.replace('.', '/');
        ArrayList<Jar> culprits = new ArrayList<Jar>();
        for (Jar culprit : classpath) {
            if (!culprit.getDirectories().containsKey(pack)) continue;
            culprits.add(culprit);
        }
        return "Split package " + pack + "\nUse directive -split-package:=(merge-first|merge-last|error|first) on Export/Private Package instruction to get rid of this warning\n" + "Package found in   " + culprits + "\n" + "Reference from     " + source + "\n" + "Classpath          " + classpath;
    }

    private int getSplitStrategy(String type) {
        if (type == null) {
            return 0;
        }
        if (type.equals("merge-last")) {
            return 1;
        }
        if (type.equals("merge-first")) {
            return 2;
        }
        if (type.equals("error")) {
            return 3;
        }
        if (type.equals("first")) {
            return 4;
        }
        this.error("Invalid strategy for split-package: " + type, new Object[0]);
        return 0;
    }

    private Instruction matches(Map<Instruction, Map<String, String>> instructions, String pack, Set<Instruction> superfluousPatterns) {
        for (Instruction pattern : instructions.keySet()) {
            if (!pattern.matches(pack)) continue;
            superfluousPatterns.remove(pattern);
            return pattern;
        }
        return null;
    }

    private Map<String, Map<String, String>> getHeader(String string) {
        if (string == null) {
            return Collections.emptyMap();
        }
        return this.parseHeader(this.getProperty(string));
    }

    private void doIncludeResources(Jar jar) throws Exception {
        String includes = this.getProperty("Bundle-Includes");
        if (includes == null) {
            includes = this.getProperty("-includeresource");
            if (includes == null) {
                includes = this.getProperty("Include-Resource");
            }
        } else {
            this.warning("Please use -includeresource instead of Bundle-Includes", new Object[0]);
        }
        if (includes == null) {
            return;
        }
        Map<String, Map<String, String>> clauses = this.parseHeader(includes);
        for (Map.Entry<String, Map<String, String>> entry : clauses.entrySet()) {
            this.doIncludeResource(jar, entry.getKey(), entry.getValue());
        }
    }

    private void doIncludeResource(Jar jar, String name, Map<String, String> extra) throws ZipException, IOException, Exception {
        boolean preprocess = false;
        if (name.startsWith("{") && name.endsWith("}")) {
            preprocess = true;
            name = name.substring(1, name.length() - 1).trim();
        }
        if (name.startsWith("@")) {
            this.extractFromJar(jar, name.substring(1));
        } else if (extra.containsKey("literal")) {
            String literal = extra.get("literal");
            EmbeddedResource r = new EmbeddedResource(literal.getBytes("UTF-8"), 0L);
            String x = extra.get("extra");
            if (x != null) {
                r.setExtra(x);
            }
            jar.putResource(name, r);
        } else {
            String destinationPath;
            File sourceFile;
            String source;
            String[] parts = name.split("\\s*=\\s*");
            if (parts.length == 1) {
                source = parts[0];
                sourceFile = this.getFile(source);
                destinationPath = sourceFile.isDirectory() ? "" : sourceFile.getName();
            } else {
                source = parts[1];
                sourceFile = this.getFile(source);
                destinationPath = parts[0];
                if (sourceFile.isDirectory()) {
                    destinationPath = this.doResourceDirectory(jar, extra, preprocess, sourceFile, destinationPath);
                    return;
                }
            }
            if (!sourceFile.exists()) {
                this.noSuchFile(jar, name, extra, source, destinationPath);
            } else {
                this.copy(jar, destinationPath, sourceFile, preprocess, extra);
            }
        }
    }

    private String doResourceDirectory(Jar jar, Map<String, String> extra, boolean preprocess, File sourceFile, String destinationPath) throws Exception {
        File[] files;
        String filter = extra.get("filter:");
        boolean flatten = Builder.isTrue(extra.get("flatten:"));
        boolean recursive = true;
        String directive = extra.get("recursive:");
        if (directive != null) {
            recursive = Builder.isTrue(directive);
        }
        InstructionFilter iFilter = null;
        iFilter = filter != null ? new InstructionFilter(Instruction.getPattern(filter), recursive) : new InstructionFilter(null, recursive);
        destinationPath = this.checkDestinationPath(destinationPath);
        File[] fileArray = files = this.resolveFiles(sourceFile, iFilter, recursive);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String dp;
            File file = fileArray[n2];
            dp = flatten ? (destinationPath.length() == 0 ? file.getName() : String.valueOf(destinationPath) + "/" + file.getName()) : ((dp = String.valueOf(destinationPath) + file.getParentFile().getAbsolutePath().substring(sourceFile.getAbsolutePath().length())).length() > 0 ? String.valueOf(dp) + "/" + file.getName() : file.getName());
            this.copy(jar, dp, file, preprocess, extra);
            ++n2;
        }
        return destinationPath;
    }

    private String checkDestinationPath(String destinationPath) {
        if (destinationPath.endsWith("/")) {
            destinationPath = destinationPath.substring(0, destinationPath.length() - 1);
        }
        return destinationPath;
    }

    private File[] resolveFiles(File dir, FileFilter filter, boolean recursive) {
        return this.resolveFiles(dir, filter, null, recursive);
    }

    private File[] resolveFiles(File dir, FileFilter filter, File[] files, boolean recursive) {
        File[] fs;
        if (files == null) {
            files = EMPTY_FILE;
        }
        if (Analyzer.doNotCopy.matcher(dir.getName()).matches()) {
            return files;
        }
        File[] fileArray = fs = dir.listFiles(filter);
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (recursive) {
                    files = this.resolveFiles(file, filter, files, recursive);
                }
            } else if (files.length == 0) {
                files = new File[]{file};
            } else {
                File[] newFiles = new File[files.length + 1];
                System.arraycopy(files, 0, newFiles, 0, files.length);
                newFiles[newFiles.length - 1] = file;
                files = newFiles;
            }
            ++n2;
        }
        return files;
    }

    private void noSuchFile(Jar jar, String clause, Map<String, String> extra, String source, String destinationPath) throws Exception {
        Jar src = this.getJarFromName(source, "Include-Resource " + source);
        if (src != null) {
            JarResource jarResource = new JarResource(src);
            jar.putResource(destinationPath, jarResource);
        } else {
            Resource lastChance = this.make.process(source);
            if (lastChance != null) {
                String x = extra.get("extra");
                if (x != null) {
                    lastChance.setExtra(x);
                }
                jar.putResource(destinationPath, lastChance);
            } else {
                this.error("Input file does not exist: " + source, new Object[0]);
            }
        }
    }

    private void extractFromJar(Jar jar, String name) throws ZipException, IOException {
        Jar sub;
        int n = name.lastIndexOf("!/");
        Pattern filter = null;
        if (n > 0) {
            String fstring = name.substring(n + 2);
            name = name.substring(0, n);
            filter = this.wildcard(fstring);
        }
        if ((sub = this.getJarFromName(name, "extract from jar")) == null) {
            this.error("Can not find JAR file " + name, new Object[0]);
        } else {
            jar.addAll(sub, filter);
        }
    }

    private Pattern wildcard(String spec) {
        StringBuffer sb = new StringBuffer();
        int j = 0;
        while (j < spec.length()) {
            char c = spec.charAt(j);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    break;
                }
                case '*': {
                    if (j < spec.length() - 1 && spec.charAt(j + 1) == '*') {
                        sb.append(".*");
                        ++j;
                        break;
                    }
                    sb.append("[^/]*");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++j;
        }
        String s = sb.toString();
        try {
            return Pattern.compile(s);
        }
        catch (Exception e) {
            this.error("Invalid regular expression on wildcarding: " + spec + " used *", new Object[0]);
            return null;
        }
    }

    private void copy(Jar jar, String path, File from, boolean preprocess, Map<String, String> extra) throws Exception {
        if (doNotCopy.matcher(from.getName()).matches()) {
            return;
        }
        if (from.isDirectory()) {
            String next = path;
            if (next.length() != 0 && !next.endsWith("/")) {
                next = String.valueOf(next) + '/';
            }
            File[] files = from.listFiles();
            int i = 0;
            while (i < files.length) {
                this.copy(jar, String.valueOf(next) + files[i].getName(), files[i], preprocess, extra);
                ++i;
            }
        } else if (from.exists()) {
            String x;
            Resource resource = new FileResource(from);
            if (preprocess) {
                resource = new PreprocessResource(this, resource);
            }
            if ((x = extra.get("extra")) != null) {
                resource.setExtra(x);
            }
            if (path.endsWith("/")) {
                path = String.valueOf(path) + from.getName();
            }
            jar.putResource(path, resource);
        } else {
            this.error("Input file does not exist: " + from, new Object[0]);
        }
    }

    private String getName(String where) {
        int n = where.lastIndexOf(47);
        if (n < 0) {
            return where;
        }
        return where.substring(n + 1);
    }

    public void setSourcepath(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.addSourcepath(files[i]);
            ++i;
        }
    }

    public void addSourcepath(File cp) {
        if (!cp.exists()) {
            this.warning("File on sourcepath that does not exist: " + cp, new Object[0]);
        }
        this.sourcePath.add(cp);
    }

    public void doPom(Jar dot) throws FileNotFoundException, IOException {
        Manifest manifest = dot.getManifest();
        String name = manifest.getMainAttributes().getValue("Bundle-Name");
        String description = manifest.getMainAttributes().getValue("Bundle-Description");
        String docUrl = manifest.getMainAttributes().getValue("Bundle-DocURL");
        String version = manifest.getMainAttributes().getValue("Bundle-Version");
        String bundleVendor = manifest.getMainAttributes().getValue("Bundle-Vendor");
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(s);
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        String licenses = manifest.getMainAttributes().getValue("Bundle-License");
        if (bsn == null) {
            this.error("Can not create POM unless Bundle-SymbolicName is set", new Object[0]);
            return;
        }
        int n = (bsn = bsn.trim()).lastIndexOf(46);
        if (n <= 0) {
            this.error("Can not create POM unless Bundle-SymbolicName contains a .", new Object[0]);
            ps.close();
            s.close();
            return;
        }
        String groupId = bsn.substring(0, n);
        String artifactId = bsn.substring(n + 1);
        ps.println("<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>");
        ps.println("  <modelVersion>4.0.0</modelVersion>");
        ps.println("  <groupId>" + groupId + "</groupId>");
        n = artifactId.indexOf(59);
        if (n > 0) {
            artifactId = artifactId.substring(0, n).trim();
        }
        ps.println("  <artifactId>" + artifactId + "</artifactId>");
        ps.println("  <version>" + version + "</version>");
        if (description != null) {
            ps.println("  <description>");
            ps.print("    ");
            ps.println(description);
            ps.println("  </description>");
        }
        if (name != null) {
            ps.print("  <name>");
            ps.print(name);
            ps.println("</name>");
        }
        if (docUrl != null) {
            ps.print("  <url>");
            ps.print(docUrl);
            ps.println("</url>");
        }
        if (bundleVendor != null) {
            Matcher m = this.NAME_URL.matcher(bundleVendor);
            String namePart = bundleVendor;
            String urlPart = null;
            if (m.matches()) {
                namePart = m.group(1);
                urlPart = m.group(2);
            }
            ps.println("  <organization>");
            ps.print("    <name>");
            ps.print(namePart.trim());
            ps.println("</name>");
            if (urlPart != null) {
                ps.print("    <url>");
                ps.print(urlPart.trim());
                ps.println("</url>");
            }
            ps.println("  </organization>");
        }
        if (licenses != null) {
            ps.println("  <licenses>");
            Map<String, Map<String, String>> map = this.parseHeader(licenses);
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                ps.println("    <license>");
                Map<String, String> values = entry.getValue();
                this.print(ps, values, "name", "name", values.get("url"));
                this.print(ps, values, "url", "url", null);
                this.print(ps, values, "distribution", "distribution", "repo");
                ps.println("    </license>");
            }
            ps.println("  </licenses>");
        }
        ps.println("</project>");
        ps.close();
        s.close();
        dot.putResource("pom.xml", new EmbeddedResource(s.toByteArray(), 0L));
    }

    private void print(PrintStream ps, Map<String, String> values, String string, String tag, String object) {
        String value = values.get(string);
        if (value == null) {
            value = object;
        }
        if (value == null) {
            return;
        }
        ps.println("    <" + tag + ">" + value.trim() + "</" + tag + ">");
    }

    @Override
    public void close() {
        super.close();
    }

    public Jar[] builds() throws Exception {
        this.begin();
        String conduit = this.getProperty("-conduit");
        if (conduit != null) {
            Map<String, Map<String, String>> map = this.parseHeader(conduit);
            Jar[] result = new Jar[map.size()];
            int n = 0;
            for (String file : map.keySet()) {
                Jar c = new Jar(this.getFile(file));
                this.addClose(c);
                String name = map.get(file).get("name");
                if (name != null) {
                    c.setName(name);
                }
                result[n++] = c;
            }
            return result;
        }
        String sub = this.getProperty("-sub");
        if (sub == null) {
            Jar jar = this.build();
            if (jar == null) {
                return new Jar[0];
            }
            return new Jar[]{jar};
        }
        ArrayList<Jar> result = new ArrayList<Jar>();
        Set<Instruction> subs = Builder.replaceWitInstruction(this.parseHeader(sub), "-sub").keySet();
        ArrayList members = new ArrayList(Arrays.asList(this.getBase().listFiles()));
        this.getProperties().remove("-sub");
        block3: while (members.size() > 0) {
            File file = (File)members.remove(0);
            if (file.equals(this.getPropertiesFile())) continue;
            for (Instruction instruction : subs) {
                if (!instruction.matches(file.getName())) continue;
                if (instruction.isNegated()) continue block3;
                Builder builder = null;
                try {
                    builder = this.getSubBuilder();
                    this.addClose(builder);
                    builder.setProperties(file);
                    builder.setProperty("-sub", "");
                    Jar jar = builder.build();
                    jar.setName(builder.getBsn());
                    result.add(jar);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error("Sub Building " + file, e, new Object[0]);
                }
                if (builder == null) continue block3;
                this.getInfo(builder, String.valueOf(file.getName()) + ": ");
                continue block3;
            }
        }
        this.setProperty("-sub", sub);
        return result.toArray(new Jar[result.size()]);
    }

    public Builder getSubBuilder() throws Exception {
        Builder builder = new Builder(this);
        builder.setBase(this.getBase());
        for (Jar file : this.getClasspath()) {
            builder.addClasspath(file);
        }
        return builder;
    }

    public String _maven_version(String[] args) {
        if (args.length > 2) {
            this.error("${maven_version} macro receives too many arguments " + Arrays.toString(args), new Object[0]);
        } else if (args.length < 2) {
            this.error("${maven_version} macro has no arguments, use ${maven_version;1.2.3-SNAPSHOT}", new Object[0]);
        } else {
            return Builder.cleanupVersion(args[1]);
        }
        return null;
    }

    public String _permissions(String[] args) throws IOException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if ("packages".equals(arg) || "all".equals(arg)) {
                for (String imp : this.getImports().keySet()) {
                    if (imp.startsWith("java.")) continue;
                    sb.append("(org.osgi.framework.PackagePermission \"");
                    sb.append(imp);
                    sb.append("\" \"import\")\r\n");
                }
                for (String exp : this.getExports().keySet()) {
                    sb.append("(org.osgi.framework.PackagePermission \"");
                    sb.append(exp);
                    sb.append("\" \"export\")\r\n");
                }
            } else if ("admin".equals(arg) || "all".equals(arg)) {
                sb.append("(org.osgi.framework.AdminPermission)");
            } else if (!"permissions".equals(arg)) {
                this.error("Invalid option in ${permissions}: %s", arg);
            }
            ++n2;
        }
        return sb.toString();
    }

    public void removeBundleSpecificHeaders() {
        HashSet<String> set = new HashSet<String>((Collection)Arrays.asList(BUNDLE_SPECIFIC_HEADERS));
        this.setForceLocal(set);
    }
}

