/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private byte[] secretPlain;
    private byte[] secretCipher = null;
    private KeySpec spec;
    private SecretKey secretKey;
    private Cipher cipher;
    private byte[] password;
    private byte[] salt = null;
    private byte[] iv;
    private boolean initAESDone;
    private int strength;

    public Crypto() {
        this.clearPlain();
        this.initAESDone = false;
        this.strength = 256;
    }

    public Crypto(byte[] input) {
        this.clearPlain();
        this.initAESDone = false;
        this.secretPlain = input;
        this.strength = 256;
    }

    public void updateSecret(byte[] input) {
        this.secretPlain = input;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) throws InvalidKeyLengthException {
        if (strength != 128 && strength != 192 && strength != 256) {
            throw new InvalidKeyLengthException(strength + " bit keys are not supported.");
        }
        this.strength = strength;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void setIV(byte[] iv) {
        this.iv = iv;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getSecretCipher() {
        return this.secretCipher;
    }

    public void initAES() throws Exception {
        if (this.password == null) {
            throw new Exception("password is null");
        }
        SecretKeyFactory factory = null;
        try {
            factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (this.salt == null) {
            this.salt = SecureRandom.getSeed(8);
        }
        String pass = null;
        try {
            pass = new String(this.password, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("for some reason UTF-16 is not a valid encoding");
            e.printStackTrace();
        }
        try {
            int maxBits = Cipher.getMaxAllowedKeyLength("AES");
            if (maxBits < this.strength) {
                System.out.println("This system only supports up to " + maxBits + " bit encryption, using that strength.");
                this.strength = maxBits;
            }
            this.spec = new PBEKeySpec(pass.toCharArray(), this.salt, 65536, this.strength);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        SecretKey tmp = null;
        try {
            tmp = factory.generateSecret(this.spec);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        this.secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        this.initAESDone = true;
    }

    public void initAES(byte[] password) {
        this.password = password;
        SecretKeyFactory factory = null;
        try {
            factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (this.salt == null) {
            this.salt = SecureRandom.getSeed(8);
        }
        String pass = null;
        try {
            pass = new String(password, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("for some reason UTF-16 is not a valid encoding");
            e.printStackTrace();
        }
        try {
            int maxBits = Cipher.getMaxAllowedKeyLength("AES");
            if (maxBits < this.strength) {
                System.out.println("This system only supports up to " + maxBits + " bit encryption, using that strength.");
                this.strength = maxBits;
            }
            this.spec = new PBEKeySpec(pass.toCharArray(), this.salt, 65536, this.strength);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        SecretKey tmp = null;
        try {
            tmp = factory.generateSecret(this.spec);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        this.secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        this.initAESDone = true;
    }

    public void doAESEncryption() throws Exception {
        if (!this.initAESDone) {
            this.initAES();
        }
        this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        this.cipher.init(1, this.secretKey);
        AlgorithmParameters params = this.cipher.getParameters();
        this.iv = params.getParameterSpec(IvParameterSpec.class).getIV();
        this.secretCipher = this.cipher.doFinal(this.secretPlain);
        this.clearPlain();
    }

    public void doAESDecryption(byte[] salt, byte[] iv) throws Exception {
        this.setSalt(salt);
        if (!this.initAESDone) {
            this.initAES();
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)this.secretKey, new IvParameterSpec(iv));
        this.secretPlain = cipher.doFinal(this.secretCipher);
    }

    public byte[] getSecretPlain() {
        return this.secretPlain;
    }

    public void setSecretPlain(byte[] secretPlain) {
        this.secretPlain = secretPlain;
    }

    public void setSecretCipher(byte[] secretCipher) {
        this.secretCipher = secretCipher;
    }

    public static EncryptionResult getAESEncryption(byte[] secret, byte[] password, int strength) throws InvalidKeyLengthException {
        Crypto agent = new Crypto(secret);
        agent.setStrength(strength);
        agent.initAES(password);
        try {
            agent.doAESEncryption();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EncryptionResult result = new EncryptionResult(agent.getSecretCipher(), agent.getIV(), agent.getSalt());
        return result;
    }

    public static byte[] getAESDecryption(byte[] secret, byte[] password, byte[] salt, byte[] iv, int strength) throws InvalidKeyLengthException {
        Crypto agent = new Crypto();
        agent.setStrength(strength);
        agent.setSalt(salt);
        agent.setSecretCipher(secret);
        agent.initAES(password);
        try {
            agent.doAESDecryption(salt, iv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] secretResult = agent.getSecretPlain();
        agent.clearPlain();
        return secretResult;
    }

    public void clearPlain() {
        this.secretPlain = null;
        this.password = null;
        this.spec = null;
        this.secretKey = null;
        this.cipher = null;
    }

    public class InvalidKeyLengthException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidKeyLengthException() {
        }

        public InvalidKeyLengthException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public InvalidKeyLengthException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidKeyLengthException(String message) {
            super(message);
        }

        public InvalidKeyLengthException(Throwable cause) {
            super(cause);
        }
    }

    public static class EncryptionResult
    implements Serializable {
        private byte[] output;
        private byte[] iv;
        private byte[] salt;

        public EncryptionResult(byte[] output, byte[] iv, byte[] salt) {
            this.output = output;
            this.iv = iv;
            this.salt = salt;
        }

        public EncryptionResult(byte[] simpleSerial) {
            byte ivLength = simpleSerial[0];
            int outputLength = simpleSerial.length - ivLength;
            this.iv = new byte[ivLength];
            this.output = new byte[outputLength];
            System.arraycopy(simpleSerial, 1, this.iv, 0, ivLength);
            System.arraycopy(simpleSerial, ivLength, this.output, 0, outputLength);
        }

        public byte[] simpleSerial() {
            byte[] out = new byte[this.output.length + this.iv.length];
            out[0] = (byte)this.iv.length;
            System.arraycopy(this.iv, 0, out, 1, this.iv.length);
            System.arraycopy(this.output, 0, out, this.iv.length, this.output.length);
            return out;
        }

        public byte[] getOutput() {
            return this.output;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public byte[] getSalt() {
            return this.salt;
        }
    }
}

