/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.crypto.HistoricSHE;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedOutputStream
extends FilterOutputStream {
    private HistoricSHE cipher;
    public boolean padOnClose;

    public EncryptedOutputStream(OutputStream out, HistoricSHE cipher) {
        super(out);
        if (!cipher.isConfigured()) {
            throw new RuntimeException("Cipher not configured.");
        }
        this.padOnClose = false;
        this.cipher = cipher;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(this.cipher.update(new byte[]{(byte)b}));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(this.cipher.update(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] todo = new byte[len];
        System.arraycopy(b, off, todo, 0, len);
        this.write(todo);
    }

    @Override
    public void close() throws IOException {
        if (this.padOnClose) {
            this.out.write(this.cipher.doFinal());
        }
        this.out.close();
    }

    public HistoricSHE getCipher() {
        return this.cipher;
    }
}

