/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.crypto.Crypto;
import black.door.crypto.Hash;
import black.door.util.Misc;
import java.security.SecureRandom;
import java.util.Arrays;

public class ExperimentalCrypto {
    public static byte[] doSHEBlock(Block block, byte[] key) {
        if (key.length < 16) {
            throw new RuntimeException("Key too short");
        }
        if (block.getIV().length < 32) {
            throw new RuntimeException("IV too short.");
        }
        if (block.getText().length != 32) {
            throw new RuntimeException("Block is not 256 bits.");
        }
        byte[] iv = new byte[32];
        System.arraycopy(block.getIV(), 0, iv, 0, iv.length);
        int n = block.getBlockNo() % 32;
        iv[n] = (byte)(iv[n] + (block.getBlockNo() + 1));
        return Misc.XOR(block.getText(), Hash.getSHA256(Misc.XOR(key, iv)));
    }

    private static byte[] getSHEBlock(Block block, byte[] key) {
        byte[] iv = new byte[32];
        System.arraycopy(block.getIV(), 0, iv, 0, iv.length);
        int n = block.getBlockNo() % 32;
        iv[n] = (byte)(iv[n] + (block.getBlockNo() + 1));
        return Misc.XOR(block.getText(), Hash.getSHA256(Misc.XOR(key, iv)));
    }

    public static Crypto.EncryptionResult doSHE(byte[] input, byte[] key, byte[] IV) {
        if (input.length % 32 != 0) {
            int length = input.length;
            input = Arrays.copyOf(input, (input.length / 32 + 1) * 32);
            input[length] = 69;
        }
        int numBlocks = input.length / 32;
        if (key.length < 16) {
            throw new RuntimeException("Key too short");
        }
        if (IV == null) {
            SecureRandom random = new SecureRandom();
            IV = new byte[32];
            random.nextBytes(IV);
        } else if (IV.length < 32) {
            throw new RuntimeException("IV too short.");
        }
        byte[] tmp = new byte[32];
        Block block = new Block(0, null, IV);
        for (int i = 0; i < numBlocks; ++i) {
            System.arraycopy(input, i * 32, tmp, 0, 32);
            block.setBlockNo(i);
            block.setText(tmp);
            System.arraycopy(ExperimentalCrypto.getSHEBlock(block, key), 0, input, i * 32, 32);
        }
        tmp = null;
        block = null;
        System.gc();
        int endIndex = input.length - 1;
        while (input[endIndex] == 0) {
            if (input[--endIndex] != 69) continue;
            --endIndex;
            break;
        }
        return new Crypto.EncryptionResult(Arrays.copyOf(input, endIndex + 1), IV, null);
    }

    public static class Block {
        private int blockNo;
        private byte[] text;
        private byte[] IV;

        public Block(int blockNo, byte[] text, byte[] iV) {
            this.blockNo = blockNo;
            this.text = text;
            this.IV = iV;
        }

        public String toString() {
            return "SHEBlock [blockNo=" + this.blockNo + ", text=" + Arrays.toString(this.text) + ", IV=" + Arrays.toString(this.IV) + "]";
        }

        public byte[] getText() {
            return this.text;
        }

        public void setText(byte[] text) {
            this.text = text;
        }

        public byte[] getIV() {
            return this.IV;
        }

        public void setIV(byte[] iV) {
            this.IV = iV;
        }

        public int getBlockNo() {
            return this.blockNo;
        }

        public void setBlockNo(int blockNo) {
            this.blockNo = blockNo;
        }
    }
}

