/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.struct.ByteQueue;
import black.door.util.Misc;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class HistoricSHE {
    public int blockSize;
    private int blockNo;
    private byte[] IV;
    private byte[] key;
    private byte[] prehash;
    private boolean cfg;
    private byte[] buffer;
    private int bufferIndex;
    private MessageDigest mD;

    public HistoricSHE(String algorithm) throws NoSuchAlgorithmException {
        this.buffer = new byte[this.blockSize];
        this.blockNo = 0;
        this.cfg = false;
        this.mD = MessageDigest.getInstance(algorithm);
        this.blockSize = this.mD.getDigestLength();
    }

    public HistoricSHE(Algorithm algorithm) {
        this.buffer = new byte[this.blockSize];
        this.blockNo = 0;
        this.cfg = false;
        try {
            this.mD = MessageDigest.getInstance(algorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        this.blockSize = this.mD.getDigestLength();
    }

    public HistoricSHE() {
        this.buffer = new byte[this.blockSize];
        this.blockSize = 32;
        this.blockNo = 0;
        this.cfg = false;
        try {
            this.mD = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public byte[] init(byte[] key) {
        byte[] iv = new byte[this.blockSize];
        new SecureRandom().nextBytes(iv);
        this.init(iv, key);
        return iv;
    }

    public void init(byte[] IV, byte[] key) {
        if (IV.length != this.blockSize || key.length != this.blockSize) {
            throw new RuntimeException("key and IV need to be same as block size (" + this.blockSize + ").");
        }
        this.key = key;
        this.IV = IV;
        this.prehash = Misc.cleanXOR(IV, key);
        this.cfg = true;
        this.blockNo = 0;
        this.buffer = new byte[this.blockSize];
        this.bufferIndex = 0;
    }

    private byte[] cryptBlock() {
        int i = this.blockNo % this.blockSize;
        int inc = this.blockNo / this.blockSize + 1;
        int n = i;
        this.prehash[n] = (byte)(this.prehash[n] ^ this.key[i]);
        int n2 = i;
        this.prehash[n2] = (byte)(this.prehash[n2] + inc);
        int n3 = i;
        this.prehash[n3] = (byte)(this.prehash[n3] ^ this.key[i]);
        byte[] ret = Misc.XORintoA(this.mD.digest(this.prehash), this.buffer);
        int n4 = i;
        this.prehash[n4] = (byte)(this.prehash[n4] ^ this.key[i]);
        int n5 = i;
        this.prehash[n5] = (byte)(this.prehash[n5] - inc);
        int n6 = i;
        this.prehash[n6] = (byte)(this.prehash[n6] ^ this.key[i]);
        return ret;
    }

    public boolean isConfigured() {
        return this.cfg;
    }

    public byte[] update(byte[] input) {
        if (!this.cfg) {
            throw new RuntimeException("Cipher not configured.");
        }
        if (input.length == 0) {
            return new byte[0];
        }
        if (this.bufferIndex != 0) {
            byte[] in2 = Arrays.copyOf(this.buffer, input.length + this.bufferIndex);
            System.arraycopy(input, 0, in2, this.bufferIndex, input.length);
            input = in2;
        }
        int numBlocks = (int)Math.floor(input.length / this.blockSize);
        byte[] out = new byte[this.blockSize * numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            System.arraycopy(input, this.blockSize * i, this.buffer, 0, this.blockSize);
            System.arraycopy(this.cryptBlock(), 0, out, i * this.blockSize, this.blockSize);
            ++this.blockNo;
        }
        this.buffer = new byte[this.blockSize];
        if (input.length % this.blockSize == 0) {
            this.bufferIndex = 0;
        } else {
            System.arraycopy(input, numBlocks * this.blockSize, this.buffer, 0, input.length - numBlocks * this.blockSize);
            this.bufferIndex = input.length - numBlocks * this.blockSize;
        }
        return out;
    }

    public byte[] doFinal() {
        return this.doFinal(new byte[0]);
    }

    public byte[] doFinal(byte[] input) {
        byte[] out;
        byte[] main = this.update(input);
        if (this.bufferIndex != 0) {
            this.buffer[this.bufferIndex] = 105;
            ++this.bufferIndex;
            this.buffer = this.cryptBlock();
            out = new byte[main.length + this.buffer.length];
            System.arraycopy(main, 0, out, 0, main.length);
            System.arraycopy(this.buffer, 0, out, main.length, this.buffer.length);
        } else {
            int endIndex = main.length - 1;
            while (main[endIndex] == 0 || main[endIndex] == 105) {
                if (--endIndex == 0 || main[endIndex] != 105) continue;
                --endIndex;
                break;
            }
            out = new byte[endIndex + 1];
            System.arraycopy(main, 0, out, 0, endIndex + 1);
        }
        this.blockNo = 0;
        this.IV = null;
        this.key = null;
        this.cfg = false;
        this.bufferIndex = 0;
        return out;
    }

    public class Algorithm {
        public static final String SHA1 = "SHA-1";
        public static final String SHA256 = "SHA-256";
        public static final String SHA384 = "SHA-384";
        public static final String SHA512 = "SHA-512";
        private String algo;

        public Algorithm(String algorithm) {
            if (!(algorithm.equals(SHA1) && algorithm.equals(SHA256) && algorithm.equals(SHA384) && algorithm.equals(SHA512))) {
                throw new RuntimeException("Invalid algorithm " + algorithm);
            }
            this.algo = algorithm;
        }

        public String getAlgorithm() {
            return this.algo;
        }

        public void setAlgorithm(String algo) {
            if (!(algo.equals(SHA1) && algo.equals(SHA256) && algo.equals(SHA384) && algo.equals(SHA512))) {
                throw new RuntimeException("Invalid algorithm " + algo);
            }
            this.algo = algo;
        }
    }

    public static class EncryptionResult
    implements Serializable {
        private static final long serialVersionUID = -6451163680434801851L;
        private byte[] text;
        private byte[] iv;

        public EncryptionResult(byte[] iv, byte[] text) {
            this.text = text;
            this.iv = iv;
        }

        public EncryptionResult(byte[] simpleSerial) {
            byte ivLength = simpleSerial[0];
            int outputLength = simpleSerial.length - ivLength - 1;
            this.iv = new byte[ivLength];
            this.text = new byte[outputLength];
            System.arraycopy(simpleSerial, 1, this.iv, 0, ivLength);
            System.arraycopy(simpleSerial, ivLength + 1, this.text, 0, outputLength);
        }

        public byte[] simpleSerial() {
            byte[] out = new byte[this.text.length + this.iv.length + 1];
            out[0] = (byte)this.iv.length;
            System.arraycopy(this.iv, 0, out, 1, this.iv.length);
            System.arraycopy(this.text, 0, out, this.iv.length + 1, this.text.length);
            return out;
        }

        public byte[] getText() {
            return this.text;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public String toString() {
            return "EncryptionResult [iv=" + Misc.bytesToHex(this.iv) + "[text=" + Misc.bytesToHex(this.text) + "]\n" + Misc.bytesToHex(this.simpleSerial());
        }
    }

    public static class EncryptedInputStream
    extends FilterInputStream {
        private HistoricSHE cipher;
        private ByteQueue buffer;

        public EncryptedInputStream(InputStream in, HistoricSHE cipher) {
            super(in);
            if (!cipher.isConfigured()) {
                throw new RuntimeException("Cipher not configured.");
            }
            this.cipher = cipher;
            this.buffer = new ByteQueue(cipher.blockSize * 2);
            this.buffer.setResizable(true);
        }

        private void bufferBlock() throws IOException {
            byte[] plainText = new byte[this.cipher.blockSize];
            this.in.read(plainText);
            this.buffer.enQueue(this.cipher.update(plainText));
        }

        private void bufferBytes(int size) throws IOException {
            while (this.buffer.filled() < size) {
                this.bufferBlock();
            }
        }

        @Override
        public int read() throws IOException {
            try {
                return this.buffer.deQueue(1)[0];
            }
            catch (BufferUnderflowException e) {
                this.bufferBlock();
                return this.read();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.bufferBytes(len - off);
            this.buffer.deQueue(b, off, len);
            return len - off;
        }
    }

    public static class EncryptedOutputStream
    extends FilterOutputStream {
        private HistoricSHE cipher;
        public boolean padOnClose;

        public EncryptedOutputStream(OutputStream out, HistoricSHE cipher) {
            super(out);
            if (!cipher.isConfigured()) {
                throw new RuntimeException("Cipher not configured.");
            }
            this.padOnClose = false;
            this.cipher = cipher;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(this.cipher.update(new byte[]{(byte)b}));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(this.cipher.update(b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] todo = new byte[len];
            System.arraycopy(b, off, todo, 0, len);
            this.write(todo);
        }

        @Override
        public void close() throws IOException {
            if (this.padOnClose) {
                this.out.write(this.cipher.doFinal());
            }
            this.out.close();
        }

        public HistoricSHE getCipher() {
            return this.cipher;
        }
    }
}

