/*
 * Decompiled with CFR 0.152.
 */
package black.door.json;

import black.door.json.Derulo;
import black.door.json.JsonObject;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonHasher {
    private static final int DEFAULT_DIGEST_SIZE = 16;
    private List<String> ignoredFields;
    private Map<String, Object> json;
    private MessageDigest digest;

    public static byte[] hash(Map<String, Object> json) {
        try {
            return Arrays.copyOf(JsonHasher.hash(json, MessageDigest.getInstance("SHA-256")), 16);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] hash(Map<String, Object> json, MessageDigest digest) {
        digest.reset();
        byte[] hash = digest.digest(JsonHasher.canonicalize(json).toString().getBytes(StandardCharsets.UTF_8));
        digest.reset();
        return hash;
    }

    protected static CharSequence canonicalize(Map obj) {
        LinkedList<String> fieldNames = new LinkedList<String>();
        HashMap originalKeys = new HashMap();
        for (Object e : obj.keySet()) {
            String toString = e.toString();
            originalKeys.put(toString, e);
            fieldNames.add(toString);
        }
        Collections.sort(fieldNames);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (String field : fieldNames) {
            sb.append('\"');
            sb.append(field);
            sb.append('\"');
            sb.append(':');
            sb.append(JsonHasher.canonicalize(obj.get(originalKeys.get(field))));
            sb.append(',');
        }
        if (sb.lastIndexOf("{") != sb.length() - 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
        return sb;
    }

    protected static CharSequence canonicalize(Collection obj) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object e : obj) {
            sb.append(JsonHasher.canonicalize(e));
            sb.append(',');
        }
        if (sb.lastIndexOf("[") != sb.length() - 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb;
    }

    protected static CharSequence canonicalize(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Map) {
            return JsonHasher.canonicalize((Map)obj);
        }
        if (obj instanceof Collection) {
            return JsonHasher.canonicalize((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < Array.getLength(obj); ++i) {
                sb.append(JsonHasher.canonicalize(Array.get(obj, i)));
                sb.append(',');
            }
            sb.append(']');
            return sb;
        }
        return Derulo.toJSON(obj);
    }

    public JsonHasher(String json) {
        this(new JsonObject(json));
    }

    public JsonHasher(Map<String, Object> json) {
        this.json = json;
        this.ignoredFields = new LinkedList<String>();
    }

    public byte[] hash() {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.json);
        for (String field : this.ignoredFields) {
            copy.remove(field);
        }
        if (this.digest == null) {
            return JsonHasher.hash(copy);
        }
        return JsonHasher.hash(copy, this.digest);
    }

    public List<String> getIgnoredFields() {
        return this.ignoredFields;
    }

    public void setIgnoredFields(List<String> ignoredFields) {
        this.ignoredFields = ignoredFields;
    }

    public JsonHasher addIgnoredField(String fieldName) {
        this.ignoredFields.add(fieldName);
        return this;
    }

    private MessageDigest getDigest() {
        return this.digest;
    }

    public void setDigest(MessageDigest digest) {
        this.digest = digest;
    }

    public Map<String, Object> getJson() {
        return this.json;
    }

    public void setJson(Map<String, Object> json) {
        this.json = json;
    }
}

