/*
 * Decompiled with CFR 0.152.
 */
package black.door.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;

public class SocketIOWrapper {
    private Socket sock;
    protected BufferedInputStream in;
    protected OutputStream out;
    private int bvffrSz;
    private float bvffrGrwthFctr;
    private Charset ncdng;
    private int maxRead = Integer.MAX_VALUE;

    public SocketIOWrapper(Socket sock) throws IOException {
        this(sock, 0.0f, 0, null);
    }

    public SocketIOWrapper(Socket sock, float growthFactor) throws IOException {
        this(sock, growthFactor, 0, null);
    }

    public SocketIOWrapper(Socket sock, float growthFactor, int initialBufferSize) throws IOException {
        this(sock, growthFactor, initialBufferSize, null);
    }

    public SocketIOWrapper(Socket sock, float growthFactor, int initialBufferSize, Charset encoding) throws IOException {
        this.sock = sock;
        this.in = new BufferedInputStream(sock.getInputStream());
        this.out = sock.getOutputStream();
        this.setBufferGrowthFactor(growthFactor == 0.0f ? 1.25f : growthFactor);
        this.bvffrSz = initialBufferSize == 0 ? 256 : initialBufferSize;
        this.setEncoding(encoding == null ? Charset.forName("UTF-8") : encoding);
    }

    public int getMaxReadSize() {
        return this.maxRead;
    }

    public void setMaxReadSize(int maxRead) {
        this.maxRead = maxRead;
    }

    public Charset getEncoding() {
        return this.ncdng;
    }

    public void setEncoding(Charset encoding) {
        this.ncdng = encoding;
    }

    public float getBufferGrowthFactor() {
        return this.bvffrGrwthFctr;
    }

    public void setBufferGrowthFactor(float bufferGrowthFactor) {
        this.bvffrGrwthFctr = bufferGrowthFactor;
    }

    public String read() throws IOException {
        int x;
        byte[] buffer = new byte[this.bvffrSz];
        int filled = 0;
        while ((x = this.in.read()) != 0 && x != -1) {
            if (filled > this.maxRead) {
                throw new RambleOnException();
            }
            if (filled >= buffer.length) {
                buffer = Arrays.copyOf(buffer, Math.min((int)Math.ceil((float)buffer.length * this.bvffrGrwthFctr), this.maxRead));
            }
            buffer[filled] = (byte)x;
            ++filled;
        }
        return new String(buffer, 0, filled, this.ncdng);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public byte[] write(Object s) throws IOException {
        byte[] ret = null;
        ret = String.valueOf(s).getBytes(this.ncdng);
        ret = Arrays.copyOf(ret, ret.length + 1);
        this.out.write(ret);
        return ret;
    }

    public Socket getSocket() {
        return this.sock;
    }

    public void close() throws IOException {
        this.sock.close();
    }

    private static class RambleOnException
    extends RuntimeException {
        public RambleOnException() {
            super("Some input appears to be larger than we are willing to accept.");
        }
    }
}

