/*
 * Decompiled with CFR 0.152.
 */
package black.door.net.http.tools;

import black.door.net.http.tools.HttpMessage;
import black.door.net.http.tools.HttpParsingException;
import black.door.net.http.tools.HttpVerb;
import black.door.net.http.tools.ParseTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class HttpRequest
implements HttpMessage {
    private Map<String, String> headers;
    private HttpVerb verb;
    private URI uri;
    private String version;
    private byte[] body;

    public HttpRequest(HttpVerb method, URI uri, String version) {
        this.verb = method;
        this.uri = uri;
        this.version = version;
        this.headers = new HashMap<String, String>();
    }

    @Deprecated
    public HttpRequest(Socket sock) throws IOException, URISyntaxException {
        this(new BufferedInputStream(sock.getInputStream()));
    }

    @Deprecated
    public HttpRequest(byte[] request) throws IOException, URISyntaxException {
        this(new ByteArrayInputStream(request));
    }

    @Deprecated
    public HttpRequest(InputStream is) throws IOException, URISyntaxException {
        String firstLine = ParseTools.nextLine(is);
        String[] split = firstLine.split("\\s+");
        this.verb = HttpVerb.valueOf(split[0]);
        this.uri = new URI(split[1]);
        this.version = split[2];
        this.headers = ParseTools.parseHeaders(is);
        this.body = ParseTools.getBody(is, this.headers, 8192);
    }

    public static HttpRequest parse(byte[] request) throws IOException, URISyntaxException {
        return HttpRequest.parse(new ByteArrayInputStream(request), -1);
    }

    public static HttpRequest parse(InputStream is, int maxBodySize) throws IOException, URISyntaxException, HttpParsingException {
        String firstLine = ParseTools.nextLine(is);
        String[] split = firstLine.split("\\s+");
        if (split.length < 3) {
            throw new HttpParsingException("Request line does not have 3 parts as described in RFC2616 5.1");
        }
        HttpVerb verb = HttpVerb.valueOf(split[0]);
        URI uri = new URI(split[1]);
        String version = split[2];
        Map<String, String> headers = ParseTools.parseHeaders(is);
        byte[] body = ParseTools.getBody(is, headers, maxBodySize);
        HttpRequest ret = new HttpRequest(verb, uri, version);
        ret.setBody(body);
        ret.setHeaders(headers);
        return ret;
    }

    @Override
    public HttpRequest putHeader(String headerName, String value) {
        this.headers.put(headerName, value);
        return this;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public HttpVerb getVerb() {
        return this.verb;
    }

    public void setVerb(HttpVerb verb) {
        this.verb = verb;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.verb);
        sb.append(" ");
        sb.append(this.uri.toString());
        sb.append(" ");
        sb.append(this.version);
        sb.append("\n");
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            sb.append(e.getKey());
            sb.append(": ");
            sb.append(e.getValue());
            sb.append("\n");
        }
        sb.append("\n");
        if (this.body != null) {
            sb.append(new String(this.body, StandardCharsets.UTF_8));
        }
        return sb.toString();
    }
}

