/*
 * Decompiled with CFR 0.152.
 */
package black.door.net.http.tools;

import black.door.net.http.tools.HttpMessage;
import black.door.net.http.tools.ParseTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class HttpResponse
implements HttpMessage {
    private Map<String, String> headers;
    private int statusCode;
    private String statusMessage;
    private String version;
    private byte[] body;

    public HttpResponse(String version, int statusCode, String statusMessage) {
        this.version = version;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = new HashMap<String, String>();
        this.body = new byte[0];
    }

    public HttpResponse(byte[] response) throws IOException {
        this(new ByteArrayInputStream(response));
    }

    public HttpResponse(InputStream stream) throws IOException {
        String firstLine = ParseTools.nextLine(stream);
        String[] split = firstLine.split("\\s+");
        this.version = split[0];
        this.statusCode = Integer.valueOf(split[1]);
        this.statusMessage = split[2];
        this.headers = ParseTools.parseHeaders(stream);
        this.body = ParseTools.getBody(stream, this.headers, -1);
    }

    @Override
    public HttpResponse putHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
        this.putHeader("Content-Length", String.valueOf(body.length));
    }

    private String getLine1() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.version);
        sb.append(" ");
        sb.append(this.statusCode);
        sb.append(" ");
        sb.append(this.statusMessage);
        sb.append('\n');
        return sb.toString();
    }

    private String getHeaderString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            sb.append(header.getKey());
            sb.append(": ");
            sb.append(header.getValue());
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public byte[] serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLine1());
        sb.append(this.getHeaderString());
        byte[] top = sb.toString().getBytes(StandardCharsets.ISO_8859_1);
        if (this.body != null) {
            byte[] serial = Arrays.copyOf(top, top.length + this.body.length);
            System.arraycopy(this.body, 0, serial, top.length, this.body.length);
            return serial;
        }
        return top;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLine1());
        sb.append(this.getHeaderString());
        if (this.body != null) {
            sb.append(new String(this.body, StandardCharsets.ISO_8859_1));
        }
        return sb.toString();
    }
}

