/*
 * Decompiled with CFR 0.152.
 */
package black.door.net.http.tools;

import black.door.net.http.tools.HttpParsingException;
import black.door.struct.ByteQueue;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class ParseTools {
    private static final char CR = '\r';
    private static final char LF = '\n';

    public static Map<String, String> parseHeaders(InputStream is) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String next = ParseTools.nextLine(is);
        while (!next.isEmpty()) {
            String[] header = next.split("\\s*:\\s*", 2);
            headers.put(header[0], header[1]);
            next = ParseTools.nextLine(is);
        }
        return headers;
    }

    public static byte[] getBody(InputStream is, Map<String, String> headers, int maxBodySize) throws IOException, HttpParsingException {
        byte[] body;
        maxBodySize = maxBodySize == -1 ? Integer.MAX_VALUE : maxBodySize;
        String transferEncoding = headers.get("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding != "identity") {
            int size;
            ByteQueue bq = new ByteQueue();
            String next = ParseTools.nextLine(is);
            while (!next.isEmpty() && (size = Integer.valueOf(next, 16).intValue()) != 0) {
                if (bq.filled() + size > maxBodySize) {
                    throw new HttpParsingException("Request body size exceeds max allowed body size (" + maxBodySize + ").");
                }
                byte[] chunk = new byte[size];
                ParseTools.read(is, chunk);
                bq.enQueue(chunk);
                ParseTools.nextLine(is);
                next = ParseTools.nextLine(is);
            }
            body = bq.deQueue(bq.filled());
        } else {
            String contentLengthString = headers.get("Content-Length");
            if (contentLengthString != null) {
                int contentLength = Integer.valueOf(contentLengthString);
                if (contentLength > maxBodySize) {
                    throw new HttpParsingException("Request body size exceeds max allowed body size (" + maxBodySize + ").");
                }
                body = new byte[contentLength];
                ParseTools.read(is, body);
            } else {
                body = null;
            }
        }
        return body;
    }

    private static byte[] read(InputStream is, byte[] bytes) throws IOException {
        int bytesRead = 0;
        int r = 0;
        while (bytesRead < bytes.length) {
            if (r == -1) {
                throw new HttpParsingException("Expected to be able to read more bytes from socket.");
            }
            r = is.read(bytes, bytesRead += r, bytes.length - bytesRead);
        }
        return bytes;
    }

    public static String nextLine(InputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean cr = false;
        int read = stream.read();
        while (true) {
            if (read == -1) {
                throw new EOFException("EOF reached before line ended.");
            }
            char current = (char)read;
            if (current == '\r') {
                cr = true;
            } else if (cr) {
                if (current == '\n') break;
                sb.append('\r');
                sb.append(current);
                cr = false;
            } else {
                if (current == '\n') break;
                sb.append(current);
            }
            read = stream.read();
        }
        return sb.toString();
    }
}

