/*
 * Decompiled with CFR 0.152.
 */
package black.door.net.server;

import black.door.net.server.EchoThread;
import black.door.net.server.ServerThread;
import black.door.util.DBP;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Server
implements Runnable {
    public static final int DEFAULT_PORT = 1776;
    public static final double DEFAULT_QUEUE_SIZE_FACTOR = 8.0;
    public static final double DEFAULT_CORE_THREAD_POOL_SIZE_FACTOR = 1.3333333333333333;
    public static final double DEFAULT_MAX_THREAD_POOL_SIZE_FACTOR = 8.0;
    public static final int DEFAULT_TIMEOUT = 30;
    private int timeout = 30;
    private double minThreadPoolSizeFactor = 1.3333333333333333;
    private double maxThreadPoolSizeFactor = 8.0;
    private double queueSizeFactor = 8.0;
    private int port;
    private ServerSocket serverSocket;
    private boolean running = false;
    private ThreadPoolExecutor pool;
    private ServerThread.ServerThreadBuilder threadBuilder;
    private BlockingQueue<Runnable> blockingQueue;

    public static void main(String[] args) {
        DBP.VERBOSE = true;
        Server server = new Server(new EchoThread.EchoThreadBuilder());
        server.run();
    }

    public Server(ServerThread.ServerThreadBuilder builder) {
        this(builder, 1776);
    }

    public Server(ServerThread.ServerThreadBuilder builder, int port) {
        this.port = port;
        this.threadBuilder = builder;
    }

    private void initialize() {
        int cpus = Runtime.getRuntime().availableProcessors();
        this.blockingQueue = new LinkedBlockingQueue<Runnable>((int)(this.queueSizeFactor * (double)cpus));
        DBP.printdebugln("Server Detects " + cpus + " cores.");
        int core = (int)(this.minThreadPoolSizeFactor * (double)cpus);
        int max = (int)(this.maxThreadPoolSizeFactor * (double)cpus);
        TimeUnit time = TimeUnit.SECONDS;
        this.pool = new ThreadPoolExecutor(core, max, this.timeout, time, this.blockingQueue);
    }

    @Override
    public void run() {
        this.initialize();
        this.running = true;
        this.openServerSocket();
        while (this.isRunning()) {
            try {
                Socket sock = this.serverSocket.accept();
                ServerThread thread = this.threadBuilder.build(sock);
                if (thread == null) continue;
                this.pool.execute(thread);
            }
            catch (IOException e) {
                DBP.printerror("Could not accept socket connection!");
                DBP.printException(e);
            }
        }
    }

    public synchronized void stop() {
        this.running = false;
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
            }
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            DBP.printerror("Error closing Socket.");
            DBP.printException(e);
        }
        catch (InterruptedException ie) {
            DBP.printerror("Error shutting down threadpool.");
            DBP.printException(ie);
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private void openServerSocket() {
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            this.running = false;
            DBP.printerror("COULD NOT OPEN SERVERSOCKET on port: " + this.port);
            DBP.printException(e);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public double getMinThreadPoolSizeFactor() {
        return this.minThreadPoolSizeFactor;
    }

    public void setMinThreadPoolSizeFactor(double minThreadPoolSizeFactor) {
        this.minThreadPoolSizeFactor = minThreadPoolSizeFactor;
    }

    public double getMaxThreadPoolSizeFactor() {
        return this.maxThreadPoolSizeFactor;
    }

    public void setMaxThreadPoolSizeFactor(double maxThreadPoolSizeFactor) {
        this.maxThreadPoolSizeFactor = maxThreadPoolSizeFactor;
    }

    public double getQueueSizeFactor() {
        return this.queueSizeFactor;
    }

    public void setQueueSizeFactor(double queueSizeFactor) {
        this.queueSizeFactor = queueSizeFactor;
    }
}

