/*
 * Decompiled with CFR 0.152.
 */
package black.door.struct;

import black.door.util.Misc;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;

public class ByteQueue {
    private byte[] array;
    private int start;
    private int end;
    private boolean resizable;

    public static void main() {
        int value;
        ByteQueue q = new ByteQueue(10);
        q.setResizable(true);
        for (value = 0; value < 9; ++value) {
            q.enQueue(new byte[]{(byte)value});
        }
        System.out.println(q);
        q.deQueue(5);
        System.out.println(q.details());
        q.enQueue(new byte[]{20, 21, 22});
        System.out.println(q.details());
        q.deQueue(5);
        System.out.println(q.details());
        for (value = 0; value < 30; ++value) {
            q.enQueue(new byte[]{(byte)value});
        }
        System.out.println(q.details());
        q.deQueue(15);
        System.out.println(q.details());
        q.trim();
        System.out.println(q.details());
    }

    public ByteQueue() {
        this.array = new byte[100];
        this.resizable = false;
        this.zero();
    }

    public ByteQueue(int size) {
        this.array = new byte[size];
        this.resizable = false;
        this.zero();
    }

    public boolean isFull() {
        int endmod = (this.end + 1) % this.array.length;
        return endmod == this.start;
    }

    private boolean isEmpty() {
        return this.end == this.start;
    }

    private void zero() {
        this.start = 0;
        this.end = 0;
    }

    public void resize(int newSize) {
        byte[] newArray = new byte[newSize];
        int filled = this.filled();
        this.deQueue(newArray, 0, filled);
        this.array = newArray;
        this.start = 0;
        this.end = filled;
    }

    public void trim() {
        this.resize(this.filled());
    }

    public void enQueue(byte[] src) {
        this.enQueue(src, 0, src.length);
    }

    public void enQueue(byte[] src, int offset, int length) {
        if (length > this.capacity() - this.filled()) {
            if (!this.resizable) {
                throw new BufferOverflowException();
            }
            this.resize(length + this.array.length);
        }
        if (length > this.array.length - this.end) {
            System.arraycopy(src, offset, this.array, this.end, this.array.length - this.end);
            System.arraycopy(src, offset + this.array.length - this.end, this.array, 0, length - (this.array.length - this.end));
        } else {
            System.arraycopy(src, offset, this.array, this.end, length);
        }
        this.end = (this.end + length) % this.array.length;
    }

    public byte[] deQueue(int length) {
        byte[] ret = new byte[length];
        this.deQueue(ret, 0, length);
        return ret;
    }

    public void deQueue(byte[] dest, int offset, int length) {
        if (length > this.filled()) {
            throw new BufferUnderflowException();
        }
        if (this.start > this.end && length > this.capacity() - this.start) {
            System.arraycopy(this.array, this.start, dest, offset, this.capacity() - this.start);
            System.arraycopy(this.array, 0, dest, offset + this.capacity() - this.start, length - (this.capacity() - this.start));
        } else {
            System.arraycopy(this.array, this.start, dest, offset, length);
        }
        this.start = (this.start + length) % this.array.length;
    }

    public int filled() {
        if (this.start > this.end) {
            return this.array.length - this.start + this.end;
        }
        return this.end - this.start;
    }

    public int capacity() {
        return this.array.length - 1;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public String details() {
        return "start = " + this.start + " end = " + this.end + " array = " + Misc.bytesToHex(this.array) + "\n" + this.toString();
    }

    public String toString() {
        String ret = "ByteQueue [array.length = " + this.array.length + " capacity = " + this.capacity() + " filled = " + this.filled() + " buffer = ";
        if (this.end > this.start) {
            ret = ret + Misc.bytesToHex(Arrays.copyOfRange(this.array, this.start, this.end));
        } else {
            ret = ret + Misc.bytesToHex(Arrays.copyOfRange(this.array, this.start, this.array.length));
            ret = ret + Misc.bytesToHex(Arrays.copyOfRange(this.array, 0, this.end));
        }
        return ret + "]";
    }
}

