/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jep.PyConfig;

final class LibraryLocator {
    private final String libraryName;
    private final boolean ignoreEnv;
    private final boolean noSite;
    private final boolean noUserSite;
    private final String pythonHome;

    private LibraryLocator(PyConfig pyConfig) {
        String string;
        if (pyConfig != null) {
            this.ignoreEnv = pyConfig.ignoreEnvironmentFlag != 0 && pyConfig.ignoreEnvironmentFlag != -1;
            this.noSite = pyConfig.noSiteFlag != 0 && pyConfig.noSiteFlag != -1;
            this.noUserSite = pyConfig.noUserSiteDirectory != 0 && pyConfig.noUserSiteDirectory != -1;
            string = pyConfig.pythonHome;
        } else {
            this.ignoreEnv = false;
            this.noSite = false;
            this.noUserSite = false;
            string = null;
        }
        if (string == null && !this.ignoreEnv && (string = System.getenv("PYTHONHOME")) == null) {
            string = System.getenv("VIRTUAL_ENV");
        }
        this.pythonHome = string;
        String string2 = System.mapLibraryName("jep");
        if (string2.endsWith(".dylib")) {
            string2 = string2.replace(".dylib", ".jnilib");
        }
        this.libraryName = string2;
    }

    private boolean searchPythonPath() {
        if (this.ignoreEnv) {
            return false;
        }
        String string = System.getenv("PYTHONPATH");
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(File.pathSeparator)) {
                if (!this.searchPackageDir(new File(string2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean searchSitePackages() {
        if (this.noSite) {
            return false;
        }
        if (this.pythonHome != null) {
            for (String string : new String[]{"lib", "lib64", "Lib"}) {
                File file = new File(this.pythonHome, string);
                if (!file.isDirectory()) continue;
                File file2 = new File(file, "site-packages");
                if (this.searchPackageDir(file2)) {
                    return true;
                }
                file2 = new File(file, "site-python");
                if (this.searchPackageDir(file2)) {
                    return true;
                }
                for (File file3 : file.listFiles()) {
                    if (!file3.isDirectory() || !file3.getName().matches("python\\d\\.\\d{1,2}") || !this.searchPackageDir(file2 = new File(file3, "site-packages"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean searchUserSitePackages() {
        File file;
        File file2;
        File file3;
        Object object;
        Object object2;
        if (this.noSite || this.noUserSite) {
            return false;
        }
        String string = System.getenv("APPDATA");
        if (string != null && ((File)(object2 = new File(string, "Python"))).isDirectory()) {
            object = ((File)object2).listFiles();
            int n = ((File[])object).length;
            for (int i = 0; i < n; ++i) {
                File file4;
                Object object3 = object[i];
                if (!((File)object3).isDirectory() || !((File)object3).getName().matches("python\\d{2,3}") || !this.searchPackageDir(file4 = new File((File)object3, "site-packages"))) continue;
                return true;
            }
        }
        if ((object2 = System.getProperty("user.home")) != null && (file3 = new File((File)(object = new File((String)object2, ".local")), "lib")).isDirectory()) {
            for (File file5 : file3.listFiles()) {
                if (!file5.isDirectory() || !file5.getName().matches("python\\d\\.\\d{1,2}") || !this.searchPackageDir(file2 = new File(file5, "site-packages"))) continue;
                return true;
            }
        }
        if (object2 != null && ((File)(object = new File((String)object2, "Library"))).isDirectory() && (file = new File((File)object, "Python")).isDirectory()) {
            for (File file5 : file.listFiles()) {
                File file6;
                File file7;
                if (!file5.isDirectory() || !file5.getName().matches("\\d\\.\\d{1,2}") || !(file2 = new File(file5, "lib")).isDirectory() || !(file7 = new File(file2, "python")).isDirectory() || !this.searchPackageDir(file6 = new File(file7, "site-packages"))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean searchPackageDir(File file) {
        File file2;
        File file3;
        if (file.isDirectory() && (file3 = new File(file, "jep")).isDirectory() && (file2 = new File(file3, this.libraryName)).exists()) {
            try {
                System.load(file2.getAbsolutePath());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Matcher matcher = Pattern.compile("libpython[\\w\\.]*").matcher(unsatisfiedLinkError.getMessage());
                if (matcher.find() && this.findPythonLibrary(matcher.group(0))) {
                    System.load(file2.getAbsolutePath());
                }
                if (this.findPythonLibraryWindows()) {
                    System.load(file2.getAbsolutePath());
                }
                throw unsatisfiedLinkError;
            }
            return true;
        }
        return false;
    }

    private boolean findPythonLibrary(String string) {
        if (this.pythonHome != null) {
            for (String string2 : new String[]{"lib", "lib64", "Lib"}) {
                File file;
                File file2 = new File(this.pythonHome, string2);
                if (!file2.isDirectory() || !(file = new File(file2, string)).exists()) continue;
                System.load(file.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    private boolean findPythonLibraryWindows() {
        if (this.pythonHome != null) {
            Pattern pattern = Pattern.compile("^python\\d\\d+\\.dll$");
            for (File file : new File(this.pythonHome).listFiles()) {
                if (!file.isFile() || !pattern.matcher(file.getName()).matches() || !file.exists()) continue;
                System.load(file.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    public static boolean findJepLibrary(PyConfig pyConfig) {
        LibraryLocator libraryLocator = new LibraryLocator(pyConfig);
        if (libraryLocator.searchPythonPath()) {
            return true;
        }
        if (libraryLocator.searchSitePackages()) {
            return true;
        }
        return libraryLocator.searchUserSitePackages();
    }
}

