/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERPrintableString
extends ASN1Object
implements DERString {
    String string;

    public DERPrintableString(String string) {
        this(string, false);
    }

    public DERPrintableString(String string, boolean bl) {
        if (bl && !DERPrintableString.isPrintableString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = string;
    }

    public DERPrintableString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        this.string = new String(cArray);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString dERPrintableString = (DERPrintableString)dERObject;
        return this.getString().equals(dERPrintableString.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(19, this.getOctets());
    }

    public static DERPrintableString getInstance(Object object) {
        if (object == null || object instanceof DERPrintableString) {
            return (DERPrintableString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERPrintableString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERPrintableString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERPrintableString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERPrintableString.getInstance(aSN1TaggedObject.getObject());
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n != cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public static boolean isPrintableString(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c > '\u007f') {
                return false;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                switch (c) {
                    default: {
                        return false;
                    }
                    case ' ': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '=': 
                    case '?': 
                }
            }
            --n;
        }
        return true;
    }

    public String toString() {
        return this.string;
    }
}

