/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.esf;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class SigPolicyQualifierInfo
extends ASN1Encodable {
    private DERObjectIdentifier sigPolicyQualifierId;
    private DEREncodable sigQualifier;

    public SigPolicyQualifierInfo(ASN1Sequence aSN1Sequence) {
        this.sigPolicyQualifierId = DERObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.sigQualifier = aSN1Sequence.getObjectAt(1);
    }

    public SigPolicyQualifierInfo(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.sigPolicyQualifierId = dERObjectIdentifier;
        this.sigQualifier = dEREncodable;
    }

    public static SigPolicyQualifierInfo getInstance(Object object) {
        if (object == null || object instanceof SigPolicyQualifierInfo) {
            return (SigPolicyQualifierInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SigPolicyQualifierInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in 'SigPolicyQualifierInfo' factory: " + object.getClass().getName() + ".");
    }

    public DERObjectIdentifier getSigPolicyQualifierId() {
        return this.sigPolicyQualifierId;
    }

    public DEREncodable getSigQualifier() {
        return this.sigQualifier;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.sigPolicyQualifierId);
        aSN1EncodableVector.add(this.sigQualifier);
        return new DERSequence(aSN1EncodableVector);
    }
}

