/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.icao;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class DataGroupHash
extends ASN1Encodable {
    DERInteger dataGroupNumber;
    ASN1OctetString dataGroupHashValue;

    public DataGroupHash(int n, ASN1OctetString aSN1OctetString) {
        this.dataGroupNumber = new DERInteger(n);
        this.dataGroupHashValue = aSN1OctetString;
    }

    public DataGroupHash(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.dataGroupNumber = DERInteger.getInstance(enumeration.nextElement());
        this.dataGroupHashValue = ASN1OctetString.getInstance(enumeration.nextElement());
    }

    public ASN1OctetString getDataGroupHashValue() {
        return this.dataGroupHashValue;
    }

    public int getDataGroupNumber() {
        return this.dataGroupNumber.getValue().intValue();
    }

    public static DataGroupHash getInstance(Object object) {
        if (object == null || object instanceof DataGroupHash) {
            return (DataGroupHash)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DataGroupHash(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.dataGroupNumber);
        aSN1EncodableVector.add(this.dataGroupHashValue);
        return new DERSequence(aSN1EncodableVector);
    }
}

