/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class CamelliaEngine
implements BlockCipher {
    private boolean initialised;
    private boolean _keyIs128;
    private static final int BLOCK_SIZE = 16;
    private static final long MASK8 = 255L;
    private static final long MASK32 = 0xFFFFFFFFL;
    private static final long SIGMA1 = -6872943284670656373L;
    private static final long SIGMA2 = -5297666545706961998L;
    private static final long SIGMA3 = -4112007255848680770L;
    private static final long SIGMA4 = 6124705990439038748L;
    private static final long SIGMA5 = 1217423232700263709L;
    private static final long SIGMA6 = -5740250305213840899L;
    private long _kw1;
    private long _kw2;
    private long _kw3;
    private long _kw4;
    private long _k1;
    private long _k2;
    private long _k3;
    private long _k4;
    private long _k5;
    private long _k6;
    private long _k7;
    private long _k8;
    private long _k9;
    private long _k10;
    private long _k11;
    private long _k12;
    private long _k13;
    private long _k14;
    private long _k15;
    private long _k16;
    private long _k17;
    private long _k18;
    private long _k19;
    private long _k20;
    private long _k21;
    private long _k22;
    private long _k23;
    private long _k24;
    private long _ke1;
    private long _ke2;
    private long _ke3;
    private long _ke4;
    private long _ke5;
    private long _ke6;
    private final byte[] SBOX1;
    private final byte[] SBOX2;
    private final byte[] SBOX3;
    private final byte[] SBOX4;

    public CamelliaEngine() {
        byte[] byArray = new byte[256];
        byArray[0] = 112;
        byArray[1] = -126;
        byArray[2] = 44;
        byArray[3] = -20;
        byArray[4] = -77;
        byArray[5] = 39;
        byArray[6] = -64;
        byArray[7] = -27;
        byArray[8] = -28;
        byArray[9] = -123;
        byArray[10] = 87;
        byArray[11] = 53;
        byArray[12] = -22;
        byArray[13] = 12;
        byArray[14] = -82;
        byArray[15] = 65;
        byArray[16] = 35;
        byArray[17] = -17;
        byArray[18] = 107;
        byArray[19] = -109;
        byArray[20] = 69;
        byArray[21] = 25;
        byArray[22] = -91;
        byArray[23] = 33;
        byArray[24] = -19;
        byArray[25] = 14;
        byArray[26] = 79;
        byArray[27] = 78;
        byArray[28] = 29;
        byArray[29] = 101;
        byArray[30] = -110;
        byArray[31] = -67;
        byArray[32] = -122;
        byArray[33] = -72;
        byArray[34] = -81;
        byArray[35] = -113;
        byArray[36] = 124;
        byArray[37] = -21;
        byArray[38] = 31;
        byArray[39] = -50;
        byArray[40] = 62;
        byArray[41] = 48;
        byArray[42] = -36;
        byArray[43] = 95;
        byArray[44] = 94;
        byArray[45] = -59;
        byArray[46] = 11;
        byArray[47] = 26;
        byArray[48] = -90;
        byArray[49] = -31;
        byArray[50] = 57;
        byArray[51] = -54;
        byArray[52] = -43;
        byArray[53] = 71;
        byArray[54] = 93;
        byArray[55] = 61;
        byArray[56] = -39;
        byArray[57] = 1;
        byArray[58] = 90;
        byArray[59] = -42;
        byArray[60] = 81;
        byArray[61] = 86;
        byArray[62] = 108;
        byArray[63] = 77;
        byArray[64] = -117;
        byArray[65] = 13;
        byArray[66] = -102;
        byArray[67] = 102;
        byArray[68] = -5;
        byArray[69] = -52;
        byArray[70] = -80;
        byArray[71] = 45;
        byArray[72] = 116;
        byArray[73] = 18;
        byArray[74] = 43;
        byArray[75] = 32;
        byArray[76] = -16;
        byArray[77] = -79;
        byArray[78] = -124;
        byArray[79] = -103;
        byArray[80] = -33;
        byArray[81] = 76;
        byArray[82] = -53;
        byArray[83] = -62;
        byArray[84] = 52;
        byArray[85] = 126;
        byArray[86] = 118;
        byArray[87] = 5;
        byArray[88] = 109;
        byArray[89] = -73;
        byArray[90] = -87;
        byArray[91] = 49;
        byArray[92] = -47;
        byArray[93] = 23;
        byArray[94] = 4;
        byArray[95] = -41;
        byArray[96] = 20;
        byArray[97] = 88;
        byArray[98] = 58;
        byArray[99] = 97;
        byArray[100] = -34;
        byArray[101] = 27;
        byArray[102] = 17;
        byArray[103] = 28;
        byArray[104] = 50;
        byArray[105] = 15;
        byArray[106] = -100;
        byArray[107] = 22;
        byArray[108] = 83;
        byArray[109] = 24;
        byArray[110] = -14;
        byArray[111] = 34;
        byArray[112] = -2;
        byArray[113] = 68;
        byArray[114] = -49;
        byArray[115] = -78;
        byArray[116] = -61;
        byArray[117] = -75;
        byArray[118] = 122;
        byArray[119] = -111;
        byArray[120] = 36;
        byArray[121] = 8;
        byArray[122] = -24;
        byArray[123] = -88;
        byArray[124] = 96;
        byArray[125] = -4;
        byArray[126] = 105;
        byArray[127] = 80;
        byArray[128] = -86;
        byArray[129] = -48;
        byArray[130] = -96;
        byArray[131] = 125;
        byArray[132] = -95;
        byArray[133] = -119;
        byArray[134] = 98;
        byArray[135] = -105;
        byArray[136] = 84;
        byArray[137] = 91;
        byArray[138] = 30;
        byArray[139] = -107;
        byArray[140] = -32;
        byArray[141] = -1;
        byArray[142] = 100;
        byArray[143] = -46;
        byArray[144] = 16;
        byArray[145] = -60;
        byArray[147] = 72;
        byArray[148] = -93;
        byArray[149] = -9;
        byArray[150] = 117;
        byArray[151] = -37;
        byArray[152] = -118;
        byArray[153] = 3;
        byArray[154] = -26;
        byArray[155] = -38;
        byArray[156] = 9;
        byArray[157] = 63;
        byArray[158] = -35;
        byArray[159] = -108;
        byArray[160] = -121;
        byArray[161] = 92;
        byArray[162] = -125;
        byArray[163] = 2;
        byArray[164] = -51;
        byArray[165] = 74;
        byArray[166] = -112;
        byArray[167] = 51;
        byArray[168] = 115;
        byArray[169] = 103;
        byArray[170] = -10;
        byArray[171] = -13;
        byArray[172] = -99;
        byArray[173] = 127;
        byArray[174] = -65;
        byArray[175] = -30;
        byArray[176] = 82;
        byArray[177] = -101;
        byArray[178] = -40;
        byArray[179] = 38;
        byArray[180] = -56;
        byArray[181] = 55;
        byArray[182] = -58;
        byArray[183] = 59;
        byArray[184] = -127;
        byArray[185] = -106;
        byArray[186] = 111;
        byArray[187] = 75;
        byArray[188] = 19;
        byArray[189] = -66;
        byArray[190] = 99;
        byArray[191] = 46;
        byArray[192] = -23;
        byArray[193] = 121;
        byArray[194] = -89;
        byArray[195] = -116;
        byArray[196] = -97;
        byArray[197] = 110;
        byArray[198] = -68;
        byArray[199] = -114;
        byArray[200] = 41;
        byArray[201] = -11;
        byArray[202] = -7;
        byArray[203] = -74;
        byArray[204] = 47;
        byArray[205] = -3;
        byArray[206] = -76;
        byArray[207] = 89;
        byArray[208] = 120;
        byArray[209] = -104;
        byArray[210] = 6;
        byArray[211] = 106;
        byArray[212] = -25;
        byArray[213] = 70;
        byArray[214] = 113;
        byArray[215] = -70;
        byArray[216] = -44;
        byArray[217] = 37;
        byArray[218] = -85;
        byArray[219] = 66;
        byArray[220] = -120;
        byArray[221] = -94;
        byArray[222] = -115;
        byArray[223] = -6;
        byArray[224] = 114;
        byArray[225] = 7;
        byArray[226] = -71;
        byArray[227] = 85;
        byArray[228] = -8;
        byArray[229] = -18;
        byArray[230] = -84;
        byArray[231] = 10;
        byArray[232] = 54;
        byArray[233] = 73;
        byArray[234] = 42;
        byArray[235] = 104;
        byArray[236] = 60;
        byArray[237] = 56;
        byArray[238] = -15;
        byArray[239] = -92;
        byArray[240] = 64;
        byArray[241] = 40;
        byArray[242] = -45;
        byArray[243] = 123;
        byArray[244] = -69;
        byArray[245] = -55;
        byArray[246] = 67;
        byArray[247] = -63;
        byArray[248] = 21;
        byArray[249] = -29;
        byArray[250] = -83;
        byArray[251] = -12;
        byArray[252] = 119;
        byArray[253] = -57;
        byArray[254] = -128;
        byArray[255] = -98;
        this.SBOX1 = byArray;
        this.SBOX2 = new byte[256];
        this.SBOX3 = new byte[256];
        this.SBOX4 = new byte[256];
        int n = 0;
        while (n != 256) {
            this.SBOX2[n] = this.lRot8(this.SBOX1[n], 1);
            this.SBOX3[n] = this.lRot8(this.SBOX1[n], 7);
            this.SBOX4[n] = this.SBOX1[this.lRot8((byte)n, 1) & 0xFF];
            ++n;
        }
    }

    private long bytesToWord(byte[] byArray, int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < 8) {
            l = (l << 8) + (long)(byArray[n2 + n] & 0xFF);
            ++n2;
        }
        return l;
    }

    private long f(long l, long l2) {
        long l3 = l ^ l2;
        int n = (int)(l3 >> 32);
        int n2 = (int)l3;
        byte by = this.SBOX1[n >> 24 & 0xFF];
        byte by2 = this.SBOX2[n >> 16 & 0xFF];
        byte by3 = this.SBOX3[n >> 8 & 0xFF];
        byte by4 = this.SBOX4[n & 0xFF];
        byte by5 = this.SBOX2[n2 >> 24 & 0xFF];
        byte by6 = this.SBOX3[n2 >> 16 & 0xFF];
        byte by7 = this.SBOX4[n2 >> 8 & 0xFF];
        byte by8 = this.SBOX1[n2 & 0xFF];
        int n3 = by ^ by3 ^ by4 ^ by6 ^ by7 ^ by8;
        int n4 = by ^ by2 ^ by4 ^ by5 ^ by7 ^ by8;
        int n5 = by ^ by2 ^ by3 ^ by5 ^ by6 ^ by8;
        int n6 = by2 ^ by3 ^ by4 ^ by5 ^ by6 ^ by7;
        int n7 = by ^ by2 ^ by6 ^ by7 ^ by8;
        int n8 = by2 ^ by3 ^ by5 ^ by7 ^ by8;
        int n9 = by3 ^ by4 ^ by5 ^ by6 ^ by8;
        int n10 = by ^ by4 ^ by5 ^ by6 ^ by7;
        return (long)n3 << 56 | ((long)n4 & 0xFFL) << 48 | ((long)n5 & 0xFFL) << 40 | ((long)n6 & 0xFFL) << 32 | ((long)n7 & 0xFFL) << 24 | ((long)n8 & 0xFFL) << 16 | ((long)n9 & 0xFFL) << 8 | (long)n10 & 0xFFL;
    }

    private long fl(long l, long l2) {
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = (int)(l2 >> 32);
        int n4 = (int)l2;
        n2 ^= this.lRot32(n & n3, 1);
        return (long)(n ^= n2 | n4) << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    private long flInv(long l, long l2) {
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = (int)(l2 >> 32);
        int n4 = (int)l2;
        n ^= n2 | n4;
        return (long)n << 32 | (long)(n2 ^= this.lRot32(n & n3, 1)) & 0xFFFFFFFFL;
    }

    public String getAlgorithmName() {
        return "Camellia";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("only simple KeyParameter expected.");
        }
        this.setKey(bl, ((KeyParameter)cipherParameters).getKey());
        this.initialised = true;
    }

    private long lRot128high(long l, long l2, int n) {
        l = n < 64 ? l << n | l2 >>> -n : (n == 64 ? l2 : l2 << n - 64 | l >>> -(n - 64));
        return l;
    }

    private long lRot128low(long l, long l2, int n) {
        l2 = n < 64 ? l2 << n | l >>> -n : (n == 64 ? l : l << n - 64 | l2 >>> -(n - 64));
        return l2;
    }

    private int lRot32(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    private byte lRot8(byte by, int n) {
        return (byte)(by << n | (by & 0xFF) >>> 8 - n);
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Camellia engine not initialised");
        }
        if (n + 16 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + 16 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this._keyIs128) {
            return this.processBlock128(byArray, n, byArray2, n2);
        }
        return this.processBlock192or256(byArray, n, byArray2, n2);
    }

    private int processBlock128(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        long l = this.bytesToWord(byArray, n);
        long l2 = this.bytesToWord(byArray, n + 8);
        l2 ^= this._kw2;
        l2 ^= this.f(l ^= this._kw1, this._k1);
        l ^= this.f(l2, this._k2);
        l2 ^= this.f(l, this._k3);
        l ^= this.f(l2, this._k4);
        l2 ^= this.f(l, this._k5);
        l ^= this.f(l2, this._k6);
        l = this.fl(l, this._ke1);
        l2 = this.flInv(l2, this._ke2);
        l2 ^= this.f(l, this._k7);
        l ^= this.f(l2, this._k8);
        l2 ^= this.f(l, this._k9);
        l ^= this.f(l2, this._k10);
        l2 ^= this.f(l, this._k11);
        l ^= this.f(l2, this._k12);
        l = this.fl(l, this._ke3);
        l2 = this.flInv(l2, this._ke4);
        l2 ^= this.f(l, this._k13);
        l ^= this.f(l2, this._k14);
        l2 ^= this.f(l, this._k15);
        l ^= this.f(l2, this._k16);
        l2 ^= this.f(l, this._k17);
        l ^= this.f(l2, this._k18);
        this.wordToBytes(l2 ^= this._kw3, byArray2, n2);
        this.wordToBytes(l ^= this._kw4, byArray2, n2 + 8);
        return 16;
    }

    private int processBlock192or256(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        long l = this.bytesToWord(byArray, n);
        long l2 = this.bytesToWord(byArray, n + 8);
        l2 ^= this._kw2;
        l2 ^= this.f(l ^= this._kw1, this._k1);
        l ^= this.f(l2, this._k2);
        l2 ^= this.f(l, this._k3);
        l ^= this.f(l2, this._k4);
        l2 ^= this.f(l, this._k5);
        l ^= this.f(l2, this._k6);
        l = this.fl(l, this._ke1);
        l2 = this.flInv(l2, this._ke2);
        l2 ^= this.f(l, this._k7);
        l ^= this.f(l2, this._k8);
        l2 ^= this.f(l, this._k9);
        l ^= this.f(l2, this._k10);
        l2 ^= this.f(l, this._k11);
        l ^= this.f(l2, this._k12);
        l = this.fl(l, this._ke3);
        l2 = this.flInv(l2, this._ke4);
        l2 ^= this.f(l, this._k13);
        l ^= this.f(l2, this._k14);
        l2 ^= this.f(l, this._k15);
        l ^= this.f(l2, this._k16);
        l2 ^= this.f(l, this._k17);
        l ^= this.f(l2, this._k18);
        l = this.fl(l, this._ke5);
        l2 = this.flInv(l2, this._ke6);
        l2 ^= this.f(l, this._k19);
        l ^= this.f(l2, this._k20);
        l2 ^= this.f(l, this._k21);
        l ^= this.f(l2, this._k22);
        l2 ^= this.f(l, this._k23);
        l ^= this.f(l2, this._k24);
        this.wordToBytes(l2 ^= this._kw3, byArray2, n2);
        this.wordToBytes(l ^= this._kw4, byArray2, n2 + 8);
        return 16;
    }

    public void reset() {
    }

    private void setKey(boolean bl, byte[] byArray) {
        long l;
        long l2;
        long l3;
        long l4;
        switch (byArray.length) {
            case 16: {
                this._keyIs128 = true;
                l4 = this.bytesToWord(byArray, 0);
                l3 = this.bytesToWord(byArray, 8);
                l2 = 0L;
                l = 0L;
                break;
            }
            case 24: {
                l4 = this.bytesToWord(byArray, 0);
                l3 = this.bytesToWord(byArray, 8);
                l2 = this.bytesToWord(byArray, 16);
                l = this.bytesToWord(byArray, 16) ^ 0xFFFFFFFFFFFFFFFFL;
                this._keyIs128 = false;
                break;
            }
            case 32: {
                l4 = this.bytesToWord(byArray, 0);
                l3 = this.bytesToWord(byArray, 8);
                l2 = this.bytesToWord(byArray, 16);
                l = this.bytesToWord(byArray, 24);
                this._keyIs128 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("only a key sizes of 128/192/256 are acceptable.");
            }
        }
        long l5 = l4 ^ l2;
        long l6 = l3 ^ l;
        l6 ^= this.f(l5, -6872943284670656373L);
        l5 ^= this.f(l6, -5297666545706961998L);
        l6 ^= l3;
        l6 ^= this.f(l5 ^= l4, -4112007255848680770L);
        long l7 = l5 ^= this.f(l6, 6124705990439038748L);
        long l8 = l6;
        if (this._keyIs128) {
            if (bl) {
                this._kw1 = l4;
                this._kw2 = l3;
                this._kw3 = this.lRot128high(l7, l8, 111);
                this._kw4 = this.lRot128low(l7, l8, 111);
                this._k1 = l7;
                this._k2 = l8;
                this._k3 = this.lRot128high(l4, l3, 15);
                this._k4 = this.lRot128low(l4, l3, 15);
                this._k5 = this.lRot128high(l7, l8, 15);
                this._k6 = this.lRot128low(l7, l8, 15);
                this._k7 = this.lRot128high(l4, l3, 45);
                this._k8 = this.lRot128low(l4, l3, 45);
                this._k9 = this.lRot128high(l7, l8, 45);
                this._k10 = this.lRot128low(l4, l3, 60);
                this._k11 = this.lRot128high(l7, l8, 60);
                this._k12 = this.lRot128low(l7, l8, 60);
                this._k13 = this.lRot128high(l4, l3, 94);
                this._k14 = this.lRot128low(l4, l3, 94);
                this._k15 = this.lRot128high(l7, l8, 94);
                this._k16 = this.lRot128low(l7, l8, 94);
                this._k17 = this.lRot128high(l4, l3, 111);
                this._k18 = this.lRot128low(l4, l3, 111);
                this._ke1 = this.lRot128high(l7, l8, 30);
                this._ke2 = this.lRot128low(l7, l8, 30);
                this._ke3 = this.lRot128high(l4, l3, 77);
                this._ke4 = this.lRot128low(l4, l3, 77);
            } else {
                this._kw3 = l4;
                this._kw4 = l3;
                this._kw1 = this.lRot128high(l7, l8, 111);
                this._kw2 = this.lRot128low(l7, l8, 111);
                this._k18 = l7;
                this._k17 = l8;
                this._k16 = this.lRot128high(l4, l3, 15);
                this._k15 = this.lRot128low(l4, l3, 15);
                this._k14 = this.lRot128high(l7, l8, 15);
                this._k13 = this.lRot128low(l7, l8, 15);
                this._k12 = this.lRot128high(l4, l3, 45);
                this._k11 = this.lRot128low(l4, l3, 45);
                this._k10 = this.lRot128high(l7, l8, 45);
                this._k9 = this.lRot128low(l4, l3, 60);
                this._k8 = this.lRot128high(l7, l8, 60);
                this._k7 = this.lRot128low(l7, l8, 60);
                this._k6 = this.lRot128high(l4, l3, 94);
                this._k5 = this.lRot128low(l4, l3, 94);
                this._k4 = this.lRot128high(l7, l8, 94);
                this._k3 = this.lRot128low(l7, l8, 94);
                this._k2 = this.lRot128high(l4, l3, 111);
                this._k1 = this.lRot128low(l4, l3, 111);
                this._ke4 = this.lRot128high(l7, l8, 30);
                this._ke3 = this.lRot128low(l7, l8, 30);
                this._ke2 = this.lRot128high(l4, l3, 77);
                this._ke1 = this.lRot128low(l4, l3, 77);
            }
        } else {
            l5 = l7 ^ l2;
            l6 = l8 ^ l;
            l6 ^= this.f(l5, 1217423232700263709L);
            long l9 = l5 ^= this.f(l6, -5740250305213840899L);
            long l10 = l6;
            if (bl) {
                this._kw1 = l4;
                this._kw2 = l3;
                this._k1 = l9;
                this._k2 = l10;
                this._k3 = this.lRot128high(l2, l, 15);
                this._k4 = this.lRot128low(l2, l, 15);
                this._k5 = this.lRot128high(l7, l8, 15);
                this._k6 = this.lRot128low(l7, l8, 15);
                this._ke1 = this.lRot128high(l2, l, 30);
                this._ke2 = this.lRot128low(l2, l, 30);
                this._k7 = this.lRot128high(l9, l10, 30);
                this._k8 = this.lRot128low(l9, l10, 30);
                this._k9 = this.lRot128high(l4, l3, 45);
                this._k10 = this.lRot128low(l4, l3, 45);
                this._k11 = this.lRot128high(l7, l8, 45);
                this._k12 = this.lRot128low(l7, l8, 45);
                this._ke3 = this.lRot128high(l4, l3, 60);
                this._ke4 = this.lRot128low(l4, l3, 60);
                this._k13 = this.lRot128high(l2, l, 60);
                this._k14 = this.lRot128low(l2, l, 60);
                this._k15 = this.lRot128high(l9, l10, 60);
                this._k16 = this.lRot128low(l9, l10, 60);
                this._k17 = this.lRot128high(l4, l3, 77);
                this._k18 = this.lRot128low(l4, l3, 77);
                this._ke5 = this.lRot128high(l7, l8, 77);
                this._ke6 = this.lRot128low(l7, l8, 77);
                this._k19 = this.lRot128high(l2, l, 94);
                this._k20 = this.lRot128low(l2, l, 94);
                this._k21 = this.lRot128high(l7, l8, 94);
                this._k22 = this.lRot128low(l7, l8, 94);
                this._k23 = this.lRot128high(l4, l3, 111);
                this._k24 = this.lRot128low(l4, l3, 111);
                this._kw3 = this.lRot128high(l9, l10, 111);
                this._kw4 = this.lRot128low(l9, l10, 111);
            } else {
                this._kw3 = l4;
                this._kw4 = l3;
                this._kw1 = this.lRot128high(l9, l10, 111);
                this._kw2 = this.lRot128low(l9, l10, 111);
                this._k24 = l9;
                this._k23 = l10;
                this._k22 = this.lRot128high(l2, l, 15);
                this._k21 = this.lRot128low(l2, l, 15);
                this._k20 = this.lRot128high(l7, l8, 15);
                this._k19 = this.lRot128low(l7, l8, 15);
                this._k18 = this.lRot128high(l9, l10, 30);
                this._k17 = this.lRot128low(l9, l10, 30);
                this._k16 = this.lRot128high(l4, l3, 45);
                this._k15 = this.lRot128low(l4, l3, 45);
                this._k14 = this.lRot128high(l7, l8, 45);
                this._k13 = this.lRot128low(l7, l8, 45);
                this._k12 = this.lRot128high(l2, l, 60);
                this._k11 = this.lRot128low(l2, l, 60);
                this._k10 = this.lRot128high(l9, l10, 60);
                this._k9 = this.lRot128low(l9, l10, 60);
                this._k8 = this.lRot128high(l4, l3, 77);
                this._k7 = this.lRot128low(l4, l3, 77);
                this._k6 = this.lRot128high(l2, l, 94);
                this._k5 = this.lRot128low(l2, l, 94);
                this._k4 = this.lRot128high(l7, l8, 94);
                this._k3 = this.lRot128low(l7, l8, 94);
                this._k2 = this.lRot128high(l4, l3, 111);
                this._k1 = this.lRot128low(l4, l3, 111);
                this._ke6 = this.lRot128high(l2, l, 30);
                this._ke5 = this.lRot128low(l2, l, 30);
                this._ke4 = this.lRot128high(l4, l3, 60);
                this._ke3 = this.lRot128low(l4, l3, 60);
                this._ke2 = this.lRot128high(l7, l8, 77);
                this._ke1 = this.lRot128low(l7, l8, 77);
            }
        }
    }

    private void wordToBytes(long l, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < 8) {
            byArray[7 - n2 + n] = (byte)l;
            l >>>= 8;
            ++n2;
        }
    }
}

