/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class HC256Engine
implements StreamCipher {
    private int[] p = new int[1024];
    private int[] q = new int[1024];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    public String getAlgorithmName() {
        return "HC-256";
    }

    private byte getByte() {
        int n;
        if (this.idx == 0) {
            n = this.step();
            this.buf[3] = (byte)(n & 0xFF);
            this.buf[2] = (byte)((n >>= 8) & 0xFF);
            this.buf[1] = (byte)((n >>= 8) & 0xFF);
            this.buf[0] = (byte)((n >>= 8) & 0xFF);
        }
        n = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return (byte)n;
    }

    private void init() {
        int n;
        if (this.key.length != 32) {
            throw new IllegalArgumentException("The key must be 256 bit long");
        }
        this.cnt = 0;
        int[] nArray = new int[2560];
        int n2 = 0;
        while (n2 < 32) {
            int n3 = n2 >> 3;
            nArray[n3] = nArray[n3] | this.key[n2] << (n2 & 7);
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.iv.length && n4 < 32) {
            int n5 = (n4 >> 3) + 8;
            nArray[n5] = nArray[n5] | this.iv[n4] << (n4 & 7);
            ++n4;
        }
        int n6 = 16;
        while (n6 < 2560) {
            n = nArray[n6 - 2];
            int n7 = nArray[n6 - 15];
            nArray[n6] = (HC256Engine.rotateRight(n, 17) ^ HC256Engine.rotateRight(n, 19) ^ n >>> 10) + nArray[n6 - 7] + (HC256Engine.rotateRight(n7, 7) ^ HC256Engine.rotateRight(n7, 18) ^ n7 >>> 3) + nArray[n6 - 16] + n6;
            ++n6;
        }
        System.arraycopy(nArray, 512, this.p, 0, 1024);
        System.arraycopy(nArray, 1536, this.q, 0, 1024);
        n = 0;
        while (n < 4096) {
            this.step();
            ++n;
        }
        this.cnt = 0;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2 = cipherParameters;
        if (cipherParameters instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)cipherParameters).getIV();
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            this.iv = new byte[0];
        }
        if (!(cipherParameters2 instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC256 init - " + cipherParameters.getClass().getName());
        }
        this.key = ((KeyParameter)cipherParameters2).getKey();
        this.init();
        this.initialised = true;
    }

    public void processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " not initialised");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray2[n3 + n4] = (byte)(byArray[n + n4] ^ this.getByte());
            ++n4;
        }
    }

    public void reset() {
        this.idx = 0;
        this.init();
    }

    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }

    private static int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    private int step() {
        int n;
        int n2 = this.cnt & 0x3FF;
        if (this.cnt < 1024) {
            int n3 = this.p[n2 - 3 & 0x3FF];
            int n4 = this.p[n2 - 1023 & 0x3FF];
            int n5 = n2;
            this.p[n5] = this.p[n5] + (this.p[n2 - 10 & 0x3FF] + (HC256Engine.rotateRight(n3, 10) ^ HC256Engine.rotateRight(n4, 23)) + this.q[(n3 ^ n4) & 0x3FF]);
            n3 = this.p[n2 - 12 & 0x3FF];
            n = this.q[n3 & 0xFF] + this.q[(n3 >> 8 & 0xFF) + 256] + this.q[(n3 >> 16 & 0xFF) + 512] + this.q[(n3 >> 24 & 0xFF) + 768] ^ this.p[n2];
        } else {
            int n6 = this.q[n2 - 3 & 0x3FF];
            int n7 = this.q[n2 - 1023 & 0x3FF];
            int n8 = n2;
            this.q[n8] = this.q[n8] + (this.q[n2 - 10 & 0x3FF] + (HC256Engine.rotateRight(n6, 10) ^ HC256Engine.rotateRight(n7, 23)) + this.p[(n6 ^ n7) & 0x3FF]);
            n6 = this.q[n2 - 12 & 0x3FF];
            n = this.p[n6 & 0xFF] + this.p[(n6 >> 8 & 0xFF) + 256] + this.p[(n6 >> 16 & 0xFF) + 512] + this.p[(n6 >> 24 & 0xFF) + 768] ^ this.q[n2];
        }
        this.cnt = this.cnt + 1 & 0x7FF;
        return n;
    }
}

