/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;

public class IPAddress {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);

    public static boolean isValid(String string) {
        return IPAddress.isValidIPv4(string) || IPAddress.isValidIPv6(string);
    }

    private static boolean isValidIPv4(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        int n2 = 0;
        String string2 = String.valueOf(string) + ".";
        int n3 = 0;
        while (n3 < string2.length() && (n = string2.indexOf(46, n3)) > n3) {
            BigInteger bigInteger;
            if (n2 == 4) {
                return false;
            }
            try {
                bigInteger = new BigInteger(string2.substring(n3, n));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (bigInteger.compareTo(ZERO) == -1 || bigInteger.compareTo(BigInteger.valueOf(255L)) == 1) {
                return false;
            }
            n3 = n + 1;
            ++n2;
        }
        return n2 == 4;
    }

    private static boolean isValidIPv6(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        int n2 = 0;
        String string2 = String.valueOf(string) + ":";
        int n3 = 0;
        while (n3 < string2.length() && (n = string2.indexOf(58, n3)) > n3) {
            BigInteger bigInteger;
            if (n2 == 8) {
                return false;
            }
            try {
                bigInteger = new BigInteger(string2.substring(n3, n), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (bigInteger.compareTo(ZERO) == -1 || bigInteger.compareTo(BigInteger.valueOf(65535L)) == 1) {
                return false;
            }
            n3 = n + 1;
            ++n2;
        }
        return n2 == 8;
    }
}

