/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERInputStream;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jce.interfaces.BCKeyStore;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.JDKKeyFactory;
import org.bouncycastle.util.encoders.Hex;

public class JDKPKCS12KeyStore
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 100;
    private static final String KEY_ALGORITHM = "1.2.840.113549.1.12.1.3";
    private static final String CERT_ALGORITHM = "1.2.840.113549.1.12.1.6";
    private Hashtable keys = new Hashtable();
    private Hashtable localIds = new Hashtable();
    private Hashtable certs = new Hashtable();
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact = null;

    public JDKPKCS12KeyStore(String string) {
        try {
            this.certFact = string != null ? CertificateFactory.getInstance("X.509", string) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream(byteArrayInputStream).readObject());
            return new SubjectKeyIdentifier(subjectPublicKeyInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.certs.get(string) != null || this.keys.get(string) != null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.keys.remove(string);
        Certificate certificate = (Certificate)this.certs.remove(string);
        if (certificate != null) {
            this.chainCerts.remove(new CertId(certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = (String)this.localIds.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.keyCerts.remove(string2);
            }
            if (certificate != null) {
                this.chainCerts.remove(new CertId(certificate.getPublicKey()));
            }
        }
        if (certificate == null && key == null) {
            throw new KeyStoreException("no such entry as " + string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        Certificate certificate = (Certificate)this.certs.get(string);
        if (certificate == null) {
            String string2 = (String)this.localIds.get(string);
            certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.certs.elements();
        Enumeration enumeration2 = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2 = (Certificate)enumeration.nextElement();
            String string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                Object object;
                Object object2;
                Object object3;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        object3 = new ByteArrayInputStream(byArray);
                        object2 = new DERInputStream((InputStream)object3);
                        object3 = new ByteArrayInputStream(((ASN1OctetString)((DERInputStream)object2).readObject()).getOctets());
                        object2 = new DERInputStream((InputStream)object3);
                        object = new AuthorityKeyIdentifier((ASN1Sequence)((DERInputStream)object2).readObject());
                        if (((AuthorityKeyIdentifier)object).getKeyIdentifier() != null) {
                            certificate2 = (Certificate)this.chainCerts.get(new CertId(((AuthorityKeyIdentifier)object).getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !(object3 = certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                    object = this.chainCerts.keys();
                    while (object.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(object.nextElement());
                        Principal principal = x509Certificate.getSubjectDN();
                        if (!((Object)principal).equals(object3)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                vector.addElement(certificate);
                if (certificate2 != certificate) {
                    certificate = certificate2;
                    continue;
                }
                certificate = null;
            }
            certificateArray = new Certificate[vector.size()];
            for (int i = 0; i != certificateArray.length; ++i) {
                certificateArray[i] = (Certificate)vector.elementAt(i);
            }
            return certificateArray;
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return (Key)this.keys.get(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.certs.get(string) != null && this.keys.get(string) == null;
    }

    public boolean engineIsKeyEntry(String string) {
        return this.keys.get(string) != null;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.certs.get(string) != null) {
            throw new KeyStoreException("There is already a certificate with the name " + string + ".");
        }
        this.certs.put(string, certificate);
        this.chainCerts.put(new CertId(certificate.getPublicKey()), certificate);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(string) != null && !key.equals(this.keys.get(string))) {
            throw new KeyStoreException("There is already a key with the name " + string + ".");
        }
        this.keys.put(string, key);
        this.certs.put(string, certificateArray[0]);
        for (int i = 0; i != certificateArray.length; ++i) {
            this.chainCerts.put(new CertId(certificateArray[i].getPublicKey()), certificateArray[i]);
        }
    }

    public int engineSize() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray) throws IOException {
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((ASN1Sequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        PrivateKey privateKey = null;
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(4, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            privateKey = (PrivateKey)cipher.unwrap(byArray, "", 2);
        }
        catch (Exception exception) {
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        return privateKey;
    }

    protected byte[] wrapKey(String string, Key key, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray = cipher.wrap(key);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray;
    }

    protected ASN1Sequence decryptData(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray) throws IOException {
        Object object;
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((ASN1Sequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        byte[] byArray2 = null;
        try {
            object = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(2, (Key)((SecretKeyFactory)object).generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception decrypting data - " + exception.toString());
        }
        object = new BERInputStream(new ByteArrayInputStream(byArray2));
        return (ASN1Sequence)((BERInputStream)object).readObject();
    }

    protected byte[] encryptData(String string, byte[] byArray, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray2;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(1, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray2;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n = bufferedInputStream.read();
        if (n != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        BERInputStream bERInputStream = new BERInputStream(bufferedInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)bERInputStream.readObject();
        Pfx pfx = new Pfx(aSN1Sequence);
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<SafeBag> vector = new Vector<SafeBag>();
        boolean bl = false;
        if (pfx.getMacData() != null) {
            object11 = new ByteArrayOutputStream();
            object10 = new BEROutputStream((OutputStream)object11);
            MacData macData = pfx.getMacData();
            object9 = macData.getMac();
            object8 = ((DigestInfo)object9).getAlgorithmId();
            byte[] byArray = macData.getSalt();
            int n2 = macData.getIterationCount().intValue();
            ((BEROutputStream)object10).writeObject(contentInfo);
            object7 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                object6 = Mac.getInstance(((AlgorithmIdentifier)object8).getObjectId().getId(), "BC");
                object5 = SecretKeyFactory.getInstance(((AlgorithmIdentifier)object8).getObjectId().getId(), "BC");
                object4 = new PBEParameterSpec(byArray, n2);
                object3 = new PBEKeySpec(cArray);
                ((Mac)object6).init(((SecretKeyFactory)object5).generateSecret((KeySpec)object3), (AlgorithmParameterSpec)object4);
                ((Mac)object6).update((byte[])object7);
                object2 = ((Mac)object6).doFinal();
                object = ((DigestInfo)object9).getDigest();
                if (((byte[])object2).length != ((DigestInfo)object9).getDigest().length) {
                    throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                }
                for (int i = 0; i != ((byte[])object2).length; ++i) {
                    if (object2[i] == object[i]) continue;
                    throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                }
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.keys = new Hashtable();
        this.localIds = new Hashtable();
        if (contentInfo.getContentType().equals(data)) {
            bERInputStream = new BERInputStream(new ByteArrayInputStream(((ASN1OctetString)contentInfo.getContent()).getOctets()));
            object11 = new AuthenticatedSafe((ASN1Sequence)bERInputStream.readObject());
            object10 = ((AuthenticatedSafe)object11).getContentInfo();
            for (int i = 0; i != ((ContentInfo[])object10).length; ++i) {
                DERObject dERObject;
                ASN1Set aSN1Set;
                SafeBag safeBag;
                int n3;
                if (object10[i].getContentType().equals(data)) {
                    object9 = new DERInputStream(new ByteArrayInputStream(((ASN1OctetString)((ContentInfo)object10[i]).getContent()).getOctets()));
                    object8 = (ASN1Sequence)((DERInputStream)object9).readObject();
                    for (n3 = 0; n3 != ((ASN1Sequence)object8).size(); ++n3) {
                        safeBag = new SafeBag((ASN1Sequence)((ASN1Sequence)object8).getObjectAt(n3));
                        if (safeBag.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            object7 = new EncryptedPrivateKeyInfo((ASN1Sequence)safeBag.getBagValue());
                            object6 = this.unwrapKey(((EncryptedPrivateKeyInfo)object7).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object7).getEncryptedData(), cArray);
                            object5 = (PKCS12BagAttributeCarrier)object6;
                            object4 = null;
                            object3 = null;
                            if (safeBag.getBagAttributes() != null) {
                                object2 = safeBag.getBagAttributes().getObjects();
                                while (object2.hasMoreElements()) {
                                    object = (ASN1Sequence)object2.nextElement();
                                    DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(0);
                                    aSN1Set = (ASN1Set)((ASN1Sequence)object).getObjectAt(1);
                                    dERObject = null;
                                    if (aSN1Set.size() > 0) {
                                        dERObject = (DERObject)aSN1Set.getObjectAt(0);
                                        object5.setBagAttribute(dERObjectIdentifier, dERObject);
                                    }
                                    if (dERObjectIdentifier.equals(pkcs_9_at_friendlyName)) {
                                        object4 = ((DERBMPString)dERObject).getString();
                                        this.keys.put(object4, object6);
                                        continue;
                                    }
                                    if (!dERObjectIdentifier.equals(pkcs_9_at_localKeyId)) continue;
                                    object3 = (ASN1OctetString)dERObject;
                                }
                            }
                            if (object3 != null) {
                                object2 = new String(Hex.encode(((ASN1OctetString)object3).getOctets()));
                                if (object4 == null) {
                                    this.keys.put(object2, object6);
                                    continue;
                                }
                                this.localIds.put(object4, object2);
                                continue;
                            }
                            bl = true;
                            this.keys.put("unmarked", object6);
                            continue;
                        }
                        if (safeBag.getBagId().equals(certBag)) {
                            vector.addElement(safeBag);
                            continue;
                        }
                        System.out.println("extra " + safeBag.getBagId());
                        System.out.println("extra " + ASN1Dump.dumpAsString(safeBag));
                    }
                    continue;
                }
                if (((ContentInfo)object10[i]).getContentType().equals(encryptedData)) {
                    object9 = new EncryptedData((ASN1Sequence)((ContentInfo)object10[i]).getContent());
                    object8 = this.decryptData(((EncryptedData)object9).getEncryptionAlgorithm(), ((EncryptedData)object9).getContent().getOctets(), cArray);
                    for (n3 = 0; n3 != ((ASN1Sequence)object8).size(); ++n3) {
                        safeBag = new SafeBag((ASN1Sequence)((ASN1Sequence)object8).getObjectAt(n3));
                        if (safeBag.getBagId().equals(certBag)) {
                            vector.addElement(safeBag);
                            continue;
                        }
                        if (safeBag.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            object7 = new EncryptedPrivateKeyInfo((ASN1Sequence)safeBag.getBagValue());
                            object6 = this.unwrapKey(((EncryptedPrivateKeyInfo)object7).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object7).getEncryptedData(), cArray);
                            object5 = (PKCS12BagAttributeCarrier)object6;
                            object4 = null;
                            object3 = null;
                            object2 = safeBag.getBagAttributes().getObjects();
                            while (object2.hasMoreElements()) {
                                object = (ASN1Sequence)object2.nextElement();
                                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(0);
                                aSN1Set = (ASN1Set)((ASN1Sequence)object).getObjectAt(1);
                                dERObject = null;
                                if (aSN1Set.size() > 0) {
                                    dERObject = (DERObject)aSN1Set.getObjectAt(0);
                                    object5.setBagAttribute(dERObjectIdentifier, dERObject);
                                }
                                if (dERObjectIdentifier.equals(pkcs_9_at_friendlyName)) {
                                    object4 = ((DERBMPString)dERObject).getString();
                                    this.keys.put(object4, object6);
                                    continue;
                                }
                                if (!dERObjectIdentifier.equals(pkcs_9_at_localKeyId)) continue;
                                object3 = (ASN1OctetString)dERObject;
                            }
                            object = new String(Hex.encode(((ASN1OctetString)object3).getOctets()));
                            if (object4 == null) {
                                this.keys.put(object, object6);
                                continue;
                            }
                            this.localIds.put(object4, object);
                            continue;
                        }
                        if (safeBag.getBagId().equals(keyBag)) {
                            object7 = new PrivateKeyInfo((ASN1Sequence)safeBag.getBagValue());
                            object6 = JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo((PrivateKeyInfo)object7);
                            object5 = (PKCS12BagAttributeCarrier)object6;
                            object4 = null;
                            object3 = null;
                            object2 = safeBag.getBagAttributes().getObjects();
                            while (object2.hasMoreElements()) {
                                object = (ASN1Sequence)object2.nextElement();
                                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(0);
                                aSN1Set = (ASN1Set)((ASN1Sequence)object).getObjectAt(1);
                                dERObject = null;
                                if (aSN1Set.size() > 0) {
                                    dERObject = (DERObject)aSN1Set.getObjectAt(0);
                                    object5.setBagAttribute(dERObjectIdentifier, dERObject);
                                }
                                if (dERObjectIdentifier.equals(pkcs_9_at_friendlyName)) {
                                    object4 = ((DERBMPString)dERObject).getString();
                                    this.keys.put(object4, object6);
                                    continue;
                                }
                                if (!dERObjectIdentifier.equals(pkcs_9_at_localKeyId)) continue;
                                object3 = (ASN1OctetString)dERObject;
                            }
                            object = new String(Hex.encode(((ASN1OctetString)object3).getOctets()));
                            if (object4 == null) {
                                this.keys.put(object, object6);
                                continue;
                            }
                            this.localIds.put(object4, object);
                            continue;
                        }
                        System.out.println("extra " + safeBag.getBagId());
                        System.out.println("extra " + ASN1Dump.dumpAsString(safeBag));
                    }
                    continue;
                }
                System.out.println("extra " + ((ContentInfo)object10[i]).getContentType().getId());
                System.out.println("extra " + ASN1Dump.dumpAsString(((ContentInfo)object10[i]).getContent()));
            }
        }
        this.certs = new Hashtable();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i = 0; i != vector.size(); ++i) {
            Object object12;
            object10 = (SafeBag)vector.elementAt(i);
            CertBag certBag = new CertBag((ASN1Sequence)((SafeBag)object10).getBagValue());
            object9 = null;
            try {
                object8 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                object9 = this.certFact.generateCertificate((InputStream)object8);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.toString());
            }
            object8 = null;
            String string = null;
            if (((SafeBag)object10).getBagAttributes() != null) {
                object12 = ((SafeBag)object10).getBagAttributes().getObjects();
                while (object12.hasMoreElements()) {
                    object7 = (ASN1Sequence)object12.nextElement();
                    object6 = (DERObjectIdentifier)((ASN1Sequence)object7).getObjectAt(0);
                    object5 = (DERObject)((ASN1Set)((ASN1Sequence)object7).getObjectAt(1)).getObjectAt(0);
                    if (object9 instanceof PKCS12BagAttributeCarrier) {
                        object4 = (PKCS12BagAttributeCarrier)object9;
                        object4.setBagAttribute((DERObjectIdentifier)object6, (DEREncodable)object5);
                    }
                    if (((DERObjectIdentifier)object6).equals(pkcs_9_at_friendlyName)) {
                        string = ((DERBMPString)object5).getString();
                        continue;
                    }
                    if (!((DERObjectIdentifier)object6).equals(pkcs_9_at_localKeyId)) continue;
                    object8 = (ASN1OctetString)object5;
                }
            }
            this.chainCerts.put(new CertId(((Certificate)object9).getPublicKey()), object9);
            if (bl) {
                if (!this.keyCerts.isEmpty()) continue;
                object12 = new String(Hex.encode(this.createSubjectKeyId(((Certificate)object9).getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(object12, object9);
                this.keys.put(object12, this.keys.remove("unmarked"));
                continue;
            }
            if (string == null) {
                if (object8 == null) continue;
                object12 = new String(Hex.encode(((ASN1OctetString)object8).getOctets()));
                this.keyCerts.put(object12, object9);
                continue;
            }
            this.certs.put(string, object9);
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Enumeration enumeration;
        DEREncodable dEREncodable;
        DEREncodable dEREncodable2;
        Object object11;
        Object object12;
        Object object13;
        Object object14;
        Object object15;
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ContentInfo[] contentInfoArray = new ContentInfo[2];
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = this.keys.keys();
        while (enumeration2.hasMoreElements()) {
            object15 = new byte[20];
            this.random.nextBytes((byte[])object15);
            object14 = (String)enumeration2.nextElement();
            object13 = (PrivateKey)this.keys.get(object14);
            object12 = new PKCS12PBEParams((byte[])object15, 100);
            object11 = this.wrapKey(KEY_ALGORITHM, (Key)object13, (PKCS12PBEParams)object12, cArray);
            dEREncodable2 = new AlgorithmIdentifier(new DERObjectIdentifier(KEY_ALGORITHM), ((PKCS12PBEParams)object12).getDERObject());
            dEREncodable = new EncryptedPrivateKeyInfo((AlgorithmIdentifier)dEREncodable2, (byte[])object11);
            boolean bl = false;
            enumeration = new ASN1EncodableVector();
            if (object13 instanceof PKCS12BagAttributeCarrier) {
                Object object16;
                object10 = (PKCS12BagAttributeCarrier)object13;
                object9 = (DERBMPString)object10.getBagAttribute(pkcs_9_at_friendlyName);
                if (object9 == null || !((DERBMPString)object9).getString().equals(object14)) {
                    object10.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object14));
                }
                if (object10.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                    object16 = this.engineGetCertificate((String)object14);
                    object10.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(((Certificate)object16).getPublicKey()));
                }
                object16 = object10.getBagAttributeKeys();
                while (object16.hasMoreElements()) {
                    object8 = (DERObjectIdentifier)object16.nextElement();
                    object7 = new ASN1EncodableVector();
                    ((DEREncodableVector)object7).add((DEREncodable)object8);
                    ((DEREncodableVector)object7).add(new DERSet(object10.getBagAttribute((DERObjectIdentifier)object8)));
                    bl = true;
                    ((DEREncodableVector)((Object)enumeration)).add(new DERSequence((DEREncodableVector)object7));
                }
            }
            if (!bl) {
                object10 = new ASN1EncodableVector();
                object9 = this.engineGetCertificate((String)object14);
                ((DEREncodableVector)object10).add(pkcs_9_at_localKeyId);
                ((DEREncodableVector)object10).add(new DERSet(this.createSubjectKeyId(((Certificate)object9).getPublicKey())));
                ((DEREncodableVector)((Object)enumeration)).add(new DERSequence((DEREncodableVector)object10));
                object10 = new ASN1EncodableVector();
                ((DEREncodableVector)object10).add(pkcs_9_at_friendlyName);
                ((DEREncodableVector)object10).add(new DERSet(new DERBMPString((String)object14)));
                ((DEREncodableVector)((Object)enumeration)).add(new DERSequence((DEREncodableVector)object10));
            }
            object10 = new SafeBag(pkcs8ShroudedKeyBag, ((EncryptedPrivateKeyInfo)dEREncodable).getDERObject(), new DERSet((DEREncodableVector)((Object)enumeration)));
            aSN1EncodableVector.add((DEREncodable)object10);
        }
        object15 = new ByteArrayOutputStream();
        object14 = new DEROutputStream((OutputStream)object15);
        ((DEROutputStream)object14).writeObject(new DERSequence(aSN1EncodableVector));
        object13 = new BERConstructedOctetString(((ByteArrayOutputStream)object15).toByteArray());
        object12 = new byte[20];
        this.random.nextBytes((byte[])object12);
        object11 = new ASN1EncodableVector();
        dEREncodable2 = new PKCS12PBEParams((byte[])object12, 100);
        dEREncodable = new AlgorithmIdentifier(new DERObjectIdentifier(CERT_ALGORITHM), ((PKCS12PBEParams)dEREncodable2).getDERObject());
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object10 = (String)enumeration.nextElement();
                object9 = this.engineGetCertificate((String)object10);
                boolean bl = false;
                object8 = new CertBag(x509certType, new DEROctetString(((Certificate)object9).getEncoded()));
                object7 = new ASN1EncodableVector();
                if (object9 instanceof PKCS12BagAttributeCarrier) {
                    object6 = (PKCS12BagAttributeCarrier)object9;
                    object5 = (DERBMPString)object6.getBagAttribute(pkcs_9_at_friendlyName);
                    if (object5 == null || !((DERBMPString)object5).getString().equals(object10)) {
                        object6.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object10));
                    }
                    if (object6.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                        object6.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(((Certificate)object9).getPublicKey()));
                    }
                    object4 = object6.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        object3 = (DERObjectIdentifier)object4.nextElement();
                        object2 = new ASN1EncodableVector();
                        ((DEREncodableVector)object2).add((DEREncodable)object3);
                        ((DEREncodableVector)object2).add(new DERSet(object6.getBagAttribute((DERObjectIdentifier)object3)));
                        ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object2));
                        bl = true;
                    }
                }
                if (!bl) {
                    object6 = new ASN1EncodableVector();
                    ((DEREncodableVector)object6).add(pkcs_9_at_localKeyId);
                    ((DEREncodableVector)object6).add(new DERSet(this.createSubjectKeyId(((Certificate)object9).getPublicKey())));
                    ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
                    object6 = new ASN1EncodableVector();
                    ((DEREncodableVector)object6).add(pkcs_9_at_friendlyName);
                    ((DEREncodableVector)object6).add(new DERSet(new DERBMPString((String)object10)));
                    ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
                }
                object6 = new SafeBag(certBag, ((CertBag)object8).getDERObject(), new DERSet((DEREncodableVector)object7));
                ((DEREncodableVector)object11).add((DEREncodable)object6);
                hashtable.put(object9, object9);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object10 = (String)enumeration.nextElement();
                object9 = (Certificate)this.certs.get(object10);
                boolean bl = false;
                if (this.keys.get(object10) != null) continue;
                object8 = new CertBag(x509certType, new DEROctetString(((Certificate)object9).getEncoded()));
                object7 = new ASN1EncodableVector();
                if (object9 instanceof PKCS12BagAttributeCarrier) {
                    object6 = (PKCS12BagAttributeCarrier)object9;
                    object5 = (DERBMPString)object6.getBagAttribute(pkcs_9_at_friendlyName);
                    if (object5 == null || !((DERBMPString)object5).getString().equals(object10)) {
                        object6.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object10));
                    }
                    object4 = object6.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        object3 = (DERObjectIdentifier)object4.nextElement();
                        object2 = new ASN1EncodableVector();
                        ((DEREncodableVector)object2).add((DEREncodable)object3);
                        ((DEREncodableVector)object2).add(new DERSet(object6.getBagAttribute((DERObjectIdentifier)object3)));
                        ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object2));
                        bl = true;
                    }
                }
                if (!bl) {
                    object6 = new ASN1EncodableVector();
                    ((DEREncodableVector)object6).add(pkcs_9_at_friendlyName);
                    ((DEREncodableVector)object6).add(new DERSet(new DERBMPString((String)object10)));
                    ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
                }
                object6 = new SafeBag(certBag, ((CertBag)object8).getDERObject(), new DERSet((DEREncodableVector)object7));
                ((DEREncodableVector)object11).add((DEREncodable)object6);
                hashtable.put(object9, object9);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration = this.chainCerts.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object10 = (CertId)enumeration.nextElement();
                object9 = (Certificate)this.chainCerts.get(object10);
                if (hashtable.get(object9) != null) continue;
                CertBag certBag = new CertBag(x509certType, new DEROctetString(((Certificate)object9).getEncoded()));
                object8 = new ASN1EncodableVector();
                if (object9 instanceof PKCS12BagAttributeCarrier) {
                    object7 = (PKCS12BagAttributeCarrier)object9;
                    object6 = object7.getBagAttributeKeys();
                    while (object6.hasMoreElements()) {
                        object5 = (DERObjectIdentifier)object6.nextElement();
                        object4 = new ASN1EncodableVector();
                        ((DEREncodableVector)object4).add((DEREncodable)object5);
                        ((DEREncodableVector)object4).add(new DERSet(object7.getBagAttribute((DERObjectIdentifier)object5)));
                        ((DEREncodableVector)object8).add(new DERSequence((DEREncodableVector)object4));
                    }
                }
                object7 = new SafeBag(JDKPKCS12KeyStore.certBag, certBag.getDERObject(), new DERSet((DEREncodableVector)object8));
                ((DEREncodableVector)object11).add((DEREncodable)object7);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        ((ByteArrayOutputStream)object15).reset();
        object14 = new DEROutputStream((OutputStream)object15);
        ((DEROutputStream)object14).writeObject(new DERSequence((DEREncodableVector)object11));
        ((FilterOutputStream)object14).close();
        object10 = this.encryptData(CERT_ALGORITHM, ((ByteArrayOutputStream)object15).toByteArray(), (PKCS12PBEParams)dEREncodable2, cArray);
        object9 = new EncryptedData(data, (AlgorithmIdentifier)dEREncodable, new BERConstructedOctetString((byte[])object10));
        contentInfoArray[0] = new ContentInfo(data, (DEREncodable)object13);
        contentInfoArray[1] = new ContentInfo(encryptedData, ((EncryptedData)object9).getDERObject());
        AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe(contentInfoArray);
        ((ByteArrayOutputStream)object15).reset();
        object8 = new BEROutputStream((OutputStream)object15);
        ((BEROutputStream)object8).writeObject(authenticatedSafe);
        object7 = ((ByteArrayOutputStream)object15).toByteArray();
        object6 = new ContentInfo(data, new BERConstructedOctetString((byte[])object7));
        object5 = new byte[20];
        int n = 100;
        this.random.nextBytes((byte[])object5);
        object3 = ((ASN1OctetString)((ContentInfo)object6).getContent()).getOctets();
        object2 = null;
        try {
            object = Mac.getInstance(id_SHA1.getId(), "BC");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(id_SHA1.getId(), "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec((byte[])object5, n);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            ((Mac)object).init(secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            ((Mac)object).update((byte[])object3);
            byte[] byArray = ((Mac)object).doFinal();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(id_SHA1, null);
            DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray);
            object2 = new MacData(digestInfo, (byte[])object5, n);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        object = new Pfx((ContentInfo)object6, (MacData)object2);
        object8 = new BEROutputStream(outputStream);
        ((BEROutputStream)object8).writeObject(object);
    }

    public static class DefPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore() {
            super(null);
        }
    }

    public static class BCPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore() {
            super("BC");
        }
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey publicKey) {
            this.id = JDKPKCS12KeyStore.this.createSubjectKeyId(publicKey).getKeyIdentifier();
        }

        CertId(byte[] byArray) {
            this.id = byArray;
        }

        public int hashCode() {
            int n = this.id[0] & 0xFF;
            for (int i = 1; i != this.id.length - 4; ++i) {
                n ^= (this.id[i] & 0xFF) << 24 | (this.id[i + 1] & 0xFF) << 16 | (this.id[i + 2] & 0xFF) << 8 | this.id[i + 3] & 0xFF;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CertId)) {
                return false;
            }
            CertId certId = (CertId)object;
            if (certId.id.length != this.id.length) {
                return false;
            }
            for (int i = 0; i != this.id.length; ++i) {
                if (certId.id[i] == this.id[i]) continue;
                return false;
            }
            return true;
        }
    }
}

