/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.AbstractJavaccTask;
import ca.coglinc.gradle.plugins.javacc.JavaccSourceFileVisitor;
import ca.coglinc.gradle.plugins.javacc.ProgramArguments;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public class CompileJjdocTask
extends AbstractJavaccTask {
    public static final String TASK_NAME_VALUE = "jjdoc";
    public static final String TASK_DESCRIPTION_VALUE = "Takes a JavaCC parser specification and produces documentation for the BNF grammar";
    private static final String DEFAULT_INPUT_DIRECTORY = File.separator + "src" + File.separator + "main" + File.separator + "javacc";
    private static final String DEFAULT_OUTPUT_DIRECTORY = File.separator + "generated" + File.separator + "jjdoc";
    private static final String SUPPORTED_FILE_SUFFIX = ".jj";

    public CompileJjdocTask() {
        super(DEFAULT_INPUT_DIRECTORY, DEFAULT_OUTPUT_DIRECTORY, "**/*.jj");
    }

    @TaskAction
    public void run() {
        this.getTempOutputDirectory().mkdirs();
        this.compileSourceFilesToTempOutputDirectory();
        this.copyCompiledFilesFromTempOutputDirectoryToOutputDirectory();
        FileUtils.deleteQuietly((File)this.getTempOutputDirectory());
    }

    @Override
    protected void invokeCompiler(final ProgramArguments arguments) throws Exception {
        ExecResult execResult = this.getProject().javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec executor) {
                executor.classpath(new Object[]{CompileJjdocTask.this.getClasspath()});
                executor.setMain("org.javacc.jjdoc.JJDocMain");
                executor.args((Object[])arguments.toArray());
                executor.setIgnoreExitValue(true);
            }
        });
        if (execResult.getExitValue() != 0) {
            throw new IllegalStateException("JJDoc failed with error code: [" + execResult.getExitValue() + "]");
        }
    }

    @Override
    protected FileVisitor getJavaccSourceFileVisitor() {
        return new JavaccSourceFileVisitor(this);
    }

    @Override
    protected void augmentArguments(File inputDirectory, RelativePath inputRelativePath, ProgramArguments arguments) {
        File tempOutputFile = inputRelativePath.getFile(this.getTempOutputDirectory());
        tempOutputFile.mkdirs();
        String outputFileExtension = this.getJjdocOutputFileExtension(arguments);
        arguments.add("OUTPUT_FILE", tempOutputFile.getAbsolutePath().replace(SUPPORTED_FILE_SUFFIX, outputFileExtension));
    }

    private String getJjdocOutputFileExtension(ProgramArguments arguments) {
        String outputFileExtension = ".html";
        if (IterableUtils.matchesAny(Arrays.asList(arguments.toArray()), this.outputTextPredicate())) {
            outputFileExtension = ".txt";
        }
        return outputFileExtension;
    }

    private Predicate<String> outputTextPredicate() {
        return new Predicate<String>(){

            public boolean evaluate(String argument) {
                return "-text=true".equals(argument.toLowerCase());
            }
        };
    }

    @Override
    protected String getProgramName() {
        return "JJDoc";
    }

    @Override
    protected String supportedSuffix() {
        return SUPPORTED_FILE_SUFFIX;
    }
}

