/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public enum EncodingEnum {
    JSON("application/json+fhir", "application/fhir+json", "json"){

        @Override
        public IParser newParser(FhirContext theContext) {
            return theContext.newJsonParser();
        }
    }
    ,
    XML("application/xml+fhir", "application/fhir+xml", "xml"){

        @Override
        public IParser newParser(FhirContext theContext) {
            return theContext.newXmlParser();
        }
    };

    public static final String JSON_PLAIN_STRING = "json";
    private static Map<String, EncodingEnum> ourContentTypeToEncoding;
    private static Map<String, EncodingEnum> ourContentTypeToEncodingNonLegacy;
    private static Map<String, EncodingEnum> ourContentTypeToEncodingStrict;
    public static final String XML_PLAIN_STRING = "xml";
    private String myFormatContentType;
    private String myResourceContentTypeLegacy;
    private String myResourceContentTypeNonLegacy;

    private EncodingEnum(String theResourceContentTypeLegacy, String theResourceContentType, String theFormatContentType) {
        this.myResourceContentTypeLegacy = theResourceContentTypeLegacy;
        this.myResourceContentTypeNonLegacy = theResourceContentType;
        this.myFormatContentType = theFormatContentType;
    }

    public String getFormatContentType() {
        return this.myFormatContentType;
    }

    public String getRequestContentType() {
        return this.myFormatContentType;
    }

    public String getResourceContentType() {
        return this.myResourceContentTypeLegacy;
    }

    public String getResourceContentTypeNonLegacy() {
        return this.myResourceContentTypeNonLegacy;
    }

    public abstract IParser newParser(FhirContext var1);

    public static EncodingEnum detectEncoding(String theBody) {
        EncodingEnum retVal = EncodingEnum.detectEncodingNoDefault(theBody);
        retVal = (EncodingEnum)((Object)ObjectUtils.defaultIfNull((Object)((Object)retVal), (Object)((Object)XML)));
        return retVal;
    }

    public static EncodingEnum detectEncodingNoDefault(String theBody) {
        EncodingEnum retVal = null;
        block4: for (int i = 0; i < theBody.length() && retVal == null; ++i) {
            switch (theBody.charAt(i)) {
                case '<': {
                    retVal = XML;
                    continue block4;
                }
                case '{': {
                    retVal = JSON;
                }
            }
        }
        return retVal;
    }

    public static EncodingEnum forContentType(String theContentType) {
        return ourContentTypeToEncoding.get(theContentType);
    }

    public static EncodingEnum forContentTypeStrict(String theContentType) {
        return ourContentTypeToEncodingStrict.get(theContentType);
    }

    public static boolean isNonLegacy(String theFormat) {
        return ourContentTypeToEncodingNonLegacy.containsKey(theFormat);
    }

    static {
        ourContentTypeToEncoding = new HashMap<String, EncodingEnum>();
        ourContentTypeToEncodingNonLegacy = new HashMap<String, EncodingEnum>();
        for (EncodingEnum next : EncodingEnum.values()) {
            ourContentTypeToEncoding.put(next.myResourceContentTypeNonLegacy, next);
            ourContentTypeToEncoding.put(next.myResourceContentTypeLegacy, next);
            ourContentTypeToEncodingNonLegacy.put(next.myResourceContentTypeNonLegacy, next);
            ourContentTypeToEncoding.put(next.myResourceContentTypeNonLegacy.replace('+', ' '), next);
            ourContentTypeToEncoding.put(next.myResourceContentTypeLegacy.replace('+', ' '), next);
            ourContentTypeToEncodingNonLegacy.put(next.myResourceContentTypeNonLegacy.replace('+', ' '), next);
        }
        ourContentTypeToEncodingStrict = Collections.unmodifiableMap(new HashMap<String, EncodingEnum>(ourContentTypeToEncoding));
        ourContentTypeToEncoding.put("application/json", JSON);
        ourContentTypeToEncoding.put("application/xml", XML);
        ourContentTypeToEncoding.put("text/json", JSON);
        ourContentTypeToEncoding.put("text/xml", XML);
        ourContentTypeToEncoding.put(JSON_PLAIN_STRING, JSON);
        ourContentTypeToEncoding.put(XML_PLAIN_STRING, XML);
        ourContentTypeToEncodingNonLegacy = Collections.unmodifiableMap(ourContentTypeToEncodingNonLegacy);
    }
}

