/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeElemContainedResourceList;
import ca.uhn.fhir.context.RuntimeElemContainedResources;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class RuntimeChildContainedResources
extends BaseRuntimeDeclaredChildDefinition {
    private BaseRuntimeElementDefinition<?> myElem;

    RuntimeChildContainedResources(Field theField, Child theChildAnnotation, Description theDescriptionAnnotation, String theElementName) throws ConfigurationException {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    public int getMin() {
        return 0;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        assert (theName.equals(this.getElementName()));
        return this.myElem;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theType) {
        return this.myElem;
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theType) {
        return this.getElementName();
    }

    @Override
    public Set<String> getValidChildNames() {
        return Collections.singleton(this.getElementName());
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        Class<?> actualType = theContext.getVersion().getContainedType();
        if (BaseContainedDt.class.isAssignableFrom(actualType)) {
            Class<?> type = actualType;
            this.myElem = new RuntimeElemContainedResources(type, false);
        } else if (List.class.isAssignableFrom(actualType)) {
            this.myElem = new RuntimeElemContainedResourceList(IBaseResource.class, false);
        } else {
            throw new ConfigurationException("Fhir Version definition returned invalid contained type: " + actualType);
        }
    }
}

