/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeNarrativeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.base.resource.ResourceMetadataMap;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.json.JsonLikeValue;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.IModelVisitor;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParserState<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(ParserState.class);
    private List<String> myComments = new ArrayList<String>(2);
    private final FhirContext myContext;
    private final IParserErrorHandler myErrorHandler;
    private final boolean myJsonMode;
    private T myObject;
    private final IParser myParser;
    private IBase myPreviousElement;
    private BaseState myState;

    private ParserState(IParser theParser, FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) {
        this.myParser = theParser;
        this.myContext = theContext;
        this.myJsonMode = theJsonMode;
        this.myErrorHandler = theErrorHandler;
    }

    public void attributeValue(String theName, String theValue) throws DataFormatException {
        this.myState.attributeValue(theName, theValue);
    }

    public void commentPost(String theCommentText) {
        if (this.myPreviousElement != null) {
            this.myPreviousElement.getFormatCommentsPost().add(theCommentText);
        }
    }

    public void commentPre(String theCommentText) {
        if (this.myState.getCurrentElement() != null) {
            IBase element = this.myState.getCurrentElement();
            element.getFormatCommentsPre().add(theCommentText);
        }
    }

    public boolean elementIsRepeating(String theChildName) {
        return this.myState.elementIsRepeating(theChildName);
    }

    public void endingElement() throws DataFormatException {
        this.myState.endingElement();
    }

    public void enteringNewElement(String theNamespaceUri, String theName) throws DataFormatException {
        this.myState.enteringNewElement(theNamespaceUri, theName);
    }

    public void enteringNewElementExtension(StartElement theElem, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
        this.myState.enteringNewElementExtension(theElem, theUrlAttr, theIsModifier, baseServerUrl);
    }

    public T getObject() {
        return this.myObject;
    }

    public boolean isPreResource() {
        return this.myState.isPreResource();
    }

    private Object newContainedDt(IResource theTarget) {
        return ReflectionUtil.newInstance(theTarget.getStructureFhirVersionEnum().getVersionImplementation().getContainedType());
    }

    private void pop() {
        this.myPreviousElement = this.myState.getCurrentElement();
        if (this.myState.myStack != null) {
            this.myState = this.myState.myStack;
            this.myState.wereBack();
        } else {
            this.myObject = this.myState.getCurrentElement();
            this.myState = null;
        }
    }

    private void push(BaseState theState) {
        theState.setStack(this.myState);
        this.myState = theState;
        if (!this.myComments.isEmpty() && this.myState.getCurrentElement() != null) {
            this.myState.getCurrentElement().getFormatCommentsPre().addAll(this.myComments);
            this.myComments.clear();
        }
    }

    public void string(String theData) {
        this.myState.string(theData);
    }

    public boolean verifyNamespace(String theExpect, String theActual) {
        if (this.myJsonMode) {
            return true;
        }
        return StringUtils.equals((CharSequence)theExpect, (CharSequence)theActual);
    }

    public void xmlEvent(XMLEvent theNextEvent) {
        if (this.myState != null) {
            this.myState.xmlEvent(theNextEvent);
        }
    }

    static <T extends IBaseResource> ParserState<T> getPreResourceInstance(IParser theParser, Class<T> theResourceType, FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) throws DataFormatException {
        ParserState<T> retVal = new ParserState<T>(theParser, theContext, theJsonMode, theErrorHandler);
        if (theResourceType == null) {
            if (theContext.getVersion().getVersion().isRi()) {
                ParserState<T> parserState = retVal;
                parserState.getClass();
                super.push(parserState.new PreResourceStateHl7Org(theResourceType));
            } else {
                ParserState<T> parserState = retVal;
                parserState.getClass();
                super.push(parserState.new PreResourceStateHapi(theResourceType));
            }
        } else if (IResource.class.isAssignableFrom(theResourceType)) {
            ParserState<T> parserState = retVal;
            parserState.getClass();
            super.push(parserState.new PreResourceStateHapi(theResourceType));
        } else {
            ParserState<T> parserState = retVal;
            parserState.getClass();
            super.push(parserState.new PreResourceStateHl7Org(theResourceType));
        }
        return retVal;
    }

    static ParserState<TagList> getPreTagListInstance(IParser theParser, FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) {
        ParserState<TagList> retVal = new ParserState<TagList>(theParser, theContext, theJsonMode, theErrorHandler);
        super.push(retVal.new PreTagListState());
        return retVal;
    }

    private class XhtmlStateHl7Org
    extends XhtmlState {
        private IBaseXhtml myHl7OrgDatatype;

        private XhtmlStateHl7Org(PreResourceState thePreResourceState, IBaseXhtml theHl7OrgDatatype) {
            super(thePreResourceState, new XhtmlDt(), true);
            this.myHl7OrgDatatype = theHl7OrgDatatype;
        }

        @Override
        public void doPop() {
            String value = this.getDt().getValueAsString();
            this.myHl7OrgDatatype.setValueAsString(value);
            super.doPop();
        }
    }

    private class XhtmlState
    extends BaseState {
        private int myDepth;
        private XhtmlDt myDt;
        private List<XMLEvent> myEvents;
        private boolean myIncludeOuterEvent;

        private XhtmlState(PreResourceState thePreResourceState, XhtmlDt theXhtmlDt, boolean theIncludeOuterEvent) throws DataFormatException {
            super(thePreResourceState);
            this.myEvents = new ArrayList<XMLEvent>();
            this.myDepth = 0;
            this.myDt = theXhtmlDt;
            this.myIncludeOuterEvent = theIncludeOuterEvent;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (ParserState.this.myJsonMode) {
                this.myDt.setValueAsString(theValue);
            }
        }

        protected void doPop() {
            ParserState.this.pop();
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (ParserState.this.myJsonMode) {
                this.doPop();
                return;
            }
            super.endingElement();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
        }

        @Override
        protected IElement getCurrentElement() {
            return this.myDt;
        }

        public XhtmlDt getDt() {
            return this.myDt;
        }

        @Override
        public void xmlEvent(XMLEvent theEvent) {
            if (theEvent.isEndElement()) {
                --this.myDepth;
            }
            if (this.myIncludeOuterEvent || this.myDepth > 0) {
                this.myEvents.add(theEvent);
            }
            if (theEvent.isStartElement()) {
                ++this.myDepth;
            }
            if (theEvent.isEndElement() && this.myDepth == 0) {
                String eventsAsString = XmlUtil.encode(this.myEvents);
                this.myDt.setValue(eventsAsString);
                this.doPop();
            }
        }
    }

    private class TagState
    extends BaseState {
        private static final int LABEL = 2;
        private static final int NONE = 0;
        private static final int SCHEME = 3;
        private static final int TERM = 1;
        private String myLabel;
        private String myScheme;
        private int mySubState;
        private TagList myTagList;
        private String myTerm;

        public TagState(TagList theTagList) {
            super(null);
            this.mySubState = 0;
            this.myTagList = theTagList;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            String value = (String)StringUtils.defaultIfBlank((CharSequence)theValue, null);
            switch (this.mySubState) {
                case 1: {
                    this.myTerm = value;
                    break;
                }
                case 2: {
                    this.myLabel = value;
                    break;
                }
                case 3: {
                    this.myScheme = value;
                    break;
                }
                case 0: {
                    this.enteringNewElement(null, theName);
                    this.attributeValue(null, value);
                    this.endingElement();
                }
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.mySubState != 0) {
                this.mySubState = 0;
            } else {
                if (StringUtils.isNotEmpty((CharSequence)this.myScheme) || StringUtils.isNotBlank((CharSequence)this.myTerm) || StringUtils.isNotBlank((CharSequence)this.myLabel)) {
                    this.myTagList.addTag(this.myScheme, this.myTerm, this.myLabel);
                }
                ParserState.this.pop();
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("term".equals(theLocalPart) || "code".equals(theLocalPart)) {
                this.mySubState = 1;
            } else if ("scheme".equals(theLocalPart) || "system".equals(theLocalPart)) {
                this.mySubState = 3;
            } else if ("label".equals(theLocalPart) || "display".equals(theLocalPart)) {
                this.mySubState = 2;
            } else {
                throw new DataFormatException("Unexpected element: " + theLocalPart);
            }
        }
    }

    private class TagListState
    extends BaseState {
        private TagList myTagList;

        public TagListState(TagList theTagList) {
            super(null);
            this.myTagList = theTagList;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!"category".equals(theLocalPart)) {
                throw new DataFormatException("Unexpected element: " + theLocalPart);
            }
            ParserState.this.push(new TagState(this.myTagList));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myTagList;
        }
    }

    private class SwallowChildrenWholeState
    extends BaseState {
        private int myDepth;

        public SwallowChildrenWholeState(PreResourceState thePreResourceState) {
            super(thePreResourceState);
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
        }

        @Override
        public void endingElement() throws DataFormatException {
            --this.myDepth;
            if (this.myDepth < 0) {
                ParserState.this.pop();
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ++this.myDepth;
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            ++this.myDepth;
        }
    }

    private class SecurityLabelElementStateHapi
    extends ElementCompositeState {
        public SecurityLabelElementStateHapi(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IBase codingDt) {
            super(thePreResourceState, theDef.getName(), theDef, codingDt);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }
    }

    private class ResourceStateHl7Org
    extends ElementCompositeState {
        public ResourceStateHl7Org(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IBaseResource theInstance) {
            super(thePreResourceState, theDef.getName(), theDef, theInstance);
        }
    }

    private class ResourceStateHapi
    extends ElementCompositeState {
        private IResource myInstance;

        public ResourceStateHapi(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IResource theInstance) {
            super(thePreResourceState, theDef.getName(), theDef, theInstance);
            this.myInstance = theInstance;
        }

        @Override
        public void enteringNewElement(String theNamespace, String theChildName) throws DataFormatException {
            if ("id".equals(theChildName)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myInstance.getId()));
            } else if ("meta".equals(theChildName)) {
                ParserState.this.push(new MetaElementState(this.getPreResourceState(), this.myInstance.getResourceMetadata()));
            } else {
                super.enteringNewElement(theNamespace, theChildName);
            }
        }
    }

    private class PrimitiveState
    extends BaseState {
        private IPrimitiveType<?> myInstance;

        public PrimitiveState(PreResourceState thePreResourceState, IPrimitiveType<?> theInstance) {
            super(thePreResourceState);
            this.myInstance = theInstance;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("value".equals(theName)) {
                if ("".equals(theValue)) {
                    ParserState.this.myErrorHandler.invalidValue(null, theValue, "Attribute values must not be empty (\"\")");
                } else {
                    try {
                        this.myInstance.setValueAsString(theValue);
                    }
                    catch (DataFormatException e) {
                        ParserState.this.myErrorHandler.invalidValue(null, theValue, e.getMessage());
                    }
                    catch (IllegalArgumentException e) {
                        ParserState.this.myErrorHandler.invalidValue(null, theValue, e.getMessage());
                    }
                }
            } else if ("id".equals(theName)) {
                if (this.myInstance instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)((Object)this.myInstance)).setElementSpecificId(theValue);
                } else if (this.myInstance instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.myInstance)).setId(theValue);
                } else if (this.myInstance instanceof IBaseResource) {
                    new IdDt(theValue).applyTo((IBaseResource)((Object)this.myInstance));
                } else {
                    ParserState.this.myErrorHandler.unknownAttribute(null, theName);
                }
            } else {
                ParserState.this.myErrorHandler.unknownAttribute(null, theName);
            }
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myInstance;
        }
    }

    private class PreTagListState
    extends BaseState {
        private TagList myTagList;

        public PreTagListState() {
            super(null);
            this.myTagList = new TagList();
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!TagList.ELEMENT_NAME_LC.equals(theLocalPart.toLowerCase())) {
                throw new DataFormatException("resourceType does not appear to be 'TagList', found: " + theLocalPart);
            }
            ParserState.this.push(new TagListState(this.myTagList));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myTagList;
        }

        @Override
        public boolean isPreResource() {
            return true;
        }
    }

    private class PreResourceStateHl7Org
    extends PreResourceState {
        private BaseRuntimeChildDefinition.IMutator myMutator;
        private Object myTarget;

        public PreResourceStateHl7Org(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
        }

        public PreResourceStateHl7Org(Object theTarget, BaseRuntimeChildDefinition.IMutator theMutator, Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            this.myMutator = theMutator;
            this.myTarget = theTarget;
        }

        @Override
        protected void populateTarget() {
            this.weaveContainedResources();
            if (this.myMutator != null) {
                this.myMutator.setValue(this.myTarget, this.getCurrentElement());
            }
        }

        @Override
        public void wereBack() {
            super.wereBack();
            if (this.getCurrentElement() instanceof IDomainResource) {
                IDomainResource elem = (IDomainResource)this.getCurrentElement();
                String resourceName = ParserState.this.myContext.getResourceDefinition(elem).getName();
                String versionId = elem.getMeta().getVersionId();
                if (!StringUtils.isBlank((CharSequence)elem.getIdElement().getIdPart())) {
                    if (StringUtils.isNotBlank((CharSequence)versionId)) {
                        elem.getIdElement().setValue(resourceName + "/" + elem.getIdElement().getIdPart() + "/_history/" + versionId);
                    } else {
                        elem.getIdElement().setValue(resourceName + "/" + elem.getIdElement().getIdPart());
                    }
                }
            }
        }
    }

    private class PreResourceStateHapi
    extends PreResourceState {
        private BaseRuntimeChildDefinition.IMutator myMutator;
        private Object myTarget;

        public PreResourceStateHapi(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            assert (theResourceType == null || IResource.class.isAssignableFrom(theResourceType));
        }

        public PreResourceStateHapi(Object theTarget, BaseRuntimeChildDefinition.IMutator theMutator, Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            this.myTarget = theTarget;
            this.myMutator = theMutator;
            assert (theResourceType == null || IResource.class.isAssignableFrom(theResourceType));
        }

        @Override
        protected void populateTarget() {
            this.weaveContainedResources();
            if (this.myMutator != null) {
                this.myMutator.setValue(this.myTarget, this.getCurrentElement());
            }
        }

        @Override
        public void wereBack() {
            super.wereBack();
            IResource nextResource = (IResource)this.getCurrentElement();
            String version = ResourceMetadataKeyEnum.VERSION.get(nextResource);
            String resourceName = ParserState.this.myContext.getResourceDefinition(nextResource).getName();
            String bundleIdPart = nextResource.getId().getIdPart();
            if (StringUtils.isNotBlank((CharSequence)bundleIdPart)) {
                IdDt previousId = nextResource.getId();
                nextResource.setId(new IdDt(null, resourceName, bundleIdPart, version));
                if (!previousId.getAllUndeclaredExtensions().isEmpty()) {
                    for (ExtensionDt ext : previousId.getAllUndeclaredExtensions()) {
                        nextResource.getId().addUndeclaredExtension(ext);
                    }
                }
            }
        }
    }

    private abstract class PreResourceState
    extends BaseState {
        private Map<String, IBaseResource> myContainedResources;
        private IBaseResource myInstance;
        private FhirVersionEnum myParentVersion;
        private boolean myRequireResourceType;
        private Class<? extends IBaseResource> myResourceType;

        public PreResourceState(Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myRequireResourceType = true;
            this.myResourceType = theResourceType;
            this.myContainedResources = new HashMap<String, IBaseResource>();
            this.myParentVersion = theResourceType != null ? ParserState.this.myContext.getResourceDefinition(theResourceType).getStructureVersion() : ParserState.this.myContext.getVersion().getVersion();
        }

        public PreResourceState(PreResourceState thePreResourcesState, FhirVersionEnum theParentVersion) {
            super(thePreResourcesState);
            this.myRequireResourceType = true;
            Validate.notNull((Object)((Object)theParentVersion));
            this.myParentVersion = theParentVersion;
            this.myContainedResources = thePreResourcesState.getContainedResources();
        }

        @Override
        public void endingElement() throws DataFormatException {
            this.stitchBundleCrossReferences();
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            RuntimeResourceDefinition definition;
            if (this.myResourceType == null) {
                definition = null;
                if (ParserState.this.myParser.getPreferTypes() != null) {
                    for (Class<? extends IBaseResource> next : ParserState.this.myParser.getPreferTypes()) {
                        RuntimeResourceDefinition nextDef = ParserState.this.myContext.getResourceDefinition(next);
                        if (!nextDef.getName().equals(theLocalPart)) continue;
                        definition = nextDef;
                    }
                }
                if (definition == null) {
                    definition = ParserState.this.myContext.getResourceDefinition(this.myParentVersion, theLocalPart);
                }
                if (definition == null) {
                    throw new DataFormatException("Element '" + theLocalPart + "' is not a known resource type, expected a resource at this position");
                }
            } else {
                definition = ParserState.this.myContext.getResourceDefinition(this.myResourceType);
                if (!StringUtils.equals((CharSequence)theLocalPart, (CharSequence)definition.getName())) {
                    if (this.myRequireResourceType) {
                        throw new DataFormatException(ParserState.this.myContext.getLocalizer().getMessage(ParserState.class, "wrongResourceTypeFound", definition.getName(), theLocalPart));
                    }
                    definition = ParserState.this.myContext.getResourceDefinition(theLocalPart);
                    if (!(definition instanceof RuntimeResourceDefinition)) {
                        throw new DataFormatException("Element '" + theLocalPart + "' is not a resource, expected a resource at this position");
                    }
                }
            }
            RuntimeResourceDefinition def = definition;
            if (!definition.getName().equals(theLocalPart) && definition.getName().equalsIgnoreCase(theLocalPart)) {
                throw new DataFormatException("Unknown resource type '" + theLocalPart + "': Resource names are case sensitive, found similar name: '" + definition.getName() + "'");
            }
            this.myInstance = (IBaseResource)def.newInstance();
            if (this.myInstance instanceof IResource) {
                ParserState.this.push(new ResourceStateHapi(this.getRootPreResourceState(), def, (IResource)this.myInstance));
            } else {
                ParserState.this.push(new ResourceStateHl7Org(this.getRootPreResourceState(), def, this.myInstance));
            }
        }

        public Map<String, IBaseResource> getContainedResources() {
            return this.myContainedResources;
        }

        @Override
        protected IBaseResource getCurrentElement() {
            return this.myInstance;
        }

        private PreResourceState getRootPreResourceState() {
            if (this.getPreResourceState() != null) {
                return this.getPreResourceState();
            }
            return this;
        }

        @Override
        public boolean isPreResource() {
            return true;
        }

        protected abstract void populateTarget();

        private void postProcess() {
            if (ParserState.this.myContext.hasDefaultTypeForProfile()) {
                IBaseMetaType meta = this.myInstance.getMeta();
                Class<? extends IBaseResource> wantedProfileType = null;
                String usedProfile = null;
                for (IPrimitiveType<String> iPrimitiveType : meta.getProfile()) {
                    if (!StringUtils.isNotBlank((CharSequence)iPrimitiveType.getValue()) || (wantedProfileType = ParserState.this.myContext.getDefaultTypeForProfile(iPrimitiveType.getValue())) == null) continue;
                    usedProfile = iPrimitiveType.getValue();
                    break;
                }
                if (wantedProfileType != null && !wantedProfileType.equals(this.myInstance.getClass()) && (this.myResourceType == null || this.myResourceType.isAssignableFrom(wantedProfileType))) {
                    ourLog.debug("Converting resource of type {} to type defined for profile \"{}\": {}", new Object[]{this.myInstance.getClass().getName(), usedProfile, wantedProfileType});
                    IParser parser = ParserState.this.myContext.newJsonParser();
                    String string = parser.encodeResourceToString(this.myInstance);
                    this.myInstance = parser.parseResource(wantedProfileType, string);
                }
            }
            this.populateTarget();
        }

        private void stitchBundleCrossReferences() {
            boolean bundle = "Bundle".equals(ParserState.this.myContext.getResourceDefinition(this.myInstance).getName());
            if (bundle) {
                FhirTerser t = ParserState.this.myContext.newTerser();
                HashMap<String, IBaseResource> idToResource = new HashMap<String, IBaseResource>();
                List<IBase> entries = t.getValues(this.myInstance, "Bundle.entry", IBase.class);
                for (IBase iBase : entries) {
                    IBaseResource resource;
                    IPrimitiveType fullUrl = t.getSingleValueOrNull(iBase, "fullUrl", IPrimitiveType.class);
                    if (fullUrl == null || !StringUtils.isNotBlank((CharSequence)fullUrl.getValueAsString()) || (resource = t.getSingleValueOrNull(iBase, "resource", IBaseResource.class)) == null) continue;
                    idToResource.put(fullUrl.getValueAsString(), resource);
                }
                List<IBaseResource> resources = t.getAllPopulatedChildElementsOfType(this.myInstance, IBaseResource.class);
                for (IBaseResource next : resources) {
                    IIdType id = next.getIdElement();
                    if (id == null || id.isEmpty()) continue;
                    String resName = ParserState.this.myContext.getResourceDefinition(next).getName();
                    IIdType idType = id.withResourceType(resName).toUnqualifiedVersionless();
                    idToResource.put(idType.getValueAsString(), next);
                }
                for (IBaseResource next : resources) {
                    List<IBaseReference> refs = ParserState.this.myContext.newTerser().getAllPopulatedChildElementsOfType(next, IBaseReference.class);
                    for (IBaseReference nextRef : refs) {
                        IIdType unqualifiedVersionless;
                        IBaseResource target;
                        if (nextRef.isEmpty() || nextRef.getReferenceElement() == null || (target = (IBaseResource)idToResource.get((unqualifiedVersionless = nextRef.getReferenceElement().toUnqualifiedVersionless()).getValueAsString())) == null) continue;
                        nextRef.setResource(target);
                    }
                }
                List<Pair<String, IBaseResource>> list = BundleUtil.getBundleEntryUrlsAndResources(ParserState.this.myContext, (IBaseBundle)this.myInstance);
                for (Pair<String, IBaseResource> pair : list) {
                    if (pair.getRight() == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)pair.getLeft())) || !((IBaseResource)pair.getRight()).getIdElement().isEmpty() || !((String)pair.getLeft()).startsWith("urn:")) continue;
                    ((IBaseResource)pair.getRight()).setId((String)pair.getLeft());
                }
            }
        }

        protected void weaveContainedResources() {
            FhirTerser terser = ParserState.this.myContext.newTerser();
            terser.visit(this.myInstance, new IModelVisitor(){

                @Override
                public void acceptElement(IBaseResource theResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                    IBaseReference nextRef;
                    String ref;
                    if (theElement instanceof BaseResourceReferenceDt) {
                        BaseResourceReferenceDt nextRef2 = (BaseResourceReferenceDt)theElement;
                        String ref2 = nextRef2.getReference().getValue();
                        if (StringUtils.isNotBlank((CharSequence)ref2) && ref2.startsWith("#")) {
                            IResource target = (IResource)PreResourceState.this.myContainedResources.get(ref2);
                            if (target != null) {
                                ourLog.debug("Resource contains local ref {} in field {}", (Object)ref2, thePathToElement);
                                nextRef2.setResource(target);
                            } else {
                                ParserState.this.myErrorHandler.unknownReference(null, ref2);
                            }
                        }
                    } else if (theElement instanceof IBaseReference && StringUtils.isNotBlank((CharSequence)(ref = (nextRef = (IBaseReference)theElement).getReferenceElement().getValue())) && ref.startsWith("#")) {
                        IBaseResource target = (IBaseResource)PreResourceState.this.myContainedResources.get(ref);
                        if (target != null) {
                            ourLog.debug("Resource contains local ref {} in field {}", (Object)ref, thePathToElement);
                            nextRef.setResource(target);
                        } else {
                            ParserState.this.myErrorHandler.unknownReference(null, ref);
                        }
                    }
                }
            });
        }

        @Override
        public void wereBack() {
            this.postProcess();
        }
    }

    private class MetaVersionElementState
    extends BaseState {
        private ResourceMetadataMap myMap;

        public MetaVersionElementState(PreResourceState thePreResourceState, ResourceMetadataMap theMap) {
            super(thePreResourceState);
            this.myMap = theMap;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myMap.put(ResourceMetadataKeyEnum.VERSION, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }
    }

    private class MetaElementState
    extends BaseState {
        private ResourceMetadataMap myMap;

        public MetaElementState(PreResourceState thePreResourceState, ResourceMetadataMap theMap) {
            super(thePreResourceState);
            this.myMap = theMap;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (theLocalPart.equals("versionId")) {
                ParserState.this.push(new MetaVersionElementState(this.getPreResourceState(), this.myMap));
            } else if (theLocalPart.equals("lastUpdated")) {
                InstantDt updated = new InstantDt();
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), updated));
                this.myMap.put(ResourceMetadataKeyEnum.UPDATED, updated);
            } else if (theLocalPart.equals("security")) {
                ArrayList<IBase> securityLabels = (ArrayList<IBase>)this.myMap.get(ResourceMetadataKeyEnum.SECURITY_LABELS);
                if (securityLabels == null) {
                    securityLabels = new ArrayList<IBase>();
                    this.myMap.put(ResourceMetadataKeyEnum.SECURITY_LABELS, securityLabels);
                }
                IBase securityLabel = ParserState.this.myContext.getVersion().newCodingDt();
                BaseRuntimeElementCompositeDefinition codinfDef = (BaseRuntimeElementCompositeDefinition)ParserState.this.myContext.getElementDefinition(securityLabel.getClass());
                ParserState.this.push(new SecurityLabelElementStateHapi(this.getPreResourceState(), codinfDef, securityLabel));
                securityLabels.add(securityLabel);
            } else if (theLocalPart.equals("profile")) {
                ArrayList<IdDt> newProfiles;
                List profiles = (List)this.myMap.get(ResourceMetadataKeyEnum.PROFILES);
                if (profiles != null) {
                    newProfiles = new ArrayList(profiles.size() + 1);
                    newProfiles.addAll(profiles);
                } else {
                    newProfiles = new ArrayList<IdDt>(1);
                }
                IdDt profile = new IdDt();
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), profile));
                newProfiles.add(profile);
                this.myMap.put(ResourceMetadataKeyEnum.PROFILES, Collections.unmodifiableList(newProfiles));
            } else if (theLocalPart.equals("tag")) {
                TagList tagList = (TagList)this.myMap.get(ResourceMetadataKeyEnum.TAG_LIST);
                if (tagList == null) {
                    tagList = new TagList();
                    this.myMap.put(ResourceMetadataKeyEnum.TAG_LIST, tagList);
                }
                ParserState.this.push(new TagState(tagList));
            } else {
                ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
        }

        @Override
        public void enteringNewElementExtension(StartElement theElem, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            ExtensionDt newExtension;
            ResourceMetadataKeyEnum.ExtensionResourceMetadataKey resourceMetadataKeyEnum = new ResourceMetadataKeyEnum.ExtensionResourceMetadataKey(theUrlAttr);
            Object metadataValue = this.myMap.get(resourceMetadataKeyEnum);
            if (metadataValue == null) {
                newExtension = new ExtensionDt(theIsModifier);
            } else if (metadataValue instanceof ExtensionDt) {
                newExtension = (ExtensionDt)metadataValue;
            } else {
                throw new IllegalStateException("Expected ExtensionDt as custom resource metadata type, got: " + metadataValue.getClass().getSimpleName());
            }
            newExtension.setUrl(theUrlAttr);
            this.myMap.put(resourceMetadataKeyEnum, newExtension);
            ExtensionState newState = new ExtensionState(this.getPreResourceState(), newExtension);
            ParserState.this.push(newState);
        }
    }

    public class IdentifiableElementIdState
    extends BaseState {
        private IIdentifiableElement myElement;

        public IdentifiableElementIdState(PreResourceState thePreResourceState, IIdentifiableElement theElement) {
            super(thePreResourceState);
            this.myElement = theElement;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myElement.setElementSpecificId(theValue);
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }
    }

    private class ExtensionState
    extends BaseState {
        private IBaseExtension<?, ?> myExtension;

        public ExtensionState(PreResourceState thePreResourceState, IBaseExtension<?, ?> theExtension) {
            super(thePreResourceState);
            this.myExtension = theExtension;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("url".equals(theName)) {
                return;
            }
            if ("id".equals(theName)) {
                if (this.getCurrentElement() instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.getCurrentElement())).setId(theValue);
                    return;
                }
                if (this.getCurrentElement() instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)this.getCurrentElement()).setElementSpecificId(theValue);
                    return;
                }
            }
            super.attributeValue(theName, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.myExtension.getValue() != null && this.myExtension.getExtension().size() > 0) {
                throw new DataFormatException("Extension (URL='" + this.myExtension.getUrl() + "') must not have both a value and other contained extensions");
            }
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            BaseRuntimeElementDefinition<?> target;
            if (theLocalPart.equals("id")) {
                if (this.getCurrentElement() instanceof IBaseElement) {
                    ParserState.this.push(new ElementIdState(this.getPreResourceState(), (IBaseElement)((Object)this.getCurrentElement())));
                    return;
                }
                if (this.getCurrentElement() instanceof IIdentifiableElement) {
                    ParserState.this.push(new IdentifiableElementIdState(this.getPreResourceState(), (IIdentifiableElement)this.getCurrentElement()));
                    return;
                }
            }
            if ((target = ParserState.this.myContext.getRuntimeChildUndeclaredExtensionDefinition().getChildByName(theLocalPart)) != null) {
                switch (target.getChildType()) {
                    case COMPOSITE_DATATYPE: {
                        BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                        ICompositeType newChildInstance = (ICompositeType)compositeTarget.newInstance();
                        this.myExtension.setValue(newChildInstance);
                        ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), theLocalPart, compositeTarget, newChildInstance);
                        ParserState.this.push(newState);
                        return;
                    }
                    case ID_DATATYPE: 
                    case PRIMITIVE_DATATYPE: {
                        RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                        IPrimitiveType newChildInstance = (IPrimitiveType)primitiveTarget.newInstance();
                        this.myExtension.setValue(newChildInstance);
                        PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance);
                        ParserState.this.push(newState);
                        return;
                    }
                }
            }
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        @Override
        protected IBaseExtension<?, ?> getCurrentElement() {
            return this.myExtension;
        }
    }

    public class ElementIdState
    extends BaseState {
        private IBaseElement myElement;

        public ElementIdState(PreResourceState thePreResourceState, IBaseElement theElement) {
            super(thePreResourceState);
            this.myElement = theElement;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myElement.setId(theValue);
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }
    }

    private class ElementCompositeState
    extends BaseState {
        private BaseRuntimeElementCompositeDefinition<?> myDefinition;
        private IBase myInstance;
        private Set<String> myParsedNonRepeatableNames;
        private String myElementName;

        public ElementCompositeState(PreResourceState thePreResourceState, String theElementName, BaseRuntimeElementCompositeDefinition<?> theDef, IBase theInstance) {
            super(thePreResourceState);
            this.myParsedNonRepeatableNames = new HashSet<String>();
            this.myDefinition = theDef;
            this.myInstance = theInstance;
            this.myElementName = theElementName;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("id".equals(theName)) {
                if (this.myInstance instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)this.myInstance).setElementSpecificId(theValue);
                } else if (this.myInstance instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.myInstance)).setId(theValue);
                } else if (this.myInstance instanceof IBaseResource) {
                    new IdDt(theValue).applyTo((IBaseResource)this.myInstance);
                }
            } else if ("url".equals(theName) && this.myInstance instanceof ExtensionDt) {
                ((ExtensionDt)this.myInstance).setUrl(theValue);
            } else if (ParserState.this.myJsonMode) {
                ParserState.this.myErrorHandler.incorrectJsonType(null, this.myElementName, JsonLikeValue.ValueType.OBJECT, null, JsonLikeValue.ValueType.SCALAR, JsonLikeValue.ScalarType.STRING);
            } else {
                ParserState.this.myErrorHandler.unknownAttribute(null, theName);
            }
        }

        @Override
        public boolean elementIsRepeating(String theChildName) {
            BaseRuntimeChildDefinition child = this.myDefinition.getChildByName(theChildName);
            if (child == null) {
                return false;
            }
            return child.getMax() > 1 || child.getMax() == -1;
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespace, String theChildName) throws DataFormatException {
            BaseRuntimeChildDefinition child = this.myDefinition.getChildByName(theChildName);
            if (child == null) {
                if (theChildName.equals("id") && this.getCurrentElement() instanceof IIdentifiableElement) {
                    ParserState.this.push(new IdentifiableElementIdState(this.getPreResourceState(), (IIdentifiableElement)this.getCurrentElement()));
                    return;
                }
                ParserState.this.myErrorHandler.unknownElement(null, theChildName);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            if (!(child.getMax() != 0 && child.getMax() != 1 || this.myParsedNonRepeatableNames.add(theChildName))) {
                ParserState.this.myErrorHandler.unexpectedRepeatingElement(null, theChildName);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            BaseRuntimeElementDefinition<?> target = child.getChildByName(theChildName);
            if (target == null) {
                throw new DataFormatException("Found unexpected element '" + theChildName + "' in parent element '" + this.myDefinition.getName() + "'. Valid names are: " + child.getValidChildNames());
            }
            switch (target.getChildType()) {
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                    ICompositeType newChildInstance = (ICompositeType)compositeTarget.newInstance(child.getInstanceConstructorArguments());
                    child.getMutator().addValue(this.myInstance, newChildInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), theChildName, compositeTarget, newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case ID_DATATYPE: 
                case PRIMITIVE_DATATYPE: {
                    RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                    IPrimitiveType newChildInstance = (IPrimitiveType)primitiveTarget.newInstance(child.getInstanceConstructorArguments());
                    child.getMutator().addValue(this.myInstance, newChildInstance);
                    PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case RESOURCE_BLOCK: {
                    RuntimeResourceBlockDefinition blockTarget = (RuntimeResourceBlockDefinition)target;
                    Object newBlockInstance = blockTarget.newInstance();
                    child.getMutator().addValue(this.myInstance, (IBase)newBlockInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), theChildName, blockTarget, (IBase)newBlockInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case PRIMITIVE_XHTML: {
                    RuntimePrimitiveDatatypeNarrativeDefinition xhtmlTarget = (RuntimePrimitiveDatatypeNarrativeDefinition)target;
                    XhtmlDt newDt = (XhtmlDt)xhtmlTarget.newInstance();
                    child.getMutator().addValue(this.myInstance, newDt);
                    XhtmlState state = new XhtmlState(this.getPreResourceState(), newDt, true);
                    ParserState.this.push(state);
                    return;
                }
                case PRIMITIVE_XHTML_HL7ORG: {
                    RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition xhtmlTarget = (RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition)target;
                    IBaseXhtml newDt = (IBaseXhtml)xhtmlTarget.newInstance();
                    child.getMutator().addValue(this.myInstance, newDt);
                    XhtmlStateHl7Org state = new XhtmlStateHl7Org(this.getPreResourceState(), newDt);
                    ParserState.this.push(state);
                    return;
                }
                case CONTAINED_RESOURCES: {
                    List<IBase> values = child.getAccessor().getValues(this.myInstance);
                    if (values == null || values.isEmpty() || values.get(0) == null) {
                        Object newDt = ParserState.this.newContainedDt((IResource)this.getPreResourceState().myInstance);
                        child.getMutator().addValue(this.myInstance, (IBase)newDt);
                    } else {
                        IBase newDt = values.get(0);
                    }
                    ContainedResourcesStateHapi state = new ContainedResourcesStateHapi(this.getPreResourceState());
                    ParserState.this.push(state);
                    return;
                }
                case CONTAINED_RESOURCE_LIST: {
                    ContainedResourcesStateHl7Org state = new ContainedResourcesStateHl7Org(this.getPreResourceState());
                    ParserState.this.push(state);
                    return;
                }
                case RESOURCE: {
                    if (this.myInstance instanceof IAnyResource || this.myInstance instanceof IBaseBackboneElement || this.myInstance instanceof IBaseElement) {
                        PreResourceStateHl7Org state = new PreResourceStateHl7Org(this.myInstance, child.getMutator(), null);
                        ParserState.this.push(state);
                    } else {
                        PreResourceStateHapi state = new PreResourceStateHapi(this.myInstance, child.getMutator(), null);
                        ParserState.this.push(state);
                    }
                    return;
                }
            }
            throw new DataFormatException("Illegal resource position: " + (Object)((Object)target.getChildType()));
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            RuntimeChildDeclaredExtensionDefinition declaredExtension = this.myDefinition.getDeclaredExtension(theUrlAttr, baseServerUrl);
            if (declaredExtension != null) {
                DeclaredExtensionState newState = new DeclaredExtensionState(this.getPreResourceState(), declaredExtension, this.myInstance);
                ParserState.this.push(newState);
            } else {
                super.enteringNewElementExtension(theElement, theUrlAttr, theIsModifier, baseServerUrl);
            }
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myInstance;
        }
    }

    private class DeclaredExtensionState
    extends BaseState {
        private IBase myChildInstance;
        private RuntimeChildDeclaredExtensionDefinition myDefinition;
        private IBase myParentInstance;
        private PreResourceState myPreResourceState;

        public DeclaredExtensionState(PreResourceState thePreResourceState, RuntimeChildDeclaredExtensionDefinition theDefinition, IBase theParentInstance) {
            super(thePreResourceState);
            this.myPreResourceState = thePreResourceState;
            this.myDefinition = theDefinition;
            this.myParentInstance = theParentInstance;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (theName.equals("url")) {
                return;
            }
            super.attributeValue(theName, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            BaseRuntimeElementDefinition<?> target = this.myDefinition.getChildByName(theLocalPart);
            if (target == null) {
                ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            switch (target.getChildType()) {
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                    ICompositeType newChildInstance = (ICompositeType)compositeTarget.newInstance(this.myDefinition.getInstanceConstructorArguments());
                    this.myDefinition.getMutator().addValue(this.myParentInstance, newChildInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.myPreResourceState, theLocalPart, compositeTarget, newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case ID_DATATYPE: 
                case PRIMITIVE_DATATYPE: {
                    RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                    IPrimitiveType newChildInstance = (IPrimitiveType)primitiveTarget.newInstance(this.myDefinition.getInstanceConstructorArguments());
                    this.myDefinition.getMutator().addValue(this.myParentInstance, newChildInstance);
                    PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
            }
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            RuntimeChildDeclaredExtensionDefinition declaredExtension = this.myDefinition.getChildExtensionForUrl(theUrlAttr);
            if (declaredExtension != null) {
                if (this.myChildInstance == null) {
                    this.myChildInstance = this.myDefinition.newInstance();
                    this.myDefinition.getMutator().addValue(this.myParentInstance, this.myChildInstance);
                }
                DeclaredExtensionState newState = new DeclaredExtensionState(this.getPreResourceState(), declaredExtension, this.myChildInstance);
                ParserState.this.push(newState);
            } else {
                super.enteringNewElementExtension(theElement, theUrlAttr, theIsModifier, baseServerUrl);
            }
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myParentInstance;
        }
    }

    private class ContainedResourcesStateHl7Org
    extends PreResourceState {
        public ContainedResourcesStateHl7Org(PreResourceState thePreResourcesState) {
            super(thePreResourcesState, thePreResourcesState.myParentVersion);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        protected void populateTarget() {
        }

        @Override
        public void wereBack() {
            super.wereBack();
            IBaseResource res = this.getCurrentElement();
            assert (res != null);
            if (res.getIdElement() == null || res.getIdElement().isEmpty()) {
                ParserState.this.myErrorHandler.containedResourceWithNoId(null);
            } else {
                res.getIdElement().setValue('#' + res.getIdElement().getIdPart());
                this.getPreResourceState().getContainedResources().put(res.getIdElement().getValue(), res);
            }
            IBaseResource preResCurrentElement = this.getPreResourceState().getCurrentElement();
            RuntimeResourceDefinition def = ParserState.this.myContext.getResourceDefinition(preResCurrentElement);
            def.getChildByName("contained").getMutator().addValue(preResCurrentElement, res);
        }
    }

    private class ContainedResourcesStateHapi
    extends PreResourceState {
        public ContainedResourcesStateHapi(PreResourceState thePreResourcesState) {
            super(thePreResourcesState, ((IResource)thePreResourcesState.myInstance).getStructureFhirVersionEnum());
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        protected void populateTarget() {
        }

        @Override
        public void wereBack() {
            super.wereBack();
            IResource res = (IResource)this.getCurrentElement();
            assert (res != null);
            if (res.getId() == null || res.getId().isEmpty()) {
                ParserState.this.myErrorHandler.containedResourceWithNoId(null);
            } else {
                if (!res.getId().isLocal()) {
                    res.setId(new IdDt('#' + res.getId().getIdPart()));
                }
                this.getPreResourceState().getContainedResources().put(res.getId().getValueAsString(), res);
            }
            IResource preResCurrentElement = (IResource)this.getPreResourceState().getCurrentElement();
            List<? extends IResource> containedResources = preResCurrentElement.getContained().getContainedResources();
            containedResources.add(res);
        }
    }

    private abstract class BaseState {
        private PreResourceState myPreResourceState;
        private BaseState myStack;

        public BaseState(PreResourceState thePreResourceState) {
            this.myPreResourceState = thePreResourceState;
        }

        public void attributeValue(String theName, String theValue) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownAttribute(null, theName);
        }

        public boolean elementIsRepeating(String theChildName) {
            return false;
        }

        public void endingElement() throws DataFormatException {
        }

        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
        }

        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            if (this.myPreResourceState != null && this.getCurrentElement() instanceof ISupportsUndeclaredExtensions) {
                ExtensionDt newExtension = new ExtensionDt(theIsModifier);
                newExtension.setUrl(theUrlAttr);
                ISupportsUndeclaredExtensions elem = (ISupportsUndeclaredExtensions)this.getCurrentElement();
                elem.addUndeclaredExtension(newExtension);
                ExtensionState newState = new ExtensionState(this.myPreResourceState, newExtension);
                ParserState.this.push(newState);
            } else if (!theIsModifier) {
                if (this.getCurrentElement() instanceof IBaseHasExtensions) {
                    IBaseExtension<?, ?> ext = ((IBaseHasExtensions)((Object)this.getCurrentElement())).addExtension();
                    ext.setUrl(theUrlAttr);
                    ExtensionState newState = new ExtensionState(this.myPreResourceState, ext);
                    ParserState.this.push(newState);
                } else {
                    this.logAndSwallowUnexpectedElement("extension");
                }
            } else if (this.getCurrentElement() instanceof IBaseHasModifierExtensions) {
                IBaseExtension<?, ?> ext = ((IBaseHasModifierExtensions)((Object)this.getCurrentElement())).addModifierExtension();
                ext.setUrl(theUrlAttr);
                ExtensionState newState = new ExtensionState(this.myPreResourceState, ext);
                ParserState.this.push(newState);
            } else {
                this.logAndSwallowUnexpectedElement("modifierExtension");
            }
        }

        protected IBase getCurrentElement() {
            return null;
        }

        public PreResourceState getPreResourceState() {
            return this.myPreResourceState;
        }

        public boolean isPreResource() {
            return false;
        }

        protected void logAndSwallowUnexpectedElement(String theLocalPart) {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        public void setStack(BaseState theState) {
            this.myStack = theState;
        }

        public void string(String theData) {
        }

        public void wereBack() {
        }

        public void xmlEvent(XMLEvent theNextEvent) {
        }
    }
}

