/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(UrlUtil.class);
    private static final String URL_FORM_PARAMETER_OTHER_SAFE_CHARS = "-_.*";
    private static final Escaper PARAMETER_ESCAPER = new PercentEscaper("-_.*", false);

    public static String constructAbsoluteUrl(String theBase, String theEndpoint) {
        if (theEndpoint == null) {
            return null;
        }
        if (UrlUtil.isAbsolute(theEndpoint)) {
            return theEndpoint;
        }
        if (theBase == null) {
            return theEndpoint;
        }
        try {
            return new URL(new URL(theBase), theEndpoint).toString();
        }
        catch (MalformedURLException e) {
            ourLog.warn("Failed to resolve relative URL[" + theEndpoint + "] against absolute base[" + theBase + "]", (Throwable)e);
            return theEndpoint;
        }
    }

    public static String constructRelativeUrl(String theParentExtensionUrl, String theExtensionUrl) {
        if (theParentExtensionUrl == null) {
            return theExtensionUrl;
        }
        if (theExtensionUrl == null) {
            return null;
        }
        int parentLastSlashIdx = theParentExtensionUrl.lastIndexOf(47);
        int childLastSlashIdx = theExtensionUrl.lastIndexOf(47);
        if (parentLastSlashIdx == -1 || childLastSlashIdx == -1) {
            return theExtensionUrl;
        }
        if (parentLastSlashIdx != childLastSlashIdx) {
            return theExtensionUrl;
        }
        if (!theParentExtensionUrl.substring(0, parentLastSlashIdx).equals(theExtensionUrl.substring(0, parentLastSlashIdx))) {
            return theExtensionUrl;
        }
        if (theExtensionUrl.length() > parentLastSlashIdx) {
            return theExtensionUrl.substring(parentLastSlashIdx + 1);
        }
        return theExtensionUrl;
    }

    public static String escapeUrlParam(String theUnescaped) {
        if (theUnescaped == null) {
            return null;
        }
        return PARAMETER_ESCAPER.escape(theUnescaped);
    }

    public static boolean isAbsolute(String theValue) {
        String value = theValue.toLowerCase();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    public static boolean isNeedsSanitization(String theString) {
        if (theString != null) {
            for (int i = 0; i < theString.length(); ++i) {
                char nextChar = theString.charAt(i);
                if (nextChar != '<' && nextChar != '\"') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValid(String theUrl) {
        int slashOffset;
        if (theUrl == null || theUrl.length() < 8) {
            return false;
        }
        String url = theUrl.toLowerCase();
        if (url.charAt(0) != 'h') {
            return false;
        }
        if (url.charAt(1) != 't') {
            return false;
        }
        if (url.charAt(2) != 't') {
            return false;
        }
        if (url.charAt(3) != 'p') {
            return false;
        }
        if (url.charAt(4) == ':') {
            slashOffset = 5;
        } else if (url.charAt(4) == 's') {
            if (url.charAt(5) != ':') {
                return false;
            }
            slashOffset = 6;
        } else {
            return false;
        }
        if (url.charAt(slashOffset) != '/') {
            return false;
        }
        return url.charAt(slashOffset + 1) == '/';
    }

    public static void main(String[] args) {
        System.out.println(UrlUtil.escapeUrlParam("http://snomed.info/sct?fhir_vs=isa/126851005"));
    }

    public static Map<String, String[]> parseQueryString(String theQueryString) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        UrlUtil.parseQueryString(theQueryString, map);
        return UrlUtil.toQueryStringMap(map);
    }

    private static void parseQueryString(String theQueryString, HashMap<String, List<String>> map) {
        String query = StringUtils.defaultString((String)theQueryString);
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        StringTokenizer tok = new StringTokenizer(query, "&");
        while (tok.hasMoreTokens()) {
            String nextValue;
            String nextKey;
            String nextToken = tok.nextToken();
            if (StringUtils.isBlank((CharSequence)nextToken)) continue;
            int equalsIndex = nextToken.indexOf(61);
            if (equalsIndex == -1) {
                nextKey = nextToken;
                nextValue = "";
            } else {
                nextKey = nextToken.substring(0, equalsIndex);
                nextValue = nextToken.substring(equalsIndex + 1);
            }
            nextKey = UrlUtil.unescape(nextKey);
            nextValue = UrlUtil.unescape(nextValue);
            List list = map.computeIfAbsent(nextKey, k -> new ArrayList());
            list.add(nextValue);
        }
    }

    public static Map<String, String[]> parseQueryStrings(String ... theQueryString) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String next : theQueryString) {
            UrlUtil.parseQueryString(next, map);
        }
        return UrlUtil.toQueryStringMap(map);
    }

    public static UrlParts parseUrl(String theUrl) {
        String url = theUrl;
        UrlParts retVal = new UrlParts();
        if (url.startsWith("http")) {
            int qmIdx;
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            if ((qmIdx = url.indexOf(63)) != -1) {
                retVal.setParams((String)StringUtils.defaultIfBlank((CharSequence)url.substring(qmIdx + 1), null));
                url = url.substring(0, qmIdx);
            }
            IdDt id = new IdDt(url);
            retVal.setResourceType(id.getResourceType());
            retVal.setResourceId(id.getIdPart());
            retVal.setVersionId(id.getVersionIdPart());
            return retVal;
        }
        if (url.matches("/[a-zA-Z]+\\?.*")) {
            url = url.substring(1);
        }
        int nextStart = 0;
        boolean nextIsHistory = false;
        for (int idx = 0; idx < url.length(); ++idx) {
            boolean atEnd;
            char nextChar = url.charAt(idx);
            boolean bl = atEnd = idx + 1 == url.length();
            if (nextChar != '?' && nextChar != '/' && !atEnd) continue;
            int endIdx = atEnd && nextChar != '?' ? idx + 1 : idx;
            String nextSubstring = url.substring(nextStart, endIdx);
            if (retVal.getResourceType() == null) {
                retVal.setResourceType(nextSubstring);
            } else if (retVal.getResourceId() == null) {
                retVal.setResourceId(nextSubstring);
            } else if (nextIsHistory) {
                retVal.setVersionId(nextSubstring);
            } else if (nextSubstring.equals("_history")) {
                nextIsHistory = true;
            } else {
                throw new InvalidRequestException("Invalid FHIR resource URL: " + url);
            }
            if (nextChar == '?') {
                if (url.length() <= idx + 1) break;
                retVal.setParams(url.substring(idx + 1, url.length()));
                break;
            }
            nextStart = idx + 1;
        }
        return retVal;
    }

    public static String sanitizeUrlPart(String theString) {
        if (theString == null) {
            return null;
        }
        boolean needsSanitization = UrlUtil.isNeedsSanitization(theString);
        if (needsSanitization) {
            StringBuilder buffer = new StringBuilder(theString.length() + 10);
            block4: for (int j = 0; j < theString.length(); ++j) {
                char nextChar = theString.charAt(j);
                switch (nextChar) {
                    case '\"': {
                        buffer.append("&quot;");
                        continue block4;
                    }
                    case '<': {
                        buffer.append("&lt;");
                        continue block4;
                    }
                    default: {
                        buffer.append(nextChar);
                    }
                }
            }
            return buffer.toString();
        }
        return theString;
    }

    private static Map<String, String[]> toQueryStringMap(HashMap<String, List<String>> map) {
        HashMap<String, String[]> retVal = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> nextEntry : map.entrySet()) {
            retVal.put(nextEntry.getKey(), nextEntry.getValue().toArray(new String[0]));
        }
        return retVal;
    }

    public static String unescape(String theString) {
        if (theString == null) {
            return null;
        }
        for (int i = 0; i < theString.length(); ++i) {
            char nextChar = theString.charAt(i);
            if (nextChar != '%' && nextChar != '+') continue;
            try {
                return URLDecoder.decode(theString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("UTF-8 not supported, this shouldn't happen", e);
            }
        }
        return theString;
    }

    public static class UrlParts {
        private String myParams;
        private String myResourceId;
        private String myResourceType;
        private String myVersionId;

        public String getParams() {
            return this.myParams;
        }

        public void setParams(String theParams) {
            this.myParams = theParams;
        }

        public String getResourceId() {
            return this.myResourceId;
        }

        public void setResourceId(String theResourceId) {
            this.myResourceId = theResourceId;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public void setResourceType(String theResourceType) {
            this.myResourceType = theResourceType;
        }

        public String getVersionId() {
            return this.myVersionId;
        }

        public void setVersionId(String theVersionId) {
            this.myVersionId = theVersionId;
        }
    }
}

