/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.narrative.DefaultThymeleafNarrativeGenerator;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.INarrative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.DefaultTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public abstract class BaseThymeleafNarrativeGenerator
implements INarrativeGenerator {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseThymeleafNarrativeGenerator.class);
    private boolean myApplyDefaultDatatypeTemplates = true;
    private HashMap<Class<?>, String> myClassToName;
    private boolean myCleanWhitespace = true;
    private boolean myIgnoreFailures = true;
    private boolean myIgnoreMissingTemplates = true;
    private volatile boolean myInitialized;
    private HashMap<String, String> myNameToNarrativeTemplate;
    private TemplateEngine myProfileTemplateEngine;
    private IMessageResolver resolver;

    @Override
    public void generateNarrative(FhirContext theContext, IBaseResource theResource, INarrative theNarrative) {
        String name;
        if (!this.myInitialized) {
            this.initialize(theContext);
        }
        if ((name = this.myClassToName.get(theResource.getClass())) == null) {
            name = theContext.getResourceDefinition(theResource).getName().toLowerCase();
        }
        if (name == null || !this.myNameToNarrativeTemplate.containsKey(name)) {
            if (this.myIgnoreMissingTemplates) {
                ourLog.debug("No narrative template available for resorce: {}", (Object)name);
                return;
            }
            throw new DataFormatException("No narrative template for class " + theResource.getClass().getCanonicalName());
        }
        try {
            Context context = new Context();
            context.setVariable("resource", (Object)theResource);
            context.setVariable("fhirVersion", (Object)theContext.getVersion().getVersion().name());
            String result = this.myProfileTemplateEngine.process(name, (IContext)context);
            if (this.myCleanWhitespace) {
                ourLog.trace("Pre-whitespace cleaning: ", (Object)result);
                result = BaseThymeleafNarrativeGenerator.cleanWhitespace(result);
                ourLog.trace("Post-whitespace cleaning: ", (Object)result);
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                return;
            }
            theNarrative.setDivAsString(result);
            theNarrative.setStatusAsString("generated");
            return;
        }
        catch (Exception e) {
            if (this.myIgnoreFailures) {
                ourLog.error("Failed to generate narrative", (Throwable)e);
                try {
                    theNarrative.setDivAsString("<div>No narrative available - Error: " + e.getMessage() + "</div>");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                theNarrative.setStatusAsString("empty");
                return;
            }
            throw new DataFormatException(e);
        }
    }

    protected abstract List<String> getPropertyFile();

    private synchronized void initialize(final FhirContext theContext) {
        if (this.myInitialized) {
            return;
        }
        ourLog.info("Initializing narrative generator");
        this.myClassToName = new HashMap();
        this.myNameToNarrativeTemplate = new HashMap();
        List<String> propFileName = this.getPropertyFile();
        try {
            if (this.myApplyDefaultDatatypeTemplates) {
                this.loadProperties("classpath:ca/uhn/fhir/narrative/narratives.properties");
            }
            for (String next : propFileName) {
                this.loadProperties(next);
            }
        }
        catch (IOException e) {
            ourLog.info("Failed to load property file " + propFileName, (Throwable)e);
            throw new ConfigurationException("Can not load property file " + propFileName, e);
        }
        this.myProfileTemplateEngine = new TemplateEngine();
        ProfileResourceResolver resolver = new ProfileResourceResolver();
        this.myProfileTemplateEngine.setTemplateResolver((ITemplateResolver)resolver);
        StandardDialect dialect = new StandardDialect(){

            public Set<IProcessor> getProcessors(String theDialectPrefix) {
                Set retVal = super.getProcessors(theDialectPrefix);
                retVal.add(new NarrativeAttributeProcessor(theContext, theDialectPrefix));
                return retVal;
            }
        };
        this.myProfileTemplateEngine.setDialect((IDialect)dialect);
        if (this.resolver != null) {
            this.myProfileTemplateEngine.setMessageResolver(this.resolver);
        }
        this.myInitialized = true;
    }

    public void setMessageResolver(IMessageResolver resolver) {
        this.resolver = resolver;
        if (this.myProfileTemplateEngine != null && resolver != null) {
            this.myProfileTemplateEngine.setMessageResolver(resolver);
        }
    }

    public boolean isCleanWhitespace() {
        return this.myCleanWhitespace;
    }

    public boolean isIgnoreFailures() {
        return this.myIgnoreFailures;
    }

    public boolean isIgnoreMissingTemplates() {
        return this.myIgnoreMissingTemplates;
    }

    private void loadProperties(String propFileName) throws IOException {
        ourLog.debug("Loading narrative properties file: {}", (Object)propFileName);
        Properties file = new Properties();
        InputStream resource = this.loadResource(propFileName);
        file.load(resource);
        for (Object nextKeyObj : file.keySet()) {
            String narrative;
            String narrativeName;
            String narrativePropName;
            String name;
            String nextKey = (String)nextKeyObj;
            if (nextKey.endsWith(".profile")) {
                name = nextKey.substring(0, nextKey.indexOf(".profile"));
                if (StringUtils.isBlank((CharSequence)name)) continue;
                narrativePropName = name + ".narrative";
                narrativeName = file.getProperty(narrativePropName);
                if (StringUtils.isBlank((CharSequence)narrativeName)) {
                    throw new ConfigurationException("Found property '" + nextKey + "' but no corresponding property '" + narrativePropName + "' in file " + propFileName);
                }
                if (!StringUtils.isNotBlank((CharSequence)narrativeName)) continue;
                narrative = IOUtils.toString((InputStream)this.loadResource(narrativeName), (Charset)Constants.CHARSET_UTF8);
                this.myNameToNarrativeTemplate.put(name, narrative);
                continue;
            }
            if (nextKey.endsWith(".class")) {
                Class<?> clazz;
                name = nextKey.substring(0, nextKey.indexOf(".class"));
                if (StringUtils.isBlank((CharSequence)name)) continue;
                String className = file.getProperty(nextKey);
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    ourLog.debug("Unknown datatype class '{}' identified in narrative file {}", (Object)name, (Object)propFileName);
                    clazz = null;
                }
                if (clazz == null) continue;
                this.myClassToName.put(clazz, name);
                continue;
            }
            if (nextKey.endsWith(".narrative")) {
                name = nextKey.substring(0, nextKey.indexOf(".narrative"));
                if (StringUtils.isBlank((CharSequence)name) || !StringUtils.isNotBlank((CharSequence)(narrativeName = file.getProperty(narrativePropName = name + ".narrative")))) continue;
                narrative = IOUtils.toString((InputStream)this.loadResource(narrativeName), (Charset)Constants.CHARSET_UTF8);
                this.myNameToNarrativeTemplate.put(name, narrative);
                continue;
            }
            if (nextKey.endsWith(".title")) {
                ourLog.debug("Ignoring title property as narrative generator no longer generates titles: {}", (Object)nextKey);
                continue;
            }
            throw new ConfigurationException("Invalid property name: " + nextKey);
        }
    }

    private InputStream loadResource(String name) throws IOException {
        if (name.startsWith("classpath:")) {
            String cpName = name.substring("classpath:".length());
            InputStream resource = DefaultThymeleafNarrativeGenerator.class.getResourceAsStream(cpName);
            if (resource == null && (resource = DefaultThymeleafNarrativeGenerator.class.getResourceAsStream("/" + cpName)) == null) {
                throw new IOException("Can not find '" + cpName + "' on classpath");
            }
            return resource;
        }
        if (name.startsWith("file:")) {
            File file = new File(name.substring("file:".length()));
            if (!file.exists()) {
                throw new IOException("File not found: " + file.getAbsolutePath());
            }
            return new FileInputStream(file);
        }
        throw new IOException("Invalid resource name: '" + name + "' (must start with classpath: or file: )");
    }

    public void setCleanWhitespace(boolean theCleanWhitespace) {
        this.myCleanWhitespace = theCleanWhitespace;
    }

    public void setIgnoreFailures(boolean theIgnoreFailures) {
        this.myIgnoreFailures = theIgnoreFailures;
    }

    public void setIgnoreMissingTemplates(boolean theIgnoreMissingTemplates) {
        this.myIgnoreMissingTemplates = theIgnoreMissingTemplates;
    }

    static String cleanWhitespace(String theResult) {
        StringBuilder b = new StringBuilder();
        boolean inWhitespace = false;
        boolean betweenTags = false;
        boolean lastNonWhitespaceCharWasTagEnd = false;
        boolean inPre = false;
        for (int i = 0; i < theResult.length(); ++i) {
            char nextChar = theResult.charAt(i);
            if (inPre) {
                b.append(nextChar);
                continue;
            }
            if (nextChar == '>') {
                b.append(nextChar);
                betweenTags = true;
                lastNonWhitespaceCharWasTagEnd = true;
                continue;
            }
            if (nextChar == '\n' || nextChar == '\r') continue;
            if (betweenTags) {
                if (Character.isWhitespace(nextChar)) {
                    inWhitespace = true;
                    continue;
                }
                if (nextChar == '<') {
                    if (inWhitespace && !lastNonWhitespaceCharWasTagEnd) {
                        b.append(' ');
                    }
                    inWhitespace = false;
                    b.append(nextChar);
                    inWhitespace = false;
                    betweenTags = false;
                    lastNonWhitespaceCharWasTagEnd = false;
                    if (i + 3 >= theResult.length()) continue;
                    char char1 = Character.toLowerCase(theResult.charAt(i + 1));
                    char char2 = Character.toLowerCase(theResult.charAt(i + 2));
                    char char3 = Character.toLowerCase(theResult.charAt(i + 3));
                    char char4 = Character.toLowerCase(i + 4 < theResult.length() ? theResult.charAt(i + 4) : (char)' ');
                    if (char1 == 'p' && char2 == 'r' && char3 == 'e') {
                        inPre = true;
                        continue;
                    }
                    if (char1 != '/' || char2 != 'p' || char3 != 'r' || char4 != 'e') continue;
                    inPre = false;
                    continue;
                }
                lastNonWhitespaceCharWasTagEnd = false;
                if (inWhitespace) {
                    b.append(' ');
                    inWhitespace = false;
                }
                b.append(nextChar);
                continue;
            }
            b.append(nextChar);
        }
        return b.toString();
    }

    private final class ProfileResourceResolver
    extends DefaultTemplateResolver {
        private ProfileResourceResolver() {
        }

        protected boolean computeResolvable(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            String template = (String)BaseThymeleafNarrativeGenerator.this.myNameToNarrativeTemplate.get(theTemplate);
            return template != null;
        }

        protected TemplateMode computeTemplateMode(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            return TemplateMode.XML;
        }

        protected ITemplateResource computeTemplateResource(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            String template = (String)BaseThymeleafNarrativeGenerator.this.myNameToNarrativeTemplate.get(theTemplate);
            return new StringTemplateResource(template);
        }

        protected ICacheEntryValidity computeValidity(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            return AlwaysValidCacheEntryValidity.INSTANCE;
        }
    }

    public class NarrativeAttributeProcessor
    extends AbstractAttributeTagProcessor {
        private FhirContext myContext;

        protected NarrativeAttributeProcessor(FhirContext theContext, String theDialectPrefix) {
            super(TemplateMode.XML, theDialectPrefix, null, false, "narrative", true, 0, true);
            this.myContext = theContext;
        }

        protected void doProcess(ITemplateContext theContext, IProcessableElementTag theTag, AttributeName theAttributeName, String theAttributeValue, IElementTagStructureHandler theStructureHandler) {
            IEngineConfiguration configuration = theContext.getConfiguration();
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)theContext, theAttributeValue);
            Object value = expression.execute((IExpressionContext)theContext);
            if (value == null) {
                return;
            }
            Context context = new Context();
            context.setVariable("fhirVersion", (Object)this.myContext.getVersion().getVersion().name());
            context.setVariable("resource", value);
            String name = null;
            Class<?> nextClass = value.getClass();
            do {
                name = (String)BaseThymeleafNarrativeGenerator.this.myClassToName.get(nextClass);
                nextClass = nextClass.getSuperclass();
            } while (name == null && !nextClass.equals(Object.class));
            if (name == null) {
                if (value instanceof IBaseResource) {
                    name = this.myContext.getResourceDefinition((Class)value).getName();
                } else if (value instanceof IDatatype) {
                    name = value.getClass().getSimpleName();
                    name = name.substring(0, name.length() - 2);
                } else if (value instanceof IBaseDatatype) {
                    name = value.getClass().getSimpleName();
                    if (name.endsWith("Type")) {
                        name = name.substring(0, name.length() - 4);
                    }
                } else {
                    throw new DataFormatException("Don't know how to determine name for type: " + value.getClass());
                }
                name = name.toLowerCase();
                if (!BaseThymeleafNarrativeGenerator.this.myNameToNarrativeTemplate.containsKey(name)) {
                    name = null;
                }
            }
            if (name == null) {
                if (BaseThymeleafNarrativeGenerator.this.myIgnoreMissingTemplates) {
                    ourLog.debug("No narrative template available for type: {}", value.getClass());
                    return;
                }
                throw new DataFormatException("No narrative template for class " + value.getClass());
            }
            String result = BaseThymeleafNarrativeGenerator.this.myProfileTemplateEngine.process(name, (IContext)context);
            String trim = result.trim();
            theStructureHandler.setBody((CharSequence)trim, true);
        }
    }
}

