/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.json;

import ca.uhn.fhir.parser.json.JsonLikeWriter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonWriter
extends JsonLikeWriter {
    private static final Logger log = LoggerFactory.getLogger(GsonWriter.class);
    private JsonWriter eventWriter;
    private BlockType blockType = BlockType.NONE;
    private Stack<BlockType> blockStack = new Stack();

    public GsonWriter() {
    }

    public GsonWriter(Writer writer) {
        this.setWriter(writer);
    }

    @Override
    public JsonLikeWriter init() throws IOException {
        this.eventWriter = new JsonWriter(this.getWriter());
        this.eventWriter.setSerializeNulls(true);
        if (this.isPrettyPrint()) {
            this.eventWriter.setIndent("  ");
        }
        this.blockType = BlockType.NONE;
        this.blockStack.clear();
        return this;
    }

    @Override
    public JsonLikeWriter flush() throws IOException {
        if (this.blockType != BlockType.NONE) {
            log.error("JsonLikeStreamWriter.flush() called but JSON document is not finished");
        }
        this.eventWriter.flush();
        this.getWriter().flush();
        return this;
    }

    @Override
    public void close() throws IOException {
        this.eventWriter.close();
        this.getWriter().close();
    }

    @Override
    public JsonLikeWriter beginObject() throws IOException {
        this.blockStack.push(this.blockType);
        this.blockType = BlockType.OBJECT;
        this.eventWriter.beginObject();
        return this;
    }

    @Override
    public JsonLikeWriter beginArray() throws IOException {
        this.blockStack.push(this.blockType);
        this.blockType = BlockType.ARRAY;
        this.eventWriter.beginArray();
        return this;
    }

    @Override
    public JsonLikeWriter beginObject(String name) throws IOException {
        this.blockStack.push(this.blockType);
        this.blockType = BlockType.OBJECT;
        this.eventWriter.name(name);
        this.eventWriter.beginObject();
        return this;
    }

    @Override
    public JsonLikeWriter beginArray(String name) throws IOException {
        this.blockStack.push(this.blockType);
        this.blockType = BlockType.ARRAY;
        this.eventWriter.name(name);
        this.eventWriter.beginArray();
        return this;
    }

    @Override
    public JsonLikeWriter write(String value) throws IOException {
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(BigInteger value) throws IOException {
        this.eventWriter.value((Number)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(BigDecimal value) throws IOException {
        this.eventWriter.value((Number)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(long value) throws IOException {
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(double value) throws IOException {
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(Boolean value) throws IOException {
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(boolean value) throws IOException {
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter writeNull() throws IOException {
        this.eventWriter.nullValue();
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, String value) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, BigInteger value) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.value((Number)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, BigDecimal value) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.value((Number)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, long value) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, double value) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, Boolean value) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, boolean value) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.value(value);
        return this;
    }

    @Override
    public JsonLikeWriter writeNull(String name) throws IOException {
        this.eventWriter.name(name);
        this.eventWriter.nullValue();
        return this;
    }

    @Override
    public JsonLikeWriter endObject() throws IOException {
        if (this.blockType == BlockType.NONE) {
            log.error("JsonLikeStreamWriter.endObject(); called with no active JSON document");
        } else {
            if (this.blockType != BlockType.OBJECT) {
                log.error("JsonLikeStreamWriter.endObject(); called outside a JSON object. (Use endArray() instead?)");
                this.eventWriter.endArray();
            } else {
                this.eventWriter.endObject();
            }
            this.blockType = this.blockStack.pop();
        }
        return this;
    }

    @Override
    public JsonLikeWriter endArray() throws IOException {
        if (this.blockType == BlockType.NONE) {
            log.error("JsonLikeStreamWriter.endArray(); called with no active JSON document");
        } else {
            if (this.blockType != BlockType.ARRAY) {
                log.error("JsonLikeStreamWriter.endArray(); called outside a JSON array. (Use endObject() instead?)");
                this.eventWriter.endObject();
            } else {
                this.eventWriter.endArray();
            }
            this.blockType = this.blockStack.pop();
        }
        return this;
    }

    @Override
    public JsonLikeWriter endBlock() throws IOException {
        if (this.blockType == BlockType.NONE) {
            log.error("JsonLikeStreamWriter.endBlock(); called with no active JSON document");
        } else {
            if (this.blockType == BlockType.ARRAY) {
                this.eventWriter.endArray();
            } else {
                this.eventWriter.endObject();
            }
            this.blockType = this.blockStack.pop();
        }
        return this;
    }

    private static enum BlockType {
        NONE,
        OBJECT,
        ARRAY;

    }
}

