/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.NonPrettyPrintWriterWrapper;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;

public class PrettyPrintWriterWrapper
implements XMLStreamWriter {
    private static final String INDENT_CHAR = " ";
    private static final String LINEFEED_CHAR = "\n";
    private static final String PRE = "pre";
    private int depth = 0;
    private Map<Integer, Boolean> hasChildElement = new HashMap<Integer, Boolean>();
    private int myInsidePre = 0;
    private XMLStreamWriter myTarget;
    private boolean myFirstIndent = true;

    public PrettyPrintWriterWrapper(XMLStreamWriter target) {
        this.myTarget = target;
    }

    @Override
    public void close() throws XMLStreamException {
        this.myTarget.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.myTarget.flush();
    }

    @Override
    @CoverageIgnore
    public NamespaceContext getNamespaceContext() {
        return this.myTarget.getNamespaceContext();
    }

    @Override
    @CoverageIgnore
    public String getPrefix(String theUri) throws XMLStreamException {
        return this.myTarget.getPrefix(theUri);
    }

    @Override
    @CoverageIgnore
    public Object getProperty(String theName) throws IllegalArgumentException {
        return this.myTarget.getProperty(theName);
    }

    @Override
    @CoverageIgnore
    public void setDefaultNamespace(String theUri) throws XMLStreamException {
        this.myTarget.setDefaultNamespace(theUri);
    }

    @Override
    @CoverageIgnore
    public void setNamespaceContext(NamespaceContext theContext) throws XMLStreamException {
        this.myTarget.setNamespaceContext(theContext);
    }

    @Override
    @CoverageIgnore
    public void setPrefix(String thePrefix, String theUri) throws XMLStreamException {
        this.myTarget.setPrefix(thePrefix, theUri);
    }

    @Override
    public void writeAttribute(String theLocalName, String theValue) throws XMLStreamException {
        this.myTarget.writeAttribute(theLocalName, theValue);
    }

    @Override
    @CoverageIgnore
    public void writeAttribute(String theNamespaceURI, String theLocalName, String theValue) throws XMLStreamException {
        this.myTarget.writeAttribute(theNamespaceURI, theLocalName, theValue);
    }

    @Override
    @CoverageIgnore
    public void writeAttribute(String thePrefix, String theNamespaceURI, String theLocalName, String theValue) throws XMLStreamException {
        this.myTarget.writeAttribute(thePrefix, theNamespaceURI, theLocalName, theValue);
    }

    @Override
    @CoverageIgnore
    public void writeCData(String theData) throws XMLStreamException {
        this.myTarget.writeCData(theData);
    }

    @Override
    public void writeCharacters(char[] theText, int theStart, int theLen) throws XMLStreamException {
        NonPrettyPrintWriterWrapper.writeCharacters(theText, theStart, theLen, this.myTarget, this.myInsidePre);
    }

    @Override
    public void writeCharacters(String theText) throws XMLStreamException {
        if (this.myInsidePre > 0) {
            this.myTarget.writeCharacters(theText);
        } else {
            this.writeCharacters(theText.toCharArray(), 0, theText.length());
        }
    }

    @Override
    public void writeComment(String theData) throws XMLStreamException {
        this.indent();
        this.myTarget.writeComment(theData);
    }

    @Override
    public void writeDefaultNamespace(String theNamespaceURI) throws XMLStreamException {
        this.myTarget.writeDefaultNamespace(theNamespaceURI);
    }

    @Override
    @CoverageIgnore
    public void writeDTD(String theDtd) throws XMLStreamException {
        this.myTarget.writeDTD(theDtd);
    }

    @Override
    @CoverageIgnore
    public void writeEmptyElement(String theLocalName) throws XMLStreamException {
        this.indent();
        this.myTarget.writeEmptyElement(theLocalName);
    }

    @Override
    @CoverageIgnore
    public void writeEmptyElement(String theNamespaceURI, String theLocalName) throws XMLStreamException {
        this.indent();
        this.myTarget.writeEmptyElement(theNamespaceURI, theLocalName);
    }

    @Override
    @CoverageIgnore
    public void writeEmptyElement(String thePrefix, String theLocalName, String theNamespaceURI) throws XMLStreamException {
        this.indent();
        this.myTarget.writeEmptyElement(thePrefix, theLocalName, theNamespaceURI);
    }

    @Override
    @CoverageIgnore
    public void writeEndDocument() throws XMLStreamException {
        this.decrementAndIndent();
        this.myTarget.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.myInsidePre > 0) {
            --this.myInsidePre;
        }
        this.decrementAndIndent();
        this.myTarget.writeEndElement();
    }

    @Override
    @CoverageIgnore
    public void writeEntityRef(String theName) throws XMLStreamException {
        this.myTarget.writeEntityRef(theName);
    }

    @Override
    public void writeNamespace(String thePrefix, String theNamespaceURI) throws XMLStreamException {
        this.myTarget.writeNamespace(thePrefix, theNamespaceURI);
    }

    @Override
    @CoverageIgnore
    public void writeProcessingInstruction(String theTarget) throws XMLStreamException {
        this.myTarget.writeProcessingInstruction(theTarget);
    }

    @Override
    @CoverageIgnore
    public void writeProcessingInstruction(String theTarget, String theData) throws XMLStreamException {
        this.myTarget.writeProcessingInstruction(theTarget, theData);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.myFirstIndent = true;
        this.myTarget.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String theVersion) throws XMLStreamException {
        this.myFirstIndent = true;
        this.myTarget.writeStartDocument(theVersion);
    }

    @Override
    public void writeStartDocument(String theEncoding, String theVersion) throws XMLStreamException {
        this.myFirstIndent = true;
        this.myTarget.writeStartDocument(theEncoding, theVersion);
    }

    @Override
    public void writeStartElement(String theLocalName) throws XMLStreamException {
        this.indentAndAdd();
        this.myTarget.writeStartElement(theLocalName);
        if (PRE.equals(theLocalName) || this.myInsidePre > 0) {
            ++this.myInsidePre;
        }
    }

    @Override
    public void writeStartElement(String theNamespaceURI, String theLocalName) throws XMLStreamException {
        this.indentAndAdd();
        this.myTarget.writeStartElement(theNamespaceURI, theLocalName);
        if (PRE.equals(theLocalName) || this.myInsidePre > 0) {
            ++this.myInsidePre;
        }
    }

    @Override
    public void writeStartElement(String thePrefix, String theLocalName, String theNamespaceURI) throws XMLStreamException {
        this.indentAndAdd();
        this.myTarget.writeStartElement(thePrefix, theLocalName, theNamespaceURI);
        if (PRE.equals(theLocalName) || this.myInsidePre > 0) {
            ++this.myInsidePre;
        }
    }

    private void decrementAndIndent() throws XMLStreamException {
        if (this.myInsidePre > 0) {
            return;
        }
        --this.depth;
        if (this.hasChildElement.get(this.depth).booleanValue()) {
            this.myTarget.writeCharacters(LINEFEED_CHAR + this.repeat(this.depth, INDENT_CHAR));
        }
    }

    private void indent() throws XMLStreamException {
        if (this.myFirstIndent) {
            this.myFirstIndent = false;
            return;
        }
        this.myTarget.writeCharacters(LINEFEED_CHAR + this.repeat(this.depth, INDENT_CHAR));
    }

    private void indentAndAdd() throws XMLStreamException {
        if (this.myInsidePre > 0) {
            return;
        }
        this.indent();
        if (this.depth > 0) {
            this.hasChildElement.put(this.depth - 1, true);
        }
        this.hasChildElement.put(this.depth, false);
        ++this.depth;
    }

    private String repeat(int d, String s) {
        return StringUtils.repeat((String)s, (int)(d * 3));
    }
}

