/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.LSInputImpl;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.input.BOMInputStream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public class SchemaBaseValidator
implements IValidatorModule {
    public static final String RESOURCES_JAR_NOTE = "Note that as of HAPI FHIR 1.2, DSTU2 validation files are kept in a separate JAR (hapi-fhir-validation-resources-XXX.jar) which must be added to your classpath. See the HAPI FHIR download page for more information.";
    private static final Logger ourLog = LoggerFactory.getLogger(SchemaBaseValidator.class);
    private static final Set<String> SCHEMA_NAMES;
    private Map<String, Schema> myKeyToSchema = new HashMap<String, Schema>();
    private FhirContext myCtx;

    public SchemaBaseValidator(FhirContext theContext) {
        this.myCtx = theContext;
    }

    private void doValidate(IValidationContext<?> theContext, String schemaName) {
        Schema schema = this.loadSchema("dstu", schemaName);
        try {
            Validator validator = schema.newValidator();
            MyErrorHandler handler = new MyErrorHandler(theContext);
            validator.setErrorHandler(handler);
            String encodedResource = theContext.getResourceAsStringEncoding() == EncodingEnum.XML ? theContext.getResourceAsString() : theContext.getFhirContext().newXmlParser().encodeResourceToString((IBaseResource)theContext.getResource());
            try {
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            catch (SAXNotRecognizedException ex) {
                ourLog.warn("Jaxp 1.5 Support not found.", (Throwable)ex);
            }
            validator.validate(new StreamSource(new StringReader(encodedResource)));
        }
        catch (SAXParseException e) {
            SingleValidationMessage message = new SingleValidationMessage();
            message.setLocationLine(e.getLineNumber());
            message.setLocationCol(e.getColumnNumber());
            message.setMessage(e.getLocalizedMessage());
            message.setSeverity(ResultSeverityEnum.FATAL);
            theContext.addValidationMessage(message);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Could not load/parse schema file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not load/parse schema file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema loadSchema(String theVersion, String theSchemaName) {
        String key = theVersion + "-" + theSchemaName;
        Map<String, Schema> map = this.myKeyToSchema;
        synchronized (map) {
            Schema schema = this.myKeyToSchema.get(key);
            if (schema != null) {
                return schema;
            }
            Source baseSource = this.loadXml(null, theSchemaName);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new MyResourceResolver());
            try {
                try {
                    schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                }
                catch (SAXNotRecognizedException snex) {
                    ourLog.warn("Jaxp 1.5 Support not found.", (Throwable)snex);
                }
                schema = schemaFactory.newSchema(new Source[]{baseSource});
            }
            catch (SAXException e) {
                throw new ConfigurationException("Could not load/parse schema file: " + theSchemaName, e);
            }
            this.myKeyToSchema.put(key, schema);
            return schema;
        }
    }

    private Source loadXml(String theSystemId, String theSchemaName) {
        String pathToBase = this.myCtx.getVersion().getPathToSchemaDefinitions() + '/' + theSchemaName;
        ourLog.debug("Going to load resource: {}", (Object)pathToBase);
        InputStream baseIs = FhirValidator.class.getResourceAsStream(pathToBase);
        if (baseIs == null) {
            throw new InternalErrorException("Schema not found. Note that as of HAPI FHIR 1.2, DSTU2 validation files are kept in a separate JAR (hapi-fhir-validation-resources-XXX.jar) which must be added to your classpath. See the HAPI FHIR download page for more information.");
        }
        baseIs = new BOMInputStream(baseIs, false);
        InputStreamReader baseReader = new InputStreamReader(baseIs, Charset.forName("UTF-8"));
        StreamSource baseSource = new StreamSource(baseReader, theSystemId);
        return baseSource;
    }

    @Override
    public void validateResource(IValidationContext<IBaseResource> theContext) {
        this.doValidate(theContext, "fhir-single.xsd");
    }

    static {
        HashSet<String> sn = new HashSet<String>();
        sn.add("xml.xsd");
        sn.add("xhtml1-strict.xsd");
        sn.add("fhir-single.xsd");
        sn.add("fhir-xhtml.xsd");
        sn.add("tombstone.xsd");
        sn.add("opensearch.xsd");
        sn.add("opensearchscore.xsd");
        sn.add("xmldsig-core-schema.xsd");
        SCHEMA_NAMES = Collections.unmodifiableSet(sn);
    }

    private final class MyResourceResolver
    implements LSResourceResolver {
        private MyResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String theType, String theNamespaceURI, String thePublicId, String theSystemId, String theBaseURI) {
            if (theSystemId != null && SCHEMA_NAMES.contains(theSystemId)) {
                LSInputImpl input = new LSInputImpl();
                input.setPublicId(thePublicId);
                input.setSystemId(theSystemId);
                input.setBaseURI(theBaseURI);
                String pathToBase = SchemaBaseValidator.this.myCtx.getVersion().getPathToSchemaDefinitions() + '/' + theSystemId;
                ourLog.debug("Loading referenced schema file: " + pathToBase);
                InputStream baseIs = FhirValidator.class.getResourceAsStream(pathToBase);
                if (baseIs == null) {
                    throw new InternalErrorException("Schema file not found: " + pathToBase);
                }
                input.setByteStream(baseIs);
                return input;
            }
            throw new ConfigurationException("Unknown schema: " + theSystemId);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private IValidationContext<?> myContext;

        public MyErrorHandler(IValidationContext<?> theContext) {
            this.myContext = theContext;
        }

        private void addIssue(SAXParseException theException, ResultSeverityEnum theSeverity) {
            SingleValidationMessage message = new SingleValidationMessage();
            message.setLocationLine(theException.getLineNumber());
            message.setLocationCol(theException.getColumnNumber());
            message.setMessage(theException.getLocalizedMessage());
            message.setSeverity(theSeverity);
            this.myContext.addValidationMessage(message);
        }

        @Override
        public void error(SAXParseException theException) {
            this.addIssue(theException, ResultSeverityEnum.ERROR);
        }

        @Override
        public void fatalError(SAXParseException theException) {
            this.addIssue(theException, ResultSeverityEnum.FATAL);
        }

        @Override
        public void warning(SAXParseException theException) {
            this.addIssue(theException, ResultSeverityEnum.WARNING);
        }
    }
}

