/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuntimeSearchParam {
    private final IIdType myId;
    private final Set<String> myBase;
    private final List<RuntimeSearchParam> myCompositeOf;
    private final String myDescription;
    private final String myName;
    private final RestSearchParameterTypeEnum myParamType;
    private final String myPath;
    private final Set<String> myTargets;
    private final Set<String> myProvidesMembershipInCompartments;
    private final RuntimeSearchParamStatusEnum myStatus;
    private final String myUri;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("base", this.myBase).append("name", (Object)this.myName).append("path", (Object)this.myPath).append("id", (Object)this.myId).append("uri", (Object)this.myUri).toString();
    }

    public IIdType getId() {
        return this.myId;
    }

    public String getUri() {
        return this.myUri;
    }

    public RuntimeSearchParam(IIdType theId, String theUri, String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, List<RuntimeSearchParam> theCompositeOf, Set<String> theProvidesMembershipInCompartments, Set<String> theTargets, RuntimeSearchParamStatusEnum theStatus) {
        this(theId, theUri, theName, theDescription, thePath, theParamType, theCompositeOf, theProvidesMembershipInCompartments, theTargets, theStatus, null);
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        RuntimeSearchParam that = (RuntimeSearchParam)theO;
        return new EqualsBuilder().append((Object)this.getId(), (Object)that.getId()).append((Object)this.getName(), (Object)that.getName()).append((Object)this.getPath(), (Object)that.getPath()).append((Object)this.getUri(), (Object)that.getUri()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).append((Object)this.getName()).append((Object)this.getPath()).append((Object)this.getUri()).toHashCode();
    }

    public RuntimeSearchParam(IIdType theId, String theUri, String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, List<RuntimeSearchParam> theCompositeOf, Set<String> theProvidesMembershipInCompartments, Set<String> theTargets, RuntimeSearchParamStatusEnum theStatus, Collection<String> theBase) {
        this.myId = theId;
        this.myUri = theUri;
        this.myName = theName;
        this.myDescription = theDescription;
        this.myPath = thePath;
        this.myParamType = theParamType;
        this.myCompositeOf = theCompositeOf;
        this.myStatus = theStatus;
        this.myProvidesMembershipInCompartments = theProvidesMembershipInCompartments != null && !theProvidesMembershipInCompartments.isEmpty() ? Collections.unmodifiableSet(theProvidesMembershipInCompartments) : null;
        this.myTargets = theTargets != null && !theTargets.isEmpty() ? Collections.unmodifiableSet(theTargets) : Collections.emptySet();
        if (theBase == null || theBase.isEmpty()) {
            int indexOf;
            HashSet<String> base = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)thePath) && (indexOf = thePath.indexOf(46)) != -1) {
                base.add(StringUtils.trim((String)thePath.substring(0, indexOf)));
            }
            this.myBase = Collections.unmodifiableSet(base);
        } else {
            this.myBase = Collections.unmodifiableSet(new HashSet<String>(theBase));
        }
    }

    public Set<String> getBase() {
        return this.myBase;
    }

    @Nonnull
    public Set<String> getTargets() {
        return this.myTargets;
    }

    public boolean hasTargets() {
        return !this.myTargets.isEmpty();
    }

    public RuntimeSearchParamStatusEnum getStatus() {
        return this.myStatus;
    }

    public RuntimeSearchParam(String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, Set<String> theProvidesMembershipInCompartments, Set<String> theTargets, RuntimeSearchParamStatusEnum theStatus) {
        this(null, null, theName, theDescription, thePath, theParamType, null, theProvidesMembershipInCompartments, theTargets, theStatus);
    }

    public List<RuntimeSearchParam> getCompositeOf() {
        return this.myCompositeOf;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getName() {
        return this.myName;
    }

    public RestSearchParameterTypeEnum getParamType() {
        return this.myParamType;
    }

    public String getPath() {
        return this.myPath;
    }

    public List<String> getPathsSplit() {
        String path = this.getPath();
        if (path.indexOf(124) == -1) {
            return Collections.singletonList(path);
        }
        ArrayList<String> retVal = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, "|");
        while (tok.hasMoreElements()) {
            String nextPath = tok.nextToken().trim();
            retVal.add(nextPath.trim());
        }
        return retVal;
    }

    public Set<String> getProvidesMembershipInCompartments() {
        return this.myProvidesMembershipInCompartments;
    }

    public static enum RuntimeSearchParamStatusEnum {
        ACTIVE,
        DRAFT,
        RETIRED,
        UNKNOWN;

    }
}

