/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.view;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ViewGenerator {
    private FhirContext myCtx;

    public ViewGenerator(FhirContext theFhirContext) {
        this.myCtx = theFhirContext;
    }

    public <T extends IBaseResource> T newView(IBaseResource theResource, Class<T> theTargetType) {
        IBaseResource retVal;
        Class<?> sourceType = theResource.getClass();
        RuntimeResourceDefinition sourceDef = this.myCtx.getResourceDefinition(theResource);
        RuntimeResourceDefinition targetDef = this.myCtx.getResourceDefinition(theTargetType);
        if (sourceType.equals(theTargetType)) {
            IBaseResource resource = theResource;
            return (T)resource;
        }
        try {
            retVal = (IBaseResource)theTargetType.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to instantiate " + theTargetType, e);
        }
        this.copyChildren(sourceDef, theResource, targetDef, retVal);
        return (T)retVal;
    }

    private void copyChildren(BaseRuntimeElementCompositeDefinition<?> theSourceDef, IBase theSource, BaseRuntimeElementCompositeDefinition<?> theTargetDef, IBase theTarget) {
        if (!theSource.isEmpty()) {
            List<BaseRuntimeChildDefinition> targetChildren = theTargetDef.getChildren();
            List<RuntimeChildDeclaredExtensionDefinition> targetExts = theTargetDef.getExtensions();
            for (BaseRuntimeChildDefinition nextChild : targetChildren) {
                BaseRuntimeChildDefinition sourceChildEquivalent;
                String elementName = nextChild.getElementName();
                if (nextChild.getValidChildNames().size() > 1) {
                    elementName = nextChild.getValidChildNames().iterator().next();
                }
                if ((sourceChildEquivalent = theSourceDef.getChildByNameOrThrowDataFormatException(elementName)) == null) continue;
                List<IBase> sourceValues = sourceChildEquivalent.getAccessor().getValues(theSource);
                for (IBase nextElement : sourceValues) {
                    boolean handled = false;
                    if (nextElement instanceof IBaseExtension) {
                        String url = ((IBaseExtension)nextElement).getUrl();
                        for (RuntimeChildDeclaredExtensionDefinition nextExt : targetExts) {
                            String nextTargetUrl = nextExt.getExtensionUrl();
                            if (!nextTargetUrl.equals(url)) continue;
                            this.addExtension(theSourceDef, theSource, theTarget, nextExt, url);
                            handled = true;
                        }
                    }
                    if (handled) continue;
                    nextChild.getMutator().addValue(theTarget, nextElement);
                }
            }
            for (RuntimeChildDeclaredExtensionDefinition nextExt : targetExts) {
                String url = nextExt.getExtensionUrl();
                this.addExtension(theSourceDef, theSource, theTarget, nextExt, url);
            }
        }
    }

    private void addExtension(BaseRuntimeElementCompositeDefinition<?> theSourceDef, IBase theSource, IBase theTarget, RuntimeChildDeclaredExtensionDefinition nextExt, String url) {
        block5: {
            RuntimeChildDeclaredExtensionDefinition sourceDeclaredExt;
            block4: {
                sourceDeclaredExt = theSourceDef.getDeclaredExtension(url, "");
                if (sourceDeclaredExt != null) break block4;
                if (theSource instanceof IBaseHasExtensions) {
                    for (IBaseExtension<?, ?> next : ((IBaseHasExtensions)theSource).getExtension()) {
                        if (!next.getUrl().equals(url)) continue;
                        nextExt.getMutator().addValue(theTarget, next.getValue());
                    }
                }
                if (!(theSource instanceof IBaseHasModifierExtensions)) break block5;
                for (IBaseExtension<?, ?> next : ((IBaseHasModifierExtensions)((Object)theSource)).getModifierExtension()) {
                    if (!next.getUrl().equals(url)) continue;
                    nextExt.getMutator().addValue(theTarget, next.getValue());
                }
                break block5;
            }
            List<IBase> values = sourceDeclaredExt.getAccessor().getValues(theSource);
            for (IBase nextElement : values) {
                nextExt.getMutator().addValue(theTarget, nextElement);
            }
        }
    }
}

