/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.json;

import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.json.GsonWriter;
import ca.uhn.fhir.parser.json.JsonLikeArray;
import ca.uhn.fhir.parser.json.JsonLikeObject;
import ca.uhn.fhir.parser.json.JsonLikeStructure;
import ca.uhn.fhir.parser.json.JsonLikeValue;
import ca.uhn.fhir.parser.json.JsonLikeWriter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GsonStructure
implements JsonLikeStructure {
    private ROOT_TYPE rootType = null;
    private JsonElement nativeRoot = null;
    private JsonLikeValue jsonLikeRoot = null;
    private GsonWriter jsonLikeWriter = null;

    public void setNativeObject(JsonObject json) {
        this.rootType = ROOT_TYPE.OBJECT;
        this.nativeRoot = json;
    }

    public void setNativeArray(JsonArray json) {
        this.rootType = ROOT_TYPE.ARRAY;
        this.nativeRoot = json;
    }

    @Override
    public JsonLikeStructure getInstance() {
        return new GsonStructure();
    }

    @Override
    public void load(Reader theReader) throws DataFormatException {
        this.load(theReader, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(Reader theReader, boolean allowArray) throws DataFormatException {
        PushbackReader pbr = new PushbackReader(theReader);
        try {
            int nextInt;
            block7: {
                do {
                    if ((nextInt = pbr.read()) == -1) {
                        throw new DataFormatException("Did not find any content to parse");
                    }
                    if (nextInt != 123) continue;
                    pbr.unread(nextInt);
                    break block7;
                } while (Character.isWhitespace(nextInt));
                if (!allowArray) throw new DataFormatException("Content does not appear to be FHIR JSON, first non-whitespace character was: '" + (char)nextInt + "' (must be '{')");
                if (nextInt != 91) throw new DataFormatException("Content does not appear to be FHIR JSON, first non-whitespace character was: '" + (char)nextInt + "' (must be '{' or '[')");
                pbr.unread(nextInt);
            }
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            if (nextInt == 123) {
                JsonObject root = (JsonObject)gson.fromJson((Reader)pbr, JsonObject.class);
                this.setNativeObject(root);
                return;
            } else {
                if (nextInt != 91) return;
                JsonArray root = (JsonArray)gson.fromJson((Reader)pbr, JsonArray.class);
                this.setNativeArray(root);
            }
            return;
        }
        catch (JsonSyntaxException e) {
            if (!e.getMessage().startsWith("Unexpected char 39")) throw new DataFormatException("Failed to parse JSON encoded FHIR content: " + e.getMessage(), e);
            throw new DataFormatException("Failed to parse JSON encoded FHIR content: " + e.getMessage() + " - This may indicate that single quotes are being used as JSON escapes where double quotes are required", e);
        }
        catch (Exception e) {
            throw new DataFormatException("Failed to parse JSON content, error was: " + e.getMessage(), e);
        }
    }

    @Override
    public JsonLikeWriter getJsonLikeWriter(Writer writer) {
        if (null == this.jsonLikeWriter) {
            this.jsonLikeWriter = new GsonWriter(writer);
        }
        return this.jsonLikeWriter;
    }

    @Override
    public JsonLikeWriter getJsonLikeWriter() {
        if (null == this.jsonLikeWriter) {
            this.jsonLikeWriter = new GsonWriter();
        }
        return this.jsonLikeWriter;
    }

    @Override
    public JsonLikeObject getRootObject() throws DataFormatException {
        if (this.rootType == ROOT_TYPE.OBJECT) {
            if (null == this.jsonLikeRoot) {
                this.jsonLikeRoot = new GsonJsonObject((JsonObject)this.nativeRoot);
            }
            return this.jsonLikeRoot.getAsObject();
        }
        throw new DataFormatException("Content must be a valid JSON Object. It must start with '{'.");
    }

    @Override
    public JsonLikeArray getRootArray() throws DataFormatException {
        if (this.rootType == ROOT_TYPE.ARRAY) {
            if (null == this.jsonLikeRoot) {
                this.jsonLikeRoot = new GsonJsonArray((JsonArray)this.nativeRoot);
            }
            return this.jsonLikeRoot.getAsArray();
        }
        throw new DataFormatException("Content must be a valid JSON Array. It must start with '['.");
    }

    private static class EntryOrderedSet<T>
    extends AbstractSet<T> {
        private transient ArrayList<T> data = null;

        public EntryOrderedSet(int initialCapacity) {
            this.data = new ArrayList(initialCapacity);
        }

        public EntryOrderedSet() {
            this.data = new ArrayList();
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.data.contains(o);
        }

        public T get(int index) {
            return this.data.get(index);
        }

        @Override
        public boolean add(T element) {
            if (this.data.contains(element)) {
                return false;
            }
            return this.data.add(element);
        }

        @Override
        public boolean remove(Object o) {
            return this.data.remove(o);
        }

        @Override
        public void clear() {
            this.data.clear();
        }

        @Override
        public Iterator<T> iterator() {
            return this.data.iterator();
        }
    }

    private static class GsonJsonValue
    extends JsonLikeValue {
        private JsonElement nativeValue;
        private JsonLikeObject jsonLikeObject = null;
        private JsonLikeArray jsonLikeArray = null;

        public GsonJsonValue(JsonElement json) {
            this.nativeValue = json;
        }

        @Override
        public Object getValue() {
            if (this.nativeValue != null && this.nativeValue.isJsonPrimitive()) {
                if (((JsonPrimitive)this.nativeValue).isNumber()) {
                    return this.nativeValue.getAsNumber();
                }
                if (((JsonPrimitive)this.nativeValue).isBoolean()) {
                    return this.nativeValue.getAsBoolean();
                }
                return this.nativeValue.getAsString();
            }
            return null;
        }

        @Override
        public JsonLikeValue.ValueType getJsonType() {
            if (null == this.nativeValue || this.nativeValue.isJsonNull()) {
                return JsonLikeValue.ValueType.NULL;
            }
            if (this.nativeValue.isJsonObject()) {
                return JsonLikeValue.ValueType.OBJECT;
            }
            if (this.nativeValue.isJsonArray()) {
                return JsonLikeValue.ValueType.ARRAY;
            }
            if (this.nativeValue.isJsonPrimitive()) {
                return JsonLikeValue.ValueType.SCALAR;
            }
            return null;
        }

        @Override
        public JsonLikeValue.ScalarType getDataType() {
            if (this.nativeValue != null && this.nativeValue.isJsonPrimitive()) {
                if (((JsonPrimitive)this.nativeValue).isNumber()) {
                    return JsonLikeValue.ScalarType.NUMBER;
                }
                if (((JsonPrimitive)this.nativeValue).isString()) {
                    return JsonLikeValue.ScalarType.STRING;
                }
                if (((JsonPrimitive)this.nativeValue).isBoolean()) {
                    return JsonLikeValue.ScalarType.BOOLEAN;
                }
            }
            return null;
        }

        @Override
        public JsonLikeArray getAsArray() {
            if (this.nativeValue != null && this.nativeValue.isJsonArray() && null == this.jsonLikeArray) {
                this.jsonLikeArray = new GsonJsonArray((JsonArray)this.nativeValue);
            }
            return this.jsonLikeArray;
        }

        @Override
        public JsonLikeObject getAsObject() {
            if (this.nativeValue != null && this.nativeValue.isJsonObject() && null == this.jsonLikeObject) {
                this.jsonLikeObject = new GsonJsonObject((JsonObject)this.nativeValue);
            }
            return this.jsonLikeObject;
        }

        @Override
        public Number getAsNumber() {
            return this.nativeValue != null ? (Number)this.nativeValue.getAsNumber() : (Number)null;
        }

        @Override
        public String getAsString() {
            return this.nativeValue != null ? this.nativeValue.getAsString() : null;
        }

        @Override
        public boolean getAsBoolean() {
            if (this.nativeValue != null && this.nativeValue.isJsonPrimitive() && ((JsonPrimitive)this.nativeValue).isBoolean()) {
                return this.nativeValue.getAsBoolean();
            }
            return super.getAsBoolean();
        }
    }

    private static class GsonJsonArray
    extends JsonLikeArray {
        private JsonArray nativeArray;
        private Map<Integer, JsonLikeValue> jsonLikeMap = new LinkedHashMap<Integer, JsonLikeValue>();

        public GsonJsonArray(JsonArray json) {
            this.nativeArray = json;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public int size() {
            return this.nativeArray.size();
        }

        @Override
        public JsonLikeValue get(int index) {
            Integer key = index;
            JsonLikeValue result = null;
            if (this.jsonLikeMap.containsKey(key)) {
                result = this.jsonLikeMap.get(key);
            } else {
                JsonElement child = this.nativeArray.get(index);
                if (child != null) {
                    result = new GsonJsonValue(child);
                }
                this.jsonLikeMap.put(key, result);
            }
            return result;
        }
    }

    private static class GsonJsonObject
    extends JsonLikeObject {
        private JsonObject nativeObject;
        private Set<String> keySet = null;
        private Map<String, JsonLikeValue> jsonLikeMap = new LinkedHashMap<String, JsonLikeValue>();

        public GsonJsonObject(JsonObject json) {
            this.nativeObject = json;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Set<String> keySet() {
            if (null == this.keySet) {
                Set entrySet = this.nativeObject.entrySet();
                this.keySet = new EntryOrderedSet<String>(entrySet.size());
                for (Map.Entry entry : entrySet) {
                    this.keySet.add((String)entry.getKey());
                }
            }
            return this.keySet;
        }

        @Override
        public JsonLikeValue get(String key) {
            JsonLikeValue result = null;
            if (this.jsonLikeMap.containsKey(key)) {
                result = this.jsonLikeMap.get(key);
            } else {
                JsonElement child = this.nativeObject.get(key);
                if (child != null) {
                    result = new GsonJsonValue(child);
                }
                this.jsonLikeMap.put(key, result);
            }
            return result;
        }
    }

    private static enum ROOT_TYPE {
        OBJECT,
        ARRAY;

    }
}

