/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.model.api.ICompositeElement;
import ca.uhn.fhir.model.api.IElement;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;

public class ElementUtil {
    public static boolean isEmpty(Object ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            Object next = theElements[i];
            if (next instanceof List) {
                if (ElementUtil.isEmpty((List)next)) continue;
                return false;
            }
            if (next instanceof String && !((String)next).isEmpty()) {
                return false;
            }
            if (next == null || ((IBase)next).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IBase ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            IBase next = theElements[i];
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IElement ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            IElement next = theElements[i];
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(List<? extends IBase> theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.size(); ++i) {
            IBase next;
            try {
                next = theElements.get(i);
            }
            catch (ClassCastException e) {
                List<? extends IBase> elements = theElements;
                String s = "Found instance of " + elements.get(i).getClass() + " - Did you set a field value to the incorrect type? Expected " + IBase.class.getName();
                throw new ClassCastException(s);
            }
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static <T extends IElement> List<T> allPopulatedChildElements(Class<T> theType, Object ... theElements) {
        ArrayList retVal = new ArrayList();
        for (Object next : theElements) {
            if (next == null) continue;
            if (next instanceof IElement) {
                ElementUtil.addElement(retVal, (IElement)next, theType);
                continue;
            }
            if (next instanceof List) {
                for (Object nextElement : (List)next) {
                    if (!(nextElement instanceof IBase)) {
                        throw new IllegalArgumentException("Found element of " + nextElement.getClass());
                    }
                    ElementUtil.addElement(retVal, (IElement)nextElement, theType);
                }
                continue;
            }
            throw new IllegalArgumentException("Found element of " + next.getClass());
        }
        return retVal;
    }

    private static <T extends IElement> void addElement(ArrayList<T> retVal, IElement next, Class<T> theType) {
        if (theType == null || theType.isAssignableFrom(next.getClass())) {
            retVal.add((IElement)theType.cast(next));
        }
        if (next instanceof ICompositeElement) {
            ICompositeElement iCompositeElement = (ICompositeElement)next;
            retVal.addAll(iCompositeElement.getAllPopulatedChildElementsOfType(theType));
        }
    }
}

