/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    public static void isGreaterThan(long theValue, long theMinimum, String theMessage) {
        if (theValue <= theMinimum) {
            throw new IllegalArgumentException(theMessage);
        }
    }

    public static void isGreaterThanOrEqualTo(long theValue, long theMinimum, String theMessage) {
        if (theValue < theMinimum) {
            throw new IllegalArgumentException(theMessage);
        }
    }

    public static void isNotBlankOrThrowIllegalArgument(String theString, String theMessage) {
        if (StringUtils.isBlank((CharSequence)theString)) {
            throw new IllegalArgumentException(theMessage);
        }
    }

    public static void isNotBlankOrThrowInvalidRequest(String theString, String theMessage) {
        if (StringUtils.isBlank((CharSequence)theString)) {
            throw new InvalidRequestException(theMessage);
        }
    }

    public static void isNotBlankOrThrowUnprocessableEntity(String theString, String theMessage) {
        if (StringUtils.isBlank((CharSequence)theString)) {
            throw new UnprocessableEntityException(theMessage);
        }
    }

    public static void isNotNullOrThrowUnprocessableEntity(Object theObject, String theMessage, Object ... theValues) {
        if (theObject == null) {
            throw new UnprocessableEntityException(String.format(theMessage, theValues));
        }
    }

    public static void isNotTooLongOrThrowIllegalArgument(String theString, int theMaxLength, String theMessage) {
        if (StringUtils.length((CharSequence)theString) > theMaxLength) {
            throw new IllegalArgumentException(theMessage);
        }
    }

    public static void isTrueOrThrowInvalidRequest(boolean theSuccess, String theMessage, Object ... theValues) {
        if (!theSuccess) {
            throw new InvalidRequestException(String.format(theMessage, theValues));
        }
    }

    public static void exactlyOneNotNullOrThrowInvalidRequestException(Object[] theObjects, String theMessage) {
        int count = 0;
        for (Object next : theObjects) {
            if (next == null) continue;
            ++count;
        }
        if (count != 1) {
            throw new InvalidRequestException(theMessage);
        }
    }
}

