/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.LSInputImpl;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public class SchemaBaseValidator
implements IValidatorModule {
    public static final String RESOURCES_JAR_NOTE = "Note that as of HAPI FHIR 1.2, DSTU2 validation files are kept in a separate JAR (hapi-fhir-validation-resources-XXX.jar) which must be added to your classpath. See the HAPI FHIR download page for more information.";
    private static final Logger ourLog = LoggerFactory.getLogger(SchemaBaseValidator.class);
    private static final Set<String> SCHEMA_NAMES;
    private final Map<String, Schema> myKeyToSchema = new HashMap<String, Schema>();
    private FhirContext myCtx;

    public SchemaBaseValidator(FhirContext theContext) {
        this.myCtx = theContext;
    }

    private void doValidate(IValidationContext<?> theContext) {
        Schema schema = this.loadSchema();
        try {
            Validator validator = schema.newValidator();
            MyErrorHandler handler = new MyErrorHandler(theContext);
            validator.setErrorHandler(handler);
            String encodedResource = theContext.getResourceAsStringEncoding() == EncodingEnum.XML ? theContext.getResourceAsString() : theContext.getFhirContext().newXmlParser().encodeResourceToString((IBaseResource)theContext.getResource());
            try {
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            catch (SAXNotRecognizedException ex) {
                ourLog.warn("Jaxp 1.5 Support not found.", (Throwable)ex);
            }
            validator.validate(new StreamSource(new StringReader(encodedResource)));
        }
        catch (SAXParseException e) {
            SingleValidationMessage message = new SingleValidationMessage();
            message.setLocationLine(e.getLineNumber());
            message.setLocationCol(e.getColumnNumber());
            message.setMessage(e.getLocalizedMessage());
            message.setSeverity(ResultSeverityEnum.FATAL);
            theContext.addValidationMessage(message);
        }
        catch (IOException | SAXException e) {
            throw new ConfigurationException("Could not load/parse schema file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema loadSchema() {
        String key = "fhir-single.xsd";
        Map<String, Schema> map = this.myKeyToSchema;
        synchronized (map) {
            Schema schema = this.myKeyToSchema.get(key);
            if (schema != null) {
                return schema;
            }
            Source baseSource = this.loadXml("fhir-single.xsd");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new MyResourceResolver());
            try {
                try {
                    schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                }
                catch (SAXNotRecognizedException e) {
                    ourLog.warn("Jaxp 1.5 Support not found.", (Throwable)e);
                }
                schema = schemaFactory.newSchema(new Source[]{baseSource});
            }
            catch (SAXException e) {
                throw new ConfigurationException("Could not load/parse schema file: fhir-single.xsd", e);
            }
            this.myKeyToSchema.put(key, schema);
            return schema;
        }
    }

    /*
     * Exception decompiling
     */
    Source loadXml(String theSchemaName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void validateResource(IValidationContext<IBaseResource> theContext) {
        this.doValidate(theContext);
    }

    static {
        HashSet<String> sn = new HashSet<String>();
        sn.add("xml.xsd");
        sn.add("xhtml1-strict.xsd");
        sn.add("fhir-single.xsd");
        sn.add("fhir-xhtml.xsd");
        sn.add("tombstone.xsd");
        sn.add("opensearch.xsd");
        sn.add("opensearchscore.xsd");
        sn.add("xmldsig-core-schema.xsd");
        SCHEMA_NAMES = Collections.unmodifiableSet(sn);
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private IValidationContext<?> myContext;

        MyErrorHandler(IValidationContext<?> theContext) {
            this.myContext = theContext;
        }

        private void addIssue(SAXParseException theException, ResultSeverityEnum theSeverity) {
            SingleValidationMessage message = new SingleValidationMessage();
            message.setLocationLine(theException.getLineNumber());
            message.setLocationCol(theException.getColumnNumber());
            message.setMessage(theException.getLocalizedMessage());
            message.setSeverity(theSeverity);
            this.myContext.addValidationMessage(message);
        }

        @Override
        public void error(SAXParseException theException) {
            this.addIssue(theException, ResultSeverityEnum.ERROR);
        }

        @Override
        public void fatalError(SAXParseException theException) {
            this.addIssue(theException, ResultSeverityEnum.FATAL);
        }

        @Override
        public void warning(SAXParseException theException) {
            this.addIssue(theException, ResultSeverityEnum.WARNING);
        }
    }

    private final class MyResourceResolver
    implements LSResourceResolver {
        private MyResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String theType, String theNamespaceURI, String thePublicId, String theSystemId, String theBaseURI) {
            if (theSystemId != null && SCHEMA_NAMES.contains(theSystemId)) {
                LSInputImpl input = new LSInputImpl();
                input.setPublicId(thePublicId);
                input.setSystemId(theSystemId);
                input.setBaseURI(theBaseURI);
                String pathToBase = SchemaBaseValidator.this.myCtx.getVersion().getPathToSchemaDefinitions() + '/' + theSystemId;
                ourLog.debug("Loading referenced schema file: " + pathToBase);
                try (InputStream baseIs = FhirValidator.class.getResourceAsStream(pathToBase);){
                    if (baseIs == null) {
                        throw new InternalErrorException("Schema file not found: " + pathToBase);
                    }
                    byte[] bytes = IOUtils.toByteArray((InputStream)baseIs);
                    input.setByteStream(new ByteArrayInputStream(bytes));
                }
                catch (IOException e) {
                    throw new InternalErrorException(e);
                }
                return input;
            }
            throw new ConfigurationException("Unknown schema: " + theSystemId);
        }
    }
}

