/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.executor;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IBaseInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IBaseInterceptorService;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ReflectionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInterceptorService<POINTCUT extends Enum<POINTCUT>>
implements IBaseInterceptorService<POINTCUT>,
IBaseInterceptorBroadcaster<POINTCUT> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseInterceptorService.class);
    private final List<Object> myInterceptors = new ArrayList<Object>();
    private final ListMultimap<POINTCUT, BaseInvoker> myGlobalInvokers = ArrayListMultimap.create();
    private final ListMultimap<POINTCUT, BaseInvoker> myAnonymousInvokers = ArrayListMultimap.create();
    private final Object myRegistryMutex = new Object();
    private final Class<POINTCUT> myPointcutType;
    private volatile EnumSet<POINTCUT> myRegisteredPointcuts;
    private String myName;
    private boolean myWarnOnInterceptorWithNoHooks = true;

    public BaseInterceptorService(Class<POINTCUT> thePointcutType) {
        this(thePointcutType, "default");
    }

    public BaseInterceptorService(Class<POINTCUT> thePointcutType, String theName) {
        this.myName = theName;
        this.myPointcutType = thePointcutType;
        this.rebuildRegisteredPointcutSet();
    }

    public void setWarnOnInterceptorWithNoHooks(boolean theWarnOnInterceptorWithNoHooks) {
        this.myWarnOnInterceptorWithNoHooks = theWarnOnInterceptorWithNoHooks;
    }

    @VisibleForTesting
    List<Object> getGlobalInterceptorsForUnitTest() {
        return this.myInterceptors;
    }

    public void setName(String theName) {
        this.myName = theName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAnonymousInterceptor(POINTCUT thePointcut, Object theInterceptor, BaseInvoker theInvoker) {
        Validate.notNull(thePointcut);
        Validate.notNull((Object)theInterceptor);
        Object object = this.myRegistryMutex;
        synchronized (object) {
            this.myAnonymousInvokers.put(thePointcut, (Object)theInvoker);
            if (!this.isInterceptorAlreadyRegistered(theInterceptor)) {
                this.myInterceptors.add(theInterceptor);
            }
            this.rebuildRegisteredPointcutSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getAllRegisteredInterceptors() {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            ArrayList<Object> retVal = new ArrayList<Object>(this.myInterceptors);
            return Collections.unmodifiableList(retVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void unregisterAllInterceptors() {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            this.unregisterInterceptors(this.myAnonymousInvokers.values());
            this.unregisterInterceptors(this.myGlobalInvokers.values());
            this.unregisterInterceptors(this.myInterceptors);
        }
    }

    @Override
    public void unregisterInterceptors(@Nullable Collection<?> theInterceptors) {
        if (theInterceptors != null) {
            new ArrayList(theInterceptors).forEach(this::unregisterInterceptor);
        }
    }

    @Override
    public void registerInterceptors(@Nullable Collection<?> theInterceptors) {
        if (theInterceptors != null) {
            theInterceptors.forEach(this::registerInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAllAnonymousInterceptors() {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            this.unregisterInterceptorsIf(t -> true, this.myAnonymousInvokers);
        }
    }

    @Override
    public void unregisterInterceptorsIf(Predicate<Object> theShouldUnregisterFunction) {
        this.unregisterInterceptorsIf(theShouldUnregisterFunction, this.myGlobalInvokers);
        this.unregisterInterceptorsIf(theShouldUnregisterFunction, this.myAnonymousInvokers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInterceptorsIf(Predicate<Object> theShouldUnregisterFunction, ListMultimap<POINTCUT, BaseInvoker> theGlobalInvokers) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            for (Map.Entry nextInvoker : new ArrayList(theGlobalInvokers.entries())) {
                if (!theShouldUnregisterFunction.test(((BaseInvoker)nextInvoker.getValue()).getInterceptor())) continue;
                this.unregisterInterceptor(((BaseInvoker)nextInvoker.getValue()).getInterceptor());
            }
            this.rebuildRegisteredPointcutSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerInterceptor(Object theInterceptor) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            if (this.isInterceptorAlreadyRegistered(theInterceptor)) {
                return false;
            }
            List<HookInvoker> addedInvokers = this.scanInterceptorAndAddToInvokerMultimap(theInterceptor, this.myGlobalInvokers);
            if (addedInvokers.isEmpty()) {
                if (this.myWarnOnInterceptorWithNoHooks) {
                    ourLog.warn("Interceptor registered with no valid hooks - Type was: {}", (Object)theInterceptor.getClass().getName());
                }
                return false;
            }
            this.myInterceptors.add(theInterceptor);
            this.sortByOrderAnnotation(this.myInterceptors);
            this.rebuildRegisteredPointcutSet();
            return true;
        }
    }

    private void rebuildRegisteredPointcutSet() {
        EnumSet<POINTCUT> registeredPointcuts = EnumSet.noneOf(this.myPointcutType);
        registeredPointcuts.addAll(this.myAnonymousInvokers.keySet());
        registeredPointcuts.addAll(this.myGlobalInvokers.keySet());
        this.myRegisteredPointcuts = registeredPointcuts;
    }

    private boolean isInterceptorAlreadyRegistered(Object theInterceptor) {
        for (Object next : this.myInterceptors) {
            if (next != theInterceptor) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregisterInterceptor(Object theInterceptor) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            boolean removed = this.myInterceptors.removeIf(t -> t == theInterceptor);
            removed |= this.myGlobalInvokers.entries().removeIf(t -> ((BaseInvoker)t.getValue()).getInterceptor() == theInterceptor);
            this.rebuildRegisteredPointcutSet();
            return removed |= this.myAnonymousInvokers.entries().removeIf(t -> ((BaseInvoker)t.getValue()).getInterceptor() == theInterceptor);
        }
    }

    private void sortByOrderAnnotation(List<Object> theObjects) {
        IdentityHashMap<Object, Integer> interceptorToOrder = new IdentityHashMap<Object, Integer>();
        for (Object next : theObjects) {
            Interceptor orderAnnotation = next.getClass().getAnnotation(Interceptor.class);
            int order = orderAnnotation != null ? orderAnnotation.order() : 0;
            interceptorToOrder.put(next, order);
        }
        theObjects.sort((a, b) -> {
            Integer orderA = (Integer)interceptorToOrder.get(a);
            Integer orderB = (Integer)interceptorToOrder.get(b);
            return orderA - orderB;
        });
    }

    @Override
    public Object callHooksAndReturnObject(POINTCUT thePointcut, HookParams theParams) {
        assert (this.haveAppropriateParams(thePointcut, theParams));
        assert (((IPointcut)thePointcut).getReturnType() != Void.TYPE);
        return this.doCallHooks(thePointcut, theParams, null);
    }

    @Override
    public boolean hasHooks(POINTCUT thePointcut) {
        return this.myRegisteredPointcuts.contains(thePointcut);
    }

    protected Class<?> getBooleanReturnType() {
        return Boolean.TYPE;
    }

    @Override
    public boolean callHooks(POINTCUT thePointcut, HookParams theParams) {
        assert (this.haveAppropriateParams(thePointcut, theParams));
        assert (((IPointcut)thePointcut).getReturnType() == Void.TYPE || ((IPointcut)thePointcut).getReturnType() == this.getBooleanReturnType());
        Object retValObj = this.doCallHooks(thePointcut, theParams, true);
        return (Boolean)retValObj;
    }

    private Object doCallHooks(POINTCUT thePointcut, HookParams theParams, Object theRetVal) {
        ArrayList<BaseInvoker> invokers = new ArrayList<BaseInvoker>(this.getInvokersForPointcut(thePointcut));
        for (BaseInvoker nextInvoker : invokers) {
            Object nextOutcome = nextInvoker.invoke(theParams);
            Class<?> pointcutReturnType = ((IPointcut)thePointcut).getReturnType();
            if (pointcutReturnType.equals(this.getBooleanReturnType())) {
                Boolean nextOutcomeAsBoolean = (Boolean)nextOutcome;
                if (Boolean.FALSE.equals(nextOutcomeAsBoolean)) {
                    ourLog.trace("callHooks({}) for invoker({}) returned false", thePointcut, (Object)nextInvoker);
                    theRetVal = false;
                    break;
                }
                theRetVal = true;
                continue;
            }
            if (pointcutReturnType.equals(Void.TYPE) || nextOutcome == null) continue;
            theRetVal = nextOutcome;
            break;
        }
        return theRetVal;
    }

    @VisibleForTesting
    List<Object> getInterceptorsWithInvokersForPointcut(POINTCUT thePointcut) {
        return this.getInvokersForPointcut(thePointcut).stream().map(BaseInvoker::getInterceptor).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BaseInvoker> getInvokersForPointcut(POINTCUT thePointcut) {
        List<BaseInvoker> invokers;
        Object object = this.myRegistryMutex;
        synchronized (object) {
            List globalInvokers = this.myGlobalInvokers.get(thePointcut);
            List anonymousInvokers = this.myAnonymousInvokers.get(thePointcut);
            Object threadLocalInvokers = null;
            invokers = this.union(globalInvokers, anonymousInvokers, threadLocalInvokers);
        }
        return invokers;
    }

    @SafeVarargs
    private List<BaseInvoker> union(List<BaseInvoker> ... theInvokersLists) {
        List<BaseInvoker> retVal;
        List<BaseInvoker> haveOne = null;
        boolean haveMultiple = false;
        for (List<BaseInvoker> nextInvokerList : theInvokersLists) {
            if (nextInvokerList == null || nextInvokerList.isEmpty()) continue;
            if (haveOne == null) {
                haveOne = nextInvokerList;
                continue;
            }
            haveMultiple = true;
        }
        if (haveOne == null) {
            return Collections.emptyList();
        }
        if (!haveMultiple) {
            if (haveOne == theInvokersLists[0]) {
                retVal = haveOne;
            } else {
                retVal = new ArrayList<BaseInvoker>(haveOne);
                retVal.sort(Comparator.naturalOrder());
            }
        } else {
            retVal = Arrays.stream(theInvokersLists).filter(Objects::nonNull).flatMap(Collection::stream).sorted().collect(Collectors.toList());
        }
        return retVal;
    }

    final boolean haveAppropriateParams(POINTCUT thePointcut, HookParams theParams) {
        if (theParams.getParamsForType().values().size() != ((IPointcut)thePointcut).getParameterTypes().size()) {
            throw new IllegalArgumentException(Msg.code(1909) + String.format("Wrong number of params for pointcut %s - Wanted %s but found %s", ((Enum)thePointcut).name(), BaseInterceptorService.toErrorString(((IPointcut)thePointcut).getParameterTypes()), theParams.getParamsForType().values().stream().map(t -> t != null ? t.getClass().getSimpleName() : "null").sorted().collect(Collectors.toList())));
        }
        ArrayList<String> wantedTypes = new ArrayList<String>(((IPointcut)thePointcut).getParameterTypes());
        ListMultimap<Class<?>, Object> givenTypes = theParams.getParamsForType();
        for (Class nextTypeClass : givenTypes.keySet()) {
            String nextTypeName = nextTypeClass.getName();
            for (Object nextParamValue : givenTypes.get((Object)nextTypeClass)) {
                Validate.isTrue((nextParamValue == null || nextTypeClass.isAssignableFrom(nextParamValue.getClass()) ? 1 : 0) != 0, (String)"Invalid params for pointcut %s - %s is not of type %s", (Object[])new Object[]{((Enum)thePointcut).name(), nextParamValue != null ? nextParamValue.getClass() : "null", nextTypeClass});
                Validate.isTrue((boolean)wantedTypes.remove(nextTypeName), (String)"Invalid params for pointcut %s - Wanted %s but found %s", (Object[])new Object[]{((Enum)thePointcut).name(), BaseInterceptorService.toErrorString(((IPointcut)thePointcut).getParameterTypes()), nextTypeName});
            }
        }
        return true;
    }

    private List<HookInvoker> scanInterceptorAndAddToInvokerMultimap(Object theInterceptor, ListMultimap<POINTCUT, BaseInvoker> theInvokers) {
        Class<?> interceptorClass = theInterceptor.getClass();
        int typeOrder = BaseInterceptorService.determineOrder(interceptorClass);
        List<HookInvoker> addedInvokers = this.scanInterceptorForHookMethods(theInterceptor, typeOrder);
        addedInvokers.stream().filter(t -> Pointcut.INTERCEPTOR_REGISTERED.equals(t.getPointcut())).forEach(t -> t.invoke(new HookParams()));
        for (HookInvoker nextAddedHook : addedInvokers) {
            Object nextPointcut = nextAddedHook.getPointcut();
            if (((Enum)nextPointcut).equals(Pointcut.INTERCEPTOR_REGISTERED)) continue;
            theInvokers.put(nextPointcut, (Object)nextAddedHook);
        }
        for (Enum nextPointcut : theInvokers.keys()) {
            List nextInvokerList = theInvokers.get((Object)nextPointcut);
            nextInvokerList.sort(Comparator.naturalOrder());
        }
        return addedInvokers;
    }

    private List<HookInvoker> scanInterceptorForHookMethods(Object theInterceptor, int theTypeOrder) {
        ArrayList<HookInvoker> retVal = new ArrayList<HookInvoker>();
        for (Method nextMethod : ReflectionUtil.getDeclaredMethods(theInterceptor.getClass(), true)) {
            Optional<HookDescriptor> hook = this.scanForHook(nextMethod);
            if (!hook.isPresent()) continue;
            int methodOrder = theTypeOrder;
            int methodOrderAnnotation = hook.get().getOrder();
            if (methodOrderAnnotation != 0) {
                methodOrder = methodOrderAnnotation;
            }
            retVal.add(new HookInvoker(hook.get(), theInterceptor, nextMethod, methodOrder));
        }
        return retVal;
    }

    protected abstract Optional<HookDescriptor> scanForHook(Method var1);

    protected static <T extends Annotation> Optional<T> findAnnotation(AnnotatedElement theObject, Class<T> theHookClass) {
        Object annotation = theObject instanceof Method ? MethodUtils.getAnnotation((Method)((Method)theObject), theHookClass, (boolean)true, (boolean)true) : theObject.getAnnotation(theHookClass);
        return Optional.ofNullable(annotation);
    }

    private static int determineOrder(Class<?> theInterceptorClass) {
        return BaseInterceptorService.findAnnotation(theInterceptorClass, Interceptor.class).map(Interceptor::order).orElse(0);
    }

    private static String toErrorString(List<String> theParameterTypes) {
        return theParameterTypes.stream().sorted().collect(Collectors.joining(","));
    }

    protected static abstract class BaseInvoker
    implements Comparable<BaseInvoker> {
        private final int myOrder;
        private final Object myInterceptor;

        BaseInvoker(Object theInterceptor, int theOrder) {
            this.myInterceptor = theInterceptor;
            this.myOrder = theOrder;
        }

        public Object getInterceptor() {
            return this.myInterceptor;
        }

        abstract Object invoke(HookParams var1);

        @Override
        public int compareTo(BaseInvoker theInvoker) {
            return this.myOrder - theInvoker.myOrder;
        }
    }

    private class HookInvoker
    extends BaseInvoker {
        private final Method myMethod;
        private final Class<?>[] myParameterTypes;
        private final int[] myParameterIndexes;
        private final POINTCUT myPointcut;

        private HookInvoker(@Nonnull HookDescriptor theHook, @Nonnull Object theInterceptor, Method theHookMethod, int theOrder) {
            super(theInterceptor, theOrder);
            this.myPointcut = theHook.getPointcut();
            this.myParameterTypes = theHookMethod.getParameterTypes();
            this.myMethod = theHookMethod;
            Class<?> returnType = theHookMethod.getReturnType();
            if (((IPointcut)this.myPointcut).getReturnType().equals(BaseInterceptorService.this.getBooleanReturnType())) {
                Validate.isTrue((BaseInterceptorService.this.getBooleanReturnType().equals(returnType) || Void.TYPE.equals(returnType) ? 1 : 0) != 0, (String)"Method does not return boolean or void: %s", (Object[])new Object[]{theHookMethod});
            } else if (((IPointcut)this.myPointcut).getReturnType().equals(Void.TYPE)) {
                Validate.isTrue((boolean)Void.TYPE.equals(returnType), (String)"Method does not return void: %s", (Object[])new Object[]{theHookMethod});
            } else {
                Validate.isTrue((((IPointcut)this.myPointcut).getReturnType().isAssignableFrom(returnType) || Void.TYPE.equals(returnType) ? 1 : 0) != 0, (String)"Method does not return %s or void: %s", (Object[])new Object[]{((IPointcut)this.myPointcut).getReturnType(), theHookMethod});
            }
            this.myParameterIndexes = new int[this.myParameterTypes.length];
            HashMap<Class, AtomicInteger> typeToCount = new HashMap<Class, AtomicInteger>();
            for (int i = 0; i < this.myParameterTypes.length; ++i) {
                AtomicInteger counter = typeToCount.computeIfAbsent(this.myParameterTypes[i], t -> new AtomicInteger(0));
                this.myParameterIndexes[i] = counter.getAndIncrement();
            }
            this.myMethod.setAccessible(true);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("method", (Object)this.myMethod).toString();
        }

        public POINTCUT getPointcut() {
            return this.myPointcut;
        }

        @Override
        Object invoke(HookParams theParams) {
            Object[] args = new Object[this.myParameterTypes.length];
            for (int i = 0; i < this.myParameterTypes.length; ++i) {
                Class<?> nextParamType = this.myParameterTypes[i];
                if (nextParamType.equals(Pointcut.class)) {
                    args[i] = this.myPointcut;
                    continue;
                }
                int nextParamIndex = this.myParameterIndexes[i];
                Object nextParamValue = theParams.get(nextParamType, nextParamIndex);
                args[i] = nextParamValue;
            }
            try {
                return this.myMethod.invoke(this.getInterceptor(), args);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (((IPointcut)this.myPointcut).isShouldLogAndSwallowException(targetException)) {
                    ourLog.error("Exception thrown by interceptor: " + targetException.toString(), targetException);
                    return null;
                }
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new InternalErrorException(Msg.code(1910) + "Failure invoking interceptor for pointcut(s) " + this.getPointcut(), targetException);
            }
            catch (Exception e) {
                throw new InternalErrorException(Msg.code(1911) + e);
            }
        }
    }

    protected class HookDescriptor {
        private final POINTCUT myPointcut;
        private final int myOrder;
        final /* synthetic */ BaseInterceptorService this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public HookDescriptor(POINTCUT thePointcut, int theOrder) {
            this.this$0 = (BaseInterceptorService)this$0;
            this.myPointcut = thePointcut;
            this.myOrder = theOrder;
        }

        POINTCUT getPointcut() {
            return this.myPointcut;
        }

        int getOrder() {
            return this.myOrder;
        }
    }
}

