/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BaseElement;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.CoverageIgnore;

public abstract class BaseIdentifiableElement
extends BaseElement
implements IIdentifiableElement {
    private static final long serialVersionUID = -7816838417076777914L;
    private String myElementSpecificId;

    @Override
    public String getElementSpecificId() {
        return this.myElementSpecificId;
    }

    @Override
    @Deprecated
    @CoverageIgnore
    public IdDt getId() {
        if (this.myElementSpecificId == null) {
            return new LockedId();
        }
        return new LockedId(this.myElementSpecificId);
    }

    @Override
    public void setElementSpecificId(String theElementSpecificId) {
        this.myElementSpecificId = theElementSpecificId;
    }

    @Override
    @Deprecated
    @CoverageIgnore
    public void setId(IdDt theId) {
        this.myElementSpecificId = theId == null ? null : theId.getValue();
    }

    @Override
    @Deprecated
    @CoverageIgnore
    public void setId(String theId) {
        this.myElementSpecificId = theId;
    }

    @CoverageIgnore
    private static class LockedId
    extends IdDt {
        @CoverageIgnore
        public LockedId() {
        }

        @CoverageIgnore
        public LockedId(String theElementSpecificId) {
            super(theElementSpecificId);
        }

        @Override
        @CoverageIgnore
        public IdDt setValue(String theValue) throws DataFormatException {
            throw new UnsupportedOperationException(Msg.code(1899) + "Use IElement#setElementSpecificId(String) to set the element ID for an element");
        }

        @Override
        @CoverageIgnore
        public void setValueAsString(String theValue) throws DataFormatException {
            throw new UnsupportedOperationException(Msg.code(1900) + "Use IElement#setElementSpecificId(String) to set the element ID for an element");
        }
    }
}

