/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class ResourceMetadataKeyEnum<T>
implements Serializable {
    public static final ResourceMetadataKeyEnum<IPrimitiveType<Date>> DELETED_AT = new ResourceMetadataKeyEnum<IPrimitiveType<Date>>("DELETED_AT", IPrimitiveType.class){};
    public static final ResourceMetadataKeyEnum<BundleEntrySearchModeEnum> ENTRY_SEARCH_MODE = new ResourceMetadataKeyEnum<BundleEntrySearchModeEnum>("ENTRY_SEARCH_MODE", BundleEntrySearchModeEnum.class){};
    public static final ResourceMetadataKeyEnum<BundleEntryTransactionMethodEnum> ENTRY_TRANSACTION_METHOD = new ResourceMetadataKeyEnum<BundleEntryTransactionMethodEnum>("ENTRY_TRANSACTION_OPERATION", BundleEntryTransactionMethodEnum.class){};
    public static final ResourceMetadataKeyEnum<List<IdDt>> PROFILES = new ResourceMetadataKeyEnum<List<IdDt>>("PROFILES", List.class){};
    public static final ResourceMetadataKeyEnum<InstantDt> PUBLISHED = new ResourceMetadataKeyEnum<InstantDt>("PUBLISHED", InstantDt.class){};
    public static final ResourceMetadataKeyEnum<List<BaseCodingDt>> SECURITY_LABELS = new ResourceMetadataKeyEnum<List<BaseCodingDt>>("SECURITY_LABELS", List.class){};
    public static final ResourceMetadataKeyEnum<TagList> TAG_LIST = new ResourceMetadataKeyEnum<TagList>("TAG_LIST", TagList.class){};
    public static final ResourceMetadataKeyEnum<InstantDt> UPDATED = new ResourceMetadataKeyEnum<InstantDt>("UPDATED", InstantDt.class){};
    @Deprecated
    public static final ResourceMetadataKeyEnum<String> VERSION = new ResourceMetadataKeyEnum<String>("VERSION", String.class){};
    @Deprecated
    public static final ResourceMetadataKeyEnum<IdDt> VERSION_ID = new ResourceMetadataKeyEnum<IdDt>("VERSION_ID", IdDt.class){};
    private static final long serialVersionUID = 1L;
    private final String myValue;
    private final Class<?> myType;

    public ResourceMetadataKeyEnum(String theValue, Class<?> theType) {
        this.myValue = theValue;
        this.myType = theType;
    }

    public T get(IBaseResource theResource) {
        Object retVal = theResource instanceof IAnyResource ? theResource.getUserData(this.name()) : ((IResource)theResource).getResourceMetadata().get(this);
        if (retVal != null && !this.myType.isAssignableFrom(retVal.getClass())) {
            throw new InternalErrorException(Msg.code(1890) + "Found an object of type '" + retVal.getClass().getCanonicalName() + "' in resource metadata for key " + this.name() + " - Expected " + this.myType.getCanonicalName());
        }
        return (T)retVal;
    }

    public void put(IBaseResource theResource, T theValue) {
        if (theValue != null && !this.myType.isAssignableFrom(theValue.getClass())) {
            throw new InternalErrorException(Msg.code(1891) + "Can not put object of type '" + theValue.getClass().getCanonicalName() + "' in resource metadata for key " + this.name() + " - Expected " + this.myType.getCanonicalName());
        }
        if (theResource instanceof IAnyResource) {
            theResource.setUserData(this.name(), theValue);
        } else {
            ((IResource)theResource).getResourceMetadata().put(this, theValue);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetadataKeyEnum other = (ResourceMetadataKeyEnum)obj;
        if (this.myValue == null) {
            return other.myValue == null;
        }
        return this.myValue.equals(other.myValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public String name() {
        return this.myValue;
    }

    public static final class ExtensionResourceMetadataKey
    extends ResourceMetadataKeyEnum<ExtensionDt> {
        public ExtensionResourceMetadataKey(String theUrl) {
            super(theUrl, ExtensionDt.class);
        }
    }
}

