/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.InternalCodingDt;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseCoding;

public class TokenParam
extends BaseParam {
    private TokenParamModifier myModifier;
    private String mySystem;
    private String myValue;
    private Boolean myMdmExpand;

    public TokenParam() {
    }

    public TokenParam(BaseCodingDt theCodingDt) {
        this(TokenParam.toSystemValue(theCodingDt.getSystemElement()), (String)theCodingDt.getCodeElement().getValue());
    }

    public TokenParam(BaseIdentifierDt theIdentifierDt) {
        this(TokenParam.toSystemValue(theIdentifierDt.getSystemElement()), (String)theIdentifierDt.getValueElement().getValue());
    }

    public TokenParam(IBaseCoding theCoding) {
        this(theCoding.getSystem(), theCoding.getCode());
    }

    public TokenParam(String theSystem, String theValue) {
        this.setSystem(theSystem);
        this.setValue(theValue);
    }

    public TokenParam(String theSystem, String theValue, boolean theText) {
        if (theText && StringUtils.isNotBlank((CharSequence)theSystem)) {
            throw new IllegalArgumentException(Msg.code(1938) + "theSystem can not be non-blank if theText is true (:text searches do not include a system). In other words, set the first parameter to null for a text search");
        }
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.setText(theText);
    }

    public TokenParam(String theCode) {
        this(null, theCode);
    }

    public boolean isMdmExpand() {
        return this.myMdmExpand != null && this.myMdmExpand != false;
    }

    public TokenParam setMdmExpand(boolean theMdmExpand) {
        this.myMdmExpand = theMdmExpand;
        return this;
    }

    @Override
    String doGetQueryParameterQualifier() {
        if (this.getModifier() != null) {
            return this.getModifier().getValue();
        }
        return null;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        if (this.getSystem() != null) {
            if (this.getValue() != null) {
                return ParameterUtil.escape(StringUtils.defaultString((String)this.getSystem())) + "|" + ParameterUtil.escape(this.getValue());
            }
            return ParameterUtil.escape(StringUtils.defaultString((String)this.getSystem())) + "|";
        }
        return ParameterUtil.escape(this.getValue());
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theParameter) {
        this.setModifier(null);
        if (theQualifier != null) {
            TokenParamModifier modifier = TokenParamModifier.forValue(theQualifier);
            this.setModifier(modifier);
            if (modifier == TokenParamModifier.TEXT) {
                this.setSystem(null);
                this.setValue(ParameterUtil.unescape(theParameter));
                return;
            }
        }
        this.setSystem(null);
        if (theParameter == null) {
            this.setValue(null);
        } else {
            int barIndex = ParameterUtil.nonEscapedIndexOf(theParameter, '|');
            if (barIndex != -1) {
                this.setSystem(theParameter.substring(0, barIndex));
                this.setValue(ParameterUtil.unescape(theParameter.substring(barIndex + 1)));
            } else {
                this.setValue(ParameterUtil.unescape(theParameter));
            }
        }
    }

    public TokenParamModifier getModifier() {
        return this.myModifier;
    }

    public TokenParam setModifier(TokenParamModifier theModifier) {
        this.myModifier = theModifier;
        return this;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public TokenParam setSystem(String theSystem) {
        this.mySystem = theSystem;
        return this;
    }

    public String getValue() {
        return this.myValue;
    }

    public TokenParam setValue(String theValue) {
        this.myValue = theValue;
        return this;
    }

    public InternalCodingDt getValueAsCoding() {
        return new InternalCodingDt(this.mySystem, this.myValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)this.myValue);
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.mySystem) && StringUtils.isBlank((CharSequence)this.myValue) && this.getMissing() == null;
    }

    public boolean isText() {
        return this.myModifier == TokenParamModifier.TEXT;
    }

    @Deprecated
    public TokenParam setText(boolean theText) {
        this.myModifier = theText ? TokenParamModifier.TEXT : null;
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("system", (Object)StringUtils.defaultString((String)this.getSystem()));
        if (this.myModifier != null) {
            builder.append((Object)(":" + this.myModifier.getValue()));
        }
        builder.append("value", (Object)this.getValue());
        if (this.getMissing() != null) {
            builder.append(":missing", (Object)this.getMissing());
        }
        return builder.toString();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        TokenParam that = (TokenParam)theO;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.myModifier, (Object)that.myModifier);
        b.append((Object)this.mySystem, (Object)that.mySystem);
        b.append((Object)this.myValue, (Object)that.myValue);
        return b.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder(17, 37);
        b.append((Object)this.myModifier);
        b.append((Object)this.mySystem);
        b.append((Object)this.myValue);
        return b.toHashCode();
    }

    private static String toSystemValue(UriDt theSystem) {
        return theSystem.getValueAsString();
    }
}

