/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.system;

public final class HapiSystemProperties {
    static final String SUPPRESS_HAPI_FHIR_VERSION_LOG = "suppress_hapi_fhir_version_log";
    static final String DISABLE_STATUS_BASED_REINDEX = "disable_status_based_reindex";
    static final String TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS = "TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS";
    static final String UNIT_TEST_CAPTURE_STACK = "unit_test_capture_stack";
    static final String STACKFILTER_PATTERN_PROP = "log.stackfilter.pattern";
    static final String HAPI_CLIENT_KEEPRESPONSES = "hapi.client.keepresponses";
    static final String TEST_MODE = "test";
    static final String UNIT_TEST_MODE = "unit_test_mode";
    static final long DEFAULT_TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS = 10000L;

    private HapiSystemProperties() {
    }

    public static void enableHapiClientKeepResponses() {
        System.setProperty(HAPI_CLIENT_KEEPRESPONSES, Boolean.TRUE.toString());
    }

    public static void disableHapiClientKeepResponses() {
        System.clearProperty(HAPI_CLIENT_KEEPRESPONSES);
    }

    public static boolean isHapiClientKeepResponsesEnabled() {
        return Boolean.parseBoolean(System.getProperty(HAPI_CLIENT_KEEPRESPONSES));
    }

    public static void setStackFilterPattern(String thePattern) {
        System.setProperty(STACKFILTER_PATTERN_PROP, thePattern);
    }

    public static void setTestValidationResourceCachesMs(long theMillis) {
        System.setProperty(TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS, "" + theMillis);
    }

    public static long getTestValidationResourceCachesMs() {
        String property = System.getProperty(TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS);
        if (property == null) {
            return 10000L;
        }
        return Long.parseLong(property);
    }

    public static void enableTestMode() {
        System.setProperty(TEST_MODE, Boolean.TRUE.toString());
    }

    public static boolean isTestModeEnabled() {
        return Boolean.parseBoolean(System.getProperty(TEST_MODE));
    }

    public static void enableUnitTestMode() {
        System.setProperty(UNIT_TEST_MODE, Boolean.TRUE.toString());
    }

    public static void disableUnitTestMode() {
        System.setProperty(UNIT_TEST_MODE, Boolean.FALSE.toString());
    }

    public static boolean isUnitTestModeEnabled() {
        return Boolean.parseBoolean(System.getProperty(UNIT_TEST_MODE));
    }

    public static void enableUnitTestCaptureStack() {
        System.setProperty(UNIT_TEST_CAPTURE_STACK, Boolean.TRUE.toString());
    }

    public static void disableUnitTestCaptureStack() {
        System.clearProperty(UNIT_TEST_CAPTURE_STACK);
    }

    public static boolean isUnitTestCaptureStackEnabled() {
        return Boolean.parseBoolean(System.getProperty(UNIT_TEST_CAPTURE_STACK));
    }

    public static boolean isDisableStatusBasedReindex() {
        return Boolean.parseBoolean(System.getProperty(DISABLE_STATUS_BASED_REINDEX));
    }

    public static void disableStatusBasedReindex() {
        System.setProperty(DISABLE_STATUS_BASED_REINDEX, Boolean.TRUE.toString());
    }

    public static void enableStatusBasedReindex() {
        System.clearProperty(DISABLE_STATUS_BASED_REINDEX);
    }

    public static void enableSuppressHapiFhirVersionLog() {
        System.setProperty(SUPPRESS_HAPI_FHIR_VERSION_LOG, Boolean.TRUE.toString());
    }

    public static boolean isSuppressHapiFhirVersionLogEnabled() {
        return Boolean.parseBoolean(System.getProperty(SUPPRESS_HAPI_FHIR_VERSION_LOG));
    }
}

