/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import org.apache.commons.lang3.StringUtils;

@DatatypeDef(name="string")
public class StringDt
extends BasePrimitive<String>
implements IQueryParameterType {
    public StringDt() {
    }

    @SimpleSetter
    public StringDt(@SimpleSetter.Parameter(name="theString") String theValue) {
        this.setValue(theValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)((String)this.getValue()));
    }

    @Override
    public String toString() {
        return (String)this.getValue();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getValue() == null ? 0 : ((String)this.getValue()).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringDt other = (StringDt)obj;
        return !(this.getValue() == null ? other.getValue() != null : !((String)this.getValue()).equals(other.getValue()));
    }

    @Override
    public void setValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        this.setValue(theValue);
    }

    @Override
    public String getValueAsQueryToken(FhirContext theContext) {
        return (String)this.getValue();
    }

    @Override
    public boolean isEmpty() {
        boolean retVal = super.isBaseEmpty() && StringUtils.isBlank((CharSequence)((CharSequence)this.getValue()));
        return retVal;
    }

    @Override
    public String getQueryParameterQualifier() {
        return null;
    }

    @Override
    protected String parse(String theValue) {
        return theValue;
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    @Override
    @Deprecated
    public Boolean getMissing() {
        return null;
    }

    @Override
    @Deprecated
    public IQueryParameterType setMissing(Boolean theMissing) {
        throw new UnsupportedOperationException(Msg.code(1874) + "get/setMissing is not supported in StringDt. Use {@link StringParam} instead if you need this functionality");
    }
}

