/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.StringCriterion;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;

public class ReferenceClientParam
extends BaseClientParam
implements IParam {
    private String myName;

    public ReferenceClientParam(String theName) {
        this.myName = theName;
    }

    @Override
    public String getParamName() {
        return this.myName;
    }

    public ICriterion<ReferenceClientParam> hasChainedProperty(ICriterion<?> theCriterion) {
        return new ReferenceChainCriterion(this.getParamName(), theCriterion);
    }

    public ICriterion<ReferenceClientParam> hasChainedProperty(String theResourceType, ICriterion<?> theCriterion) {
        return new ReferenceChainCriterion(this.getParamName(), theResourceType, theCriterion);
    }

    public ICriterion<ReferenceClientParam> hasId(IIdType theId) {
        return new StringCriterion<ReferenceClientParam>(this.getParamName(), theId.getValue());
    }

    public ICriterion<ReferenceClientParam> hasId(String theId) {
        return new StringCriterion<ReferenceClientParam>(this.getParamName(), theId);
    }

    public ICriterion<ReferenceClientParam> hasAnyOfIds(Collection<String> theIds) {
        return new StringCriterion<ReferenceClientParam>(this.getParamName(), theIds);
    }

    public ICriterion<ReferenceClientParam> hasAnyOfIds(String ... theIds) {
        Validate.notNull((Object)theIds, (String)"theIds must not be null", (Object[])new Object[0]);
        return this.hasAnyOfIds(Arrays.asList(theIds));
    }

    private static class ReferenceChainCriterion
    implements ICriterion<ReferenceClientParam>,
    ICriterionInternal {
        private final String myResourceTypeQualifier;
        private String myParamName;
        private ICriterionInternal myWrappedCriterion;

        ReferenceChainCriterion(String theParamName, ICriterion<?> theWrappedCriterion) {
            this(theParamName, null, theWrappedCriterion);
        }

        ReferenceChainCriterion(String theParamName, String theResourceType, ICriterion<?> theWrappedCriterion) {
            this.myParamName = theParamName;
            this.myResourceTypeQualifier = StringUtils.isNotBlank((CharSequence)theResourceType) ? ":" + theResourceType : "";
            this.myWrappedCriterion = (ICriterionInternal)((Object)theWrappedCriterion);
        }

        @Override
        public String getParameterName() {
            return this.myParamName + this.myResourceTypeQualifier + "." + this.myWrappedCriterion.getParameterName();
        }

        @Override
        public String getParameterValue(FhirContext theContext) {
            return this.myWrappedCriterion.getParameterValue(theContext);
        }
    }
}

