/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.bundle;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ParametersUtil;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BundleEntryMutator {
    private final IBase myEntry;
    private final BaseRuntimeChildDefinition myRequestChildDef;
    private final BaseRuntimeElementCompositeDefinition<?> myRequestChildContentsDef;
    private final FhirContext myFhirContext;
    private final BaseRuntimeElementCompositeDefinition<?> myEntryDefinition;

    public BundleEntryMutator(FhirContext theFhirContext, IBase theEntry, BaseRuntimeChildDefinition theRequestChildDef, BaseRuntimeElementCompositeDefinition<?> theChildContentsDef, BaseRuntimeElementCompositeDefinition<?> theEntryDefinition) {
        this.myFhirContext = theFhirContext;
        this.myEntry = theEntry;
        this.myRequestChildDef = theRequestChildDef;
        this.myRequestChildContentsDef = theChildContentsDef;
        this.myEntryDefinition = theEntryDefinition;
    }

    void setRequestUrl(FhirContext theFhirContext, String theRequestUrl) {
        BaseRuntimeChildDefinition requestUrlChildDef = this.myRequestChildContentsDef.getChildByName("url");
        IPrimitiveType<?> url = ParametersUtil.createUri(theFhirContext, theRequestUrl);
        for (IBase nextRequest : this.myRequestChildDef.getAccessor().getValues(this.myEntry)) {
            requestUrlChildDef.getMutator().addValue(nextRequest, url);
        }
    }

    public void setFullUrl(String theFullUrl) {
        IPrimitiveType value = (IPrimitiveType)this.myFhirContext.getElementDefinition("uri").newInstance();
        value.setValue(theFullUrl);
        BaseRuntimeChildDefinition fullUrlChild = this.myEntryDefinition.getChildByName("fullUrl");
        fullUrlChild.getMutator().setValue(this.myEntry, value);
    }

    public void setResource(IBaseResource theUpdatedResource) {
        BaseRuntimeChildDefinition resourceChild = this.myEntryDefinition.getChildByName("resource");
        resourceChild.getMutator().setValue(this.myEntry, theUpdatedResource);
    }
}

