/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.json.jackson;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.json.BaseJsonLikeArray;
import ca.uhn.fhir.parser.json.BaseJsonLikeObject;
import ca.uhn.fhir.parser.json.BaseJsonLikeValue;
import ca.uhn.fhir.parser.json.BaseJsonLikeWriter;
import ca.uhn.fhir.parser.json.JsonLikeStructure;
import ca.uhn.fhir.parser.json.jackson.JacksonWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JacksonStructure
implements JsonLikeStructure {
    private static final ObjectMapper OBJECT_MAPPER = JacksonStructure.createObjectMapper();
    private JacksonWriter jacksonWriter;
    private ROOT_TYPE rootType = null;
    private JsonNode nativeRoot = null;
    private JsonNode jsonLikeRoot = null;

    public void setNativeObject(ObjectNode objectNode) {
        this.rootType = ROOT_TYPE.OBJECT;
        this.nativeRoot = objectNode;
    }

    public void setNativeArray(ArrayNode arrayNode) {
        this.rootType = ROOT_TYPE.ARRAY;
        this.nativeRoot = arrayNode;
    }

    @Override
    public JsonLikeStructure getInstance() {
        return new JacksonStructure();
    }

    @Override
    public void load(Reader theReader) throws DataFormatException {
        this.load(theReader, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(Reader theReader, boolean allowArray) throws DataFormatException {
        PushbackReader pbr = new PushbackReader(theReader);
        try {
            int nextInt;
            block9: {
                do {
                    if ((nextInt = pbr.read()) == -1) {
                        throw new DataFormatException(Msg.code(1857) + "Did not find any content to parse");
                    }
                    if (nextInt != 123) continue;
                    pbr.unread(nextInt);
                    break block9;
                } while (Character.isWhitespace(nextInt));
                if (!allowArray) throw new DataFormatException(Msg.code(1859) + "Content does not appear to be FHIR JSON, first non-whitespace character was: '" + (char)nextInt + "' (must be '{')");
                if (nextInt != 91) throw new DataFormatException(Msg.code(1858) + "Content does not appear to be FHIR JSON, first non-whitespace character was: '" + (char)nextInt + "' (must be '{' or '[')");
                pbr.unread(nextInt);
            }
            if (nextInt == 123) {
                this.setNativeObject((ObjectNode)OBJECT_MAPPER.readTree((Reader)pbr));
                return;
            } else {
                this.setNativeArray((ArrayNode)OBJECT_MAPPER.readTree((Reader)pbr));
            }
            return;
        }
        catch (Exception e) {
            String message;
            if (e instanceof JsonProcessingException) {
                JsonProcessingException jpe = (JsonProcessingException)e;
                StringBuilder messageBuilder = new StringBuilder();
                String originalMessage = jpe.getOriginalMessage();
                originalMessage = originalMessage.replace("Source: REDACTED (`StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION` disabled); ", "");
                messageBuilder.append(originalMessage);
                if (jpe.getLocation() != null) {
                    messageBuilder.append("\n at [");
                    jpe.getLocation().appendOffsetDescription(messageBuilder);
                    messageBuilder.append("]");
                }
                message = messageBuilder.toString();
            } else {
                message = e.getMessage();
            }
            if (!message.startsWith("Unexpected char 39")) throw new DataFormatException(Msg.code(1861) + "Failed to parse JSON encoded FHIR content: " + message, e);
            throw new DataFormatException(Msg.code(1860) + "Failed to parse JSON encoded FHIR content: " + message + " - This may indicate that single quotes are being used as JSON escapes where double quotes are required", e);
        }
    }

    @Override
    public BaseJsonLikeWriter getJsonLikeWriter(Writer writer) throws IOException {
        if (null == this.jacksonWriter) {
            this.jacksonWriter = new JacksonWriter(OBJECT_MAPPER.getFactory(), writer);
        }
        return this.jacksonWriter;
    }

    @Override
    public BaseJsonLikeWriter getJsonLikeWriter() {
        if (null == this.jacksonWriter) {
            this.jacksonWriter = new JacksonWriter();
        }
        return this.jacksonWriter;
    }

    @Override
    public BaseJsonLikeObject getRootObject() throws DataFormatException {
        if (this.rootType == ROOT_TYPE.OBJECT) {
            if (null == this.jsonLikeRoot) {
                this.jsonLikeRoot = this.nativeRoot;
            }
            return new JacksonJsonObject((ObjectNode)this.jsonLikeRoot);
        }
        throw new DataFormatException(Msg.code(1862) + "Content must be a valid JSON Object. It must start with '{'.");
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper retVal = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS}).build();
        retVal = retVal.setNodeFactory(new JsonNodeFactory(true));
        retVal = retVal.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        retVal = retVal.enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
        retVal = retVal.disable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
        retVal = retVal.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        retVal = retVal.disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE});
        retVal = retVal.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        retVal.getFactory().setStreamReadConstraints(JacksonStructure.createStreamReadConstraints());
        return retVal;
    }

    private static StreamReadConstraints createStreamReadConstraints() {
        return StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build();
    }

    private static enum ROOT_TYPE {
        OBJECT,
        ARRAY;

    }

    private static class JacksonJsonObject
    extends BaseJsonLikeObject {
        private final ObjectNode nativeObject;

        public JacksonJsonObject(ObjectNode json) {
            this.nativeObject = json;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Iterator<String> keyIterator() {
            return this.nativeObject.fieldNames();
        }

        @Override
        public BaseJsonLikeValue get(String key) {
            JsonNode child = this.nativeObject.get(key);
            if (child != null) {
                return new JacksonJsonValue(child);
            }
            return null;
        }
    }

    private static class JacksonJsonValue
    extends BaseJsonLikeValue {
        private final JsonNode nativeValue;
        private BaseJsonLikeObject jsonLikeObject = null;
        private BaseJsonLikeArray jsonLikeArray = null;

        public JacksonJsonValue(JsonNode jsonNode) {
            this.nativeValue = jsonNode;
        }

        @Override
        public Object getValue() {
            if (this.nativeValue != null && this.nativeValue.isValueNode()) {
                if (this.nativeValue.isNumber()) {
                    return this.nativeValue.numberValue();
                }
                if (this.nativeValue.isBoolean()) {
                    return this.nativeValue.booleanValue();
                }
                return this.nativeValue.asText();
            }
            return null;
        }

        @Override
        public BaseJsonLikeValue.ValueType getJsonType() {
            if (null == this.nativeValue) {
                return BaseJsonLikeValue.ValueType.NULL;
            }
            switch (this.nativeValue.getNodeType()) {
                case NULL: 
                case MISSING: {
                    return BaseJsonLikeValue.ValueType.NULL;
                }
                case OBJECT: {
                    return BaseJsonLikeValue.ValueType.OBJECT;
                }
                case ARRAY: {
                    return BaseJsonLikeValue.ValueType.ARRAY;
                }
            }
            return BaseJsonLikeValue.ValueType.SCALAR;
        }

        @Override
        public BaseJsonLikeValue.ScalarType getDataType() {
            if (this.nativeValue != null && this.nativeValue.isValueNode()) {
                if (this.nativeValue.isNumber()) {
                    return BaseJsonLikeValue.ScalarType.NUMBER;
                }
                if (this.nativeValue.isTextual()) {
                    return BaseJsonLikeValue.ScalarType.STRING;
                }
                if (this.nativeValue.isBoolean()) {
                    return BaseJsonLikeValue.ScalarType.BOOLEAN;
                }
            }
            return null;
        }

        @Override
        public BaseJsonLikeArray getAsArray() {
            if (this.nativeValue != null && this.nativeValue.isArray() && null == this.jsonLikeArray) {
                this.jsonLikeArray = new JacksonJsonArray((ArrayNode)this.nativeValue);
            }
            return this.jsonLikeArray;
        }

        @Override
        public BaseJsonLikeObject getAsObject() {
            if (this.nativeValue != null && this.nativeValue.isObject() && null == this.jsonLikeObject) {
                this.jsonLikeObject = new JacksonJsonObject((ObjectNode)this.nativeValue);
            }
            return this.jsonLikeObject;
        }

        @Override
        public Number getAsNumber() {
            return this.nativeValue != null ? (Number)this.nativeValue.numberValue() : (Number)null;
        }

        @Override
        public String getAsString() {
            if (this.nativeValue != null) {
                if (this.nativeValue instanceof DecimalNode) {
                    BigDecimal value = this.nativeValue.decimalValue();
                    return value.toPlainString();
                }
                return this.nativeValue.asText();
            }
            return null;
        }

        @Override
        public boolean getAsBoolean() {
            if (this.nativeValue != null && this.nativeValue.isValueNode() && this.nativeValue.isBoolean()) {
                return this.nativeValue.asBoolean();
            }
            return super.getAsBoolean();
        }
    }

    private static class JacksonJsonArray
    extends BaseJsonLikeArray {
        private final ArrayNode nativeArray;
        private final Map<Integer, BaseJsonLikeValue> jsonLikeMap = new LinkedHashMap<Integer, BaseJsonLikeValue>();

        public JacksonJsonArray(ArrayNode json) {
            this.nativeArray = json;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public int size() {
            return this.nativeArray.size();
        }

        @Override
        public BaseJsonLikeValue get(int index) {
            Integer key = index;
            BaseJsonLikeValue result = null;
            if (this.jsonLikeMap.containsKey(key)) {
                result = this.jsonLikeMap.get(key);
            } else {
                JsonNode child = this.nativeArray.get(index);
                if (child != null) {
                    result = new JacksonJsonValue(child);
                }
                this.jsonLikeMap.put(key, result);
            }
            return result;
        }
    }

    private static class EntryOrderedSet<T>
    extends AbstractSet<T> {
        private final transient ArrayList<T> data = new ArrayList();

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.data.contains(o);
        }

        public T get(int index) {
            return this.data.get(index);
        }

        @Override
        public boolean add(T element) {
            if (this.data.contains(element)) {
                return false;
            }
            return this.data.add(element);
        }

        @Override
        public boolean remove(Object o) {
            return this.data.remove(o);
        }

        @Override
        public void clear() {
            this.data.clear();
        }

        @Override
        public Iterator<T> iterator() {
            return this.data.iterator();
        }
    }
}

