/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class UrlPathTokenizer {
    private String[] tokens;
    private int curPos;

    public UrlPathTokenizer(String theRequestPath) {
        if (theRequestPath == null) {
            theRequestPath = "";
        }
        this.tokens = UrlPathTokenizer.removeBlanksAndSanitize(theRequestPath.split("/"));
        this.curPos = 0;
    }

    public boolean hasMoreTokens() {
        return this.curPos < this.tokens.length;
    }

    public int countTokens() {
        return this.tokens.length;
    }

    public String peek() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException(Msg.code(2420) + "Attempt to retrieve URL token out of bounds");
        }
        return this.tokens[this.curPos];
    }

    public String nextTokenUnescapedAndSanitized() {
        String token = this.peek();
        ++this.curPos;
        return token;
    }

    private static String[] removeBlanksAndSanitize(String[] theInput) {
        ArrayList<String> output = new ArrayList<String>();
        for (String s : theInput) {
            if (StringUtils.isBlank((CharSequence)s)) continue;
            output.add(UrlUtil.sanitizeUrlPart(UrlUtil.unescape(s)));
        }
        return output.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }
}

