/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.jar.DependencyLogFactory;
import ca.uhn.fhir.util.jar.IDependencyLog;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.codehaus.stax2.io.EscapingWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(XmlUtil.class);
    private static final Map<String, Integer> VALID_ENTITY_NAMES;
    private static final ExtendedEntityReplacingXmlResolver XML_RESOLVER;
    private static XMLOutputFactory ourFragmentOutputFactory;
    private static volatile boolean ourHaveLoggedStaxImplementation;
    private static volatile XMLInputFactory ourInputFactory;
    private static Throwable ourNextException;
    private static volatile XMLOutputFactory ourOutputFactory;

    private XmlUtil() {
    }

    private static XMLOutputFactory createOutputFactory() throws FactoryConfigurationError {
        try {
            Class.forName("ca.uhn.fhir.repackage.javax.xml.stream.XMLOutputFactory");
            System.setProperty(XMLOutputFactory.class.getName(), WstxOutputFactory.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        XMLOutputFactory outputFactory = XmlUtil.newOutputFactory();
        if (!ourHaveLoggedStaxImplementation) {
            XmlUtil.logStaxImplementation(outputFactory.getClass());
        }
        try {
            Class.forName("com.ctc.wstx.stax.WstxOutputFactory");
            if (outputFactory instanceof WstxOutputFactory) {
                outputFactory.setProperty("org.codehaus.stax2.textEscaper", new MyEscaper());
            }
        }
        catch (ClassNotFoundException e) {
            ourLog.debug("WstxOutputFactory (Woodstox) not found on classpath");
        }
        return outputFactory;
    }

    private static XMLEventWriter createXmlFragmentWriter(Writer theWriter) throws FactoryConfigurationError, XMLStreamException {
        XMLOutputFactory outputFactory = XmlUtil.getOrCreateFragmentOutputFactory();
        return outputFactory.createXMLEventWriter(theWriter);
    }

    public static XMLEventReader createXmlReader(Reader reader) throws FactoryConfigurationError, XMLStreamException {
        XmlUtil.throwUnitTestExceptionIfConfiguredToDoSo();
        XMLInputFactory inputFactory = XmlUtil.getOrCreateInputFactory();
        return inputFactory.createXMLEventReader(reader);
    }

    public static XMLStreamWriter createXmlStreamWriter(Writer theWriter) throws FactoryConfigurationError, XMLStreamException {
        XmlUtil.throwUnitTestExceptionIfConfiguredToDoSo();
        XMLOutputFactory outputFactory = XmlUtil.getOrCreateOutputFactory();
        return outputFactory.createXMLStreamWriter(theWriter);
    }

    public static XMLEventWriter createXmlWriter(Writer theWriter) throws FactoryConfigurationError, XMLStreamException {
        XMLOutputFactory outputFactory = XmlUtil.getOrCreateOutputFactory();
        return outputFactory.createXMLEventWriter(theWriter);
    }

    public static String encode(List<XMLEvent> theEvents) {
        try {
            StringWriter w = new StringWriter();
            XMLEventWriter ew = XmlUtil.createXmlFragmentWriter(w);
            for (XMLEvent next : theEvents) {
                if (next.isCharacters()) {
                    ew.add(next);
                    continue;
                }
                ew.add(next);
            }
            ew.close();
            return w.toString();
        }
        catch (XMLStreamException e) {
            throw new DataFormatException(Msg.code(1751) + "Problem with the contained XML events", e);
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigurationException(Msg.code(1752) + e);
        }
    }

    private static XMLOutputFactory getOrCreateFragmentOutputFactory() throws FactoryConfigurationError {
        XMLOutputFactory retVal = ourFragmentOutputFactory;
        if (retVal == null) {
            retVal = XmlUtil.createOutputFactory();
            retVal.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            ourFragmentOutputFactory = retVal;
            return retVal;
        }
        return retVal;
    }

    private static XMLInputFactory getOrCreateInputFactory() throws FactoryConfigurationError {
        if (ourInputFactory == null) {
            try {
                Class.forName("ca.uhn.fhir.repackage.javax.xml.stream.XMLInputFactory");
                System.setProperty(XMLInputFactory.class.getName(), WstxInputFactory.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            XMLInputFactory inputFactory = XmlUtil.newInputFactory();
            if (!ourHaveLoggedStaxImplementation) {
                XmlUtil.logStaxImplementation(inputFactory.getClass());
            }
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            try {
                Class.forName("com.ctc.wstx.stax.WstxInputFactory");
                boolean isWoodstox = inputFactory instanceof WstxInputFactory;
                if (!isWoodstox) {
                    try {
                        isWoodstox = inputFactory.getProperty("org.codehaus.stax2.implVersion") != null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (isWoodstox) {
                    inputFactory.setProperty("com.ctc.wstx.undeclaredEntityResolver", XML_RESOLVER);
                    try {
                        inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", "100000000");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (ClassNotFoundException e) {
                ourLog.debug("WstxOutputFactory (Woodstox) not found on classpath");
            }
            ourInputFactory = inputFactory;
        }
        return ourInputFactory;
    }

    private static XMLOutputFactory getOrCreateOutputFactory() throws FactoryConfigurationError {
        if (ourOutputFactory == null) {
            ourOutputFactory = XmlUtil.createOutputFactory();
        }
        return ourOutputFactory;
    }

    private static void logStaxImplementation(Class<?> theClass) {
        IDependencyLog logger = DependencyLogFactory.createJarLogger();
        if (logger != null) {
            logger.logStaxImplementation(theClass);
        }
        ourHaveLoggedStaxImplementation = true;
    }

    static XMLInputFactory newInputFactory() throws FactoryConfigurationError {
        XMLInputFactory inputFactory;
        try {
            inputFactory = XMLInputFactory.newInstance();
            if (inputFactory.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
                inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
            }
            XmlUtil.throwUnitTestExceptionIfConfiguredToDoSo();
        }
        catch (Throwable e) {
            throw new ConfigurationException(Msg.code(1753) + "Unable to initialize StAX - XML processing is disabled", e);
        }
        return inputFactory;
    }

    static XMLOutputFactory newOutputFactory() throws FactoryConfigurationError {
        XMLOutputFactory outputFactory;
        try {
            outputFactory = XMLOutputFactory.newInstance();
            XmlUtil.throwUnitTestExceptionIfConfiguredToDoSo();
        }
        catch (Throwable e) {
            throw new ConfigurationException(Msg.code(1754) + "Unable to initialize StAX - XML processing is disabled", e);
        }
        return outputFactory;
    }

    public static List<XMLEvent> parse(String theValue) {
        boolean hasProcessingInstruction;
        if (StringUtils.isBlank((CharSequence)theValue)) {
            return Collections.emptyList();
        }
        Object val = theValue.trim();
        if (!((String)val).startsWith("<")) {
            val = "<div xmlns=\"http://www.w3.org/1999/xhtml\">" + (String)val + "</div>";
        }
        if ((hasProcessingInstruction = ((String)val).startsWith("<?")) && ((String)val).endsWith("?>")) {
            return null;
        }
        try {
            ArrayList<XMLEvent> value = new ArrayList<XMLEvent>();
            StringReader reader = new StringReader((String)val);
            XMLEventReader er = XmlUtil.createXmlReader(reader);
            boolean first = true;
            while (er.hasNext()) {
                XMLEvent next = er.nextEvent();
                if (first) {
                    first = false;
                    continue;
                }
                if (!er.hasNext()) continue;
                value.add(next);
            }
            return value;
        }
        catch (XMLStreamException e) {
            throw new DataFormatException(Msg.code(1755) + "String does not appear to be valid XML/XHTML (error is \"" + e.getMessage() + "\"): " + theValue, e);
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigurationException(Msg.code(1756) + e);
        }
    }

    static void setThrowExceptionForUnitTest(Throwable theException) {
        ourNextException = theException;
    }

    private static void throwUnitTestExceptionIfConfiguredToDoSo() throws FactoryConfigurationError, XMLStreamException {
        if (ourNextException != null) {
            if (ourNextException instanceof FactoryConfigurationError) {
                throw (FactoryConfigurationError)ourNextException;
            }
            throw (XMLStreamException)ourNextException;
        }
    }

    public static Document parseDocument(String theInput) throws IOException, SAXException {
        StringReader reader = new StringReader(theInput);
        return XmlUtil.parseDocument(reader);
    }

    public static Document parseDocument(Reader reader) throws SAXException, IOException {
        return XmlUtil.parseDocument(reader, true, false);
    }

    public static Document parseDocument(Reader theReader, boolean theNamespaceAware, boolean allowDoctypeDeclaration) throws SAXException, IOException {
        DocumentBuilder builder;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(theNamespaceAware);
            docBuilderFactory.setXIncludeAware(false);
            docBuilderFactory.setExpandEntityReferences(false);
            try {
                docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", !allowDoctypeDeclaration);
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                XmlUtil.throwUnitTestExceptionIfConfiguredToDoSo();
            }
            catch (Exception e) {
                ourLog.warn("Failed to set feature on XML parser: " + e.toString());
            }
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(Msg.code(1757) + e);
        }
        InputSource src = new InputSource(theReader);
        return builder.parse(src);
    }

    public static List<Element> getChildrenByTagName(Element theParent, String theName) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        for (Node child = theParent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !theName.equals(child.getNodeName())) continue;
            nodeList.add((Element)child);
        }
        return nodeList;
    }

    public static String encodeDocument(Node theElement) throws TransformerException {
        return XmlUtil.encodeDocument(theElement, false);
    }

    public static String encodeDocument(Node theElement, boolean theIndent) throws TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        if (theIndent) {
            transformer.setOutputProperty("indent", "yes");
        }
        transformer.transform(new DOMSource(theElement), new StreamResult(buffer));
        return buffer.toString();
    }

    public static void resetOutputFactoryForTest() {
        ourOutputFactory = null;
    }

    static {
        XML_RESOLVER = new ExtendedEntityReplacingXmlResolver();
        HashMap<String, Integer> validEntityNames = new HashMap<String, Integer>(1448);
        validEntityNames.put("AElig", 198);
        validEntityNames.put("Aacute", 193);
        validEntityNames.put("Abreve", 258);
        validEntityNames.put("Acirc", 194);
        validEntityNames.put("Acy", 1040);
        validEntityNames.put("Afr", 120068);
        validEntityNames.put("Agrave", 192);
        validEntityNames.put("Alpha", 913);
        validEntityNames.put("Amacr", 256);
        validEntityNames.put("And", 10835);
        validEntityNames.put("Aogon", 260);
        validEntityNames.put("Aopf", 120120);
        validEntityNames.put("ApplyFunction", 8289);
        validEntityNames.put("Aring", 197);
        validEntityNames.put("Ascr", 119964);
        validEntityNames.put("Atilde", 195);
        validEntityNames.put("Auml", 196);
        validEntityNames.put("Barv", 10983);
        validEntityNames.put("Barwed", 8966);
        validEntityNames.put("Bcy", 1041);
        validEntityNames.put("Beta", 914);
        validEntityNames.put("Bfr", 120069);
        validEntityNames.put("Bopf", 120121);
        validEntityNames.put("CHcy", 1063);
        validEntityNames.put("Cacute", 262);
        validEntityNames.put("Cap", 8914);
        validEntityNames.put("CapitalDifferentialD", 8517);
        validEntityNames.put("Ccaron", 268);
        validEntityNames.put("Ccedil", 199);
        validEntityNames.put("Ccirc", 264);
        validEntityNames.put("Cconint", 8752);
        validEntityNames.put("Cdot", 266);
        validEntityNames.put("Cfr", 8493);
        validEntityNames.put("Chi", 935);
        validEntityNames.put("Colon", 8759);
        validEntityNames.put("Colone", 10868);
        validEntityNames.put("Conint", 8751);
        validEntityNames.put("Copf", 8450);
        validEntityNames.put("Cross", 10799);
        validEntityNames.put("Cscr", 119966);
        validEntityNames.put("Cup", 8915);
        validEntityNames.put("DDotrahd", 10513);
        validEntityNames.put("DJcy", 1026);
        validEntityNames.put("DScy", 1029);
        validEntityNames.put("DZcy", 1039);
        validEntityNames.put("Dagger", 8225);
        validEntityNames.put("Darr", 8609);
        validEntityNames.put("Dashv", 10980);
        validEntityNames.put("Dcaron", 270);
        validEntityNames.put("Dcy", 1044);
        validEntityNames.put("Delta", 916);
        validEntityNames.put("Dfr", 120071);
        validEntityNames.put("DifferentialD", 8518);
        validEntityNames.put("Dopf", 120123);
        validEntityNames.put("Dot", 168);
        validEntityNames.put("DotDot", 8412);
        validEntityNames.put("DownArrowBar", 10515);
        validEntityNames.put("DownBreve", 785);
        validEntityNames.put("DownLeftRightVector", 10576);
        validEntityNames.put("DownLeftTeeVector", 10590);
        validEntityNames.put("DownLeftVectorBar", 10582);
        validEntityNames.put("DownRightTeeVector", 10591);
        validEntityNames.put("DownRightVectorBar", 10583);
        validEntityNames.put("DownTeeArrow", 8615);
        validEntityNames.put("Dscr", 119967);
        validEntityNames.put("Dstrok", 272);
        validEntityNames.put("ENG", 330);
        validEntityNames.put("ETH", 208);
        validEntityNames.put("Eacute", 201);
        validEntityNames.put("Ecaron", 282);
        validEntityNames.put("Ecirc", 202);
        validEntityNames.put("Ecy", 1069);
        validEntityNames.put("Edot", 278);
        validEntityNames.put("Efr", 120072);
        validEntityNames.put("Egrave", 200);
        validEntityNames.put("Emacr", 274);
        validEntityNames.put("EmptySmallSquare", 9723);
        validEntityNames.put("EmptyVerySmallSquare", 9643);
        validEntityNames.put("Eogon", 280);
        validEntityNames.put("Eopf", 120124);
        validEntityNames.put("Epsilon", 917);
        validEntityNames.put("Equal", 10869);
        validEntityNames.put("Escr", 8496);
        validEntityNames.put("Esim", 10867);
        validEntityNames.put("Eta", 919);
        validEntityNames.put("Euml", 203);
        validEntityNames.put("ExponentialE", 8519);
        validEntityNames.put("Fcy", 1060);
        validEntityNames.put("Ffr", 120073);
        validEntityNames.put("FilledSmallSquare", 9724);
        validEntityNames.put("Fopf", 120125);
        validEntityNames.put("Fscr", 8497);
        validEntityNames.put("GJcy", 1027);
        validEntityNames.put("Gamma", 915);
        validEntityNames.put("Gammad", 988);
        validEntityNames.put("Gbreve", 286);
        validEntityNames.put("Gcedil", 290);
        validEntityNames.put("Gcirc", 284);
        validEntityNames.put("Gcy", 1043);
        validEntityNames.put("Gdot", 288);
        validEntityNames.put("Gfr", 120074);
        validEntityNames.put("Gg", 8921);
        validEntityNames.put("Gopf", 120126);
        validEntityNames.put("GreaterGreater", 10914);
        validEntityNames.put("Gscr", 119970);
        validEntityNames.put("Gt", 8811);
        validEntityNames.put("HARDcy", 1066);
        validEntityNames.put("Hat", 94);
        validEntityNames.put("Hcirc", 292);
        validEntityNames.put("Hfr", 8460);
        validEntityNames.put("Hstrok", 294);
        validEntityNames.put("IEcy", 1045);
        validEntityNames.put("IJlig", 306);
        validEntityNames.put("IOcy", 1025);
        validEntityNames.put("Iacute", 205);
        validEntityNames.put("Icirc", 206);
        validEntityNames.put("Icy", 1048);
        validEntityNames.put("Idot", 304);
        validEntityNames.put("Igrave", 204);
        validEntityNames.put("Imacr", 298);
        validEntityNames.put("ImaginaryI", 8520);
        validEntityNames.put("Int", 8748);
        validEntityNames.put("InvisibleComma", 8291);
        validEntityNames.put("InvisibleTimes", 8290);
        validEntityNames.put("Iogon", 302);
        validEntityNames.put("Iopf", 120128);
        validEntityNames.put("Iota", 921);
        validEntityNames.put("Iscr", 8464);
        validEntityNames.put("Itilde", 296);
        validEntityNames.put("Iukcy", 1030);
        validEntityNames.put("Iuml", 207);
        validEntityNames.put("Jcirc", 308);
        validEntityNames.put("Jcy", 1049);
        validEntityNames.put("Jfr", 120077);
        validEntityNames.put("Jopf", 120129);
        validEntityNames.put("Jscr", 119973);
        validEntityNames.put("Jsercy", 1032);
        validEntityNames.put("Jukcy", 1028);
        validEntityNames.put("KHcy", 1061);
        validEntityNames.put("KJcy", 1036);
        validEntityNames.put("Kappa", 922);
        validEntityNames.put("Kcedil", 310);
        validEntityNames.put("Kcy", 1050);
        validEntityNames.put("Kfr", 120078);
        validEntityNames.put("Kopf", 120130);
        validEntityNames.put("Kscr", 119974);
        validEntityNames.put("LJcy", 1033);
        validEntityNames.put("Lacute", 313);
        validEntityNames.put("Lambda", 923);
        validEntityNames.put("Lang", 10218);
        validEntityNames.put("Larr", 8606);
        validEntityNames.put("Lcaron", 317);
        validEntityNames.put("Lcedil", 315);
        validEntityNames.put("Lcy", 1051);
        validEntityNames.put("LeftDownTeeVector", 10593);
        validEntityNames.put("LeftDownVectorBar", 10585);
        validEntityNames.put("LeftRightVector", 10574);
        validEntityNames.put("LeftTeeArrow", 8612);
        validEntityNames.put("LeftTeeVector", 10586);
        validEntityNames.put("LeftTriangleBar", 10703);
        validEntityNames.put("LeftUpDownVector", 10577);
        validEntityNames.put("LeftUpTeeVector", 10592);
        validEntityNames.put("LeftUpVectorBar", 10584);
        validEntityNames.put("LeftVectorBar", 10578);
        validEntityNames.put("LessLess", 10913);
        validEntityNames.put("Lfr", 120079);
        validEntityNames.put("Ll", 8920);
        validEntityNames.put("Lmidot", 319);
        validEntityNames.put("Lopf", 120131);
        validEntityNames.put("Lscr", 8466);
        validEntityNames.put("Lstrok", 321);
        validEntityNames.put("Lt", 8810);
        validEntityNames.put("Map", 10501);
        validEntityNames.put("Mcy", 1052);
        validEntityNames.put("MediumSpace", 8287);
        validEntityNames.put("Mfr", 120080);
        validEntityNames.put("Mopf", 120132);
        validEntityNames.put("Mu", 924);
        validEntityNames.put("NJcy", 1034);
        validEntityNames.put("Nacute", 323);
        validEntityNames.put("Ncaron", 327);
        validEntityNames.put("Ncedil", 325);
        validEntityNames.put("Ncy", 1053);
        validEntityNames.put("NewLine", 10);
        validEntityNames.put("Nfr", 120081);
        validEntityNames.put("NoBreak", 8288);
        validEntityNames.put("Nopf", 8469);
        validEntityNames.put("Not", 10988);
        validEntityNames.put("NotCupCap", 8813);
        validEntityNames.put("Nscr", 119977);
        validEntityNames.put("Ntilde", 209);
        validEntityNames.put("Nu", 925);
        validEntityNames.put("OElig", 338);
        validEntityNames.put("Oacute", 211);
        validEntityNames.put("Ocirc", 212);
        validEntityNames.put("Ocy", 1054);
        validEntityNames.put("Odblac", 336);
        validEntityNames.put("Ofr", 120082);
        validEntityNames.put("Ograve", 210);
        validEntityNames.put("Omacr", 332);
        validEntityNames.put("Omega", 937);
        validEntityNames.put("Omicron", 927);
        validEntityNames.put("Oopf", 120134);
        validEntityNames.put("Or", 10836);
        validEntityNames.put("Oscr", 119978);
        validEntityNames.put("Oslash", 216);
        validEntityNames.put("Otilde", 213);
        validEntityNames.put("Otimes", 10807);
        validEntityNames.put("Ouml", 214);
        validEntityNames.put("OverBrace", 9182);
        validEntityNames.put("OverParenthesis", 9180);
        validEntityNames.put("Pcy", 1055);
        validEntityNames.put("Pfr", 120083);
        validEntityNames.put("Phi", 934);
        validEntityNames.put("Pi", 928);
        validEntityNames.put("Popf", 8473);
        validEntityNames.put("Pr", 10939);
        validEntityNames.put("Prime", 8243);
        validEntityNames.put("Pscr", 119979);
        validEntityNames.put("Psi", 936);
        validEntityNames.put("Qfr", 120084);
        validEntityNames.put("Qscr", 119980);
        validEntityNames.put("RBarr", 10512);
        validEntityNames.put("Racute", 340);
        validEntityNames.put("Rang", 10219);
        validEntityNames.put("Rarr", 8608);
        validEntityNames.put("Rarrtl", 10518);
        validEntityNames.put("Rcaron", 344);
        validEntityNames.put("Rcedil", 342);
        validEntityNames.put("Rcy", 1056);
        validEntityNames.put("Rho", 929);
        validEntityNames.put("RightDownTeeVector", 10589);
        validEntityNames.put("RightDownVectorBar", 10581);
        validEntityNames.put("RightTeeVector", 10587);
        validEntityNames.put("RightTriangleBar", 10704);
        validEntityNames.put("RightUpDownVector", 10575);
        validEntityNames.put("RightUpTeeVector", 10588);
        validEntityNames.put("RightUpVectorBar", 10580);
        validEntityNames.put("RightVectorBar", 10579);
        validEntityNames.put("RoundImplies", 10608);
        validEntityNames.put("Rscr", 8475);
        validEntityNames.put("RuleDelayed", 10740);
        validEntityNames.put("SHCHcy", 1065);
        validEntityNames.put("SHcy", 1064);
        validEntityNames.put("SOFTcy", 1068);
        validEntityNames.put("Sacute", 346);
        validEntityNames.put("Sc", 10940);
        validEntityNames.put("Scaron", 352);
        validEntityNames.put("Scedil", 350);
        validEntityNames.put("Scirc", 348);
        validEntityNames.put("Scy", 1057);
        validEntityNames.put("Sfr", 120086);
        validEntityNames.put("Sigma", 931);
        validEntityNames.put("Sopf", 120138);
        validEntityNames.put("Sscr", 119982);
        validEntityNames.put("Sub", 8912);
        validEntityNames.put("Sup", 8913);
        validEntityNames.put("THORN", 222);
        validEntityNames.put("TSHcy", 1035);
        validEntityNames.put("TScy", 1062);
        validEntityNames.put("Tab", 9);
        validEntityNames.put("Tau", 932);
        validEntityNames.put("Tcaron", 356);
        validEntityNames.put("Tcedil", 354);
        validEntityNames.put("Tcy", 1058);
        validEntityNames.put("Tfr", 120087);
        validEntityNames.put("Theta", 920);
        validEntityNames.put("Topf", 120139);
        validEntityNames.put("Tscr", 119983);
        validEntityNames.put("Tstrok", 358);
        validEntityNames.put("Uacute", 218);
        validEntityNames.put("Uarr", 8607);
        validEntityNames.put("Uarrocir", 10569);
        validEntityNames.put("Ubrcy", 1038);
        validEntityNames.put("Ubreve", 364);
        validEntityNames.put("Ucirc", 219);
        validEntityNames.put("Ucy", 1059);
        validEntityNames.put("Udblac", 368);
        validEntityNames.put("Ufr", 120088);
        validEntityNames.put("Ugrave", 217);
        validEntityNames.put("Umacr", 362);
        validEntityNames.put("UnderBar", 818);
        validEntityNames.put("UnderBrace", 9183);
        validEntityNames.put("UnderParenthesis", 9181);
        validEntityNames.put("Uogon", 370);
        validEntityNames.put("Uopf", 120140);
        validEntityNames.put("UpArrowBar", 10514);
        validEntityNames.put("UpTeeArrow", 8613);
        validEntityNames.put("Upsi", 978);
        validEntityNames.put("Upsilon", 933);
        validEntityNames.put("Uring", 366);
        validEntityNames.put("Uscr", 119984);
        validEntityNames.put("Utilde", 360);
        validEntityNames.put("Uuml", 220);
        validEntityNames.put("VDash", 8875);
        validEntityNames.put("Vbar", 10987);
        validEntityNames.put("Vcy", 1042);
        validEntityNames.put("Vdash", 8873);
        validEntityNames.put("Vdashl", 10982);
        validEntityNames.put("Verbar", 8214);
        validEntityNames.put("VerticalSeparator", 10072);
        validEntityNames.put("Vfr", 120089);
        validEntityNames.put("Vopf", 120141);
        validEntityNames.put("Vscr", 119985);
        validEntityNames.put("Vvdash", 8874);
        validEntityNames.put("Wcirc", 372);
        validEntityNames.put("Wfr", 120090);
        validEntityNames.put("Wopf", 120142);
        validEntityNames.put("Wscr", 119986);
        validEntityNames.put("Xfr", 120091);
        validEntityNames.put("Xi", 926);
        validEntityNames.put("Xopf", 120143);
        validEntityNames.put("Xscr", 119987);
        validEntityNames.put("YAcy", 1071);
        validEntityNames.put("YIcy", 1031);
        validEntityNames.put("YUcy", 1070);
        validEntityNames.put("Yacute", 221);
        validEntityNames.put("Ycirc", 374);
        validEntityNames.put("Ycy", 1067);
        validEntityNames.put("Yfr", 120092);
        validEntityNames.put("Yopf", 120144);
        validEntityNames.put("Yscr", 119988);
        validEntityNames.put("Yuml", 376);
        validEntityNames.put("ZHcy", 1046);
        validEntityNames.put("Zacute", 377);
        validEntityNames.put("Zcaron", 381);
        validEntityNames.put("Zcy", 1047);
        validEntityNames.put("Zdot", 379);
        validEntityNames.put("ZeroWidthSpace", 8203);
        validEntityNames.put("Zeta", 918);
        validEntityNames.put("Zfr", 8488);
        validEntityNames.put("Zscr", 119989);
        validEntityNames.put("aacute", 225);
        validEntityNames.put("abreve", 259);
        validEntityNames.put("ac", 8766);
        validEntityNames.put("acd", 8767);
        validEntityNames.put("acirc", 226);
        validEntityNames.put("acute", 180);
        validEntityNames.put("acy", 1072);
        validEntityNames.put("aelig", 230);
        validEntityNames.put("afr", 120094);
        validEntityNames.put("agrave", 224);
        validEntityNames.put("alefsym", 8501);
        validEntityNames.put("alpha", 945);
        validEntityNames.put("amacr", 257);
        validEntityNames.put("amalg", 10815);
        validEntityNames.put("amp", 38);
        validEntityNames.put("and", 8743);
        validEntityNames.put("andand", 10837);
        validEntityNames.put("andd", 10844);
        validEntityNames.put("andslope", 10840);
        validEntityNames.put("andv", 10842);
        validEntityNames.put("ang", 8736);
        validEntityNames.put("ange", 10660);
        validEntityNames.put("angmsd", 8737);
        validEntityNames.put("angmsdaa", 10664);
        validEntityNames.put("angmsdab", 10665);
        validEntityNames.put("angmsdac", 10666);
        validEntityNames.put("angmsdad", 10667);
        validEntityNames.put("angmsdae", 10668);
        validEntityNames.put("angmsdaf", 10669);
        validEntityNames.put("angmsdag", 10670);
        validEntityNames.put("angmsdah", 10671);
        validEntityNames.put("angrt", 8735);
        validEntityNames.put("angrtvb", 8894);
        validEntityNames.put("angrtvbd", 10653);
        validEntityNames.put("angsph", 8738);
        validEntityNames.put("angst", 8491);
        validEntityNames.put("angzarr", 9084);
        validEntityNames.put("aogon", 261);
        validEntityNames.put("aopf", 120146);
        validEntityNames.put("apE", 10864);
        validEntityNames.put("apacir", 10863);
        validEntityNames.put("ape", 8778);
        validEntityNames.put("apid", 8779);
        validEntityNames.put("apos", 39);
        validEntityNames.put("aring", 229);
        validEntityNames.put("ascr", 119990);
        validEntityNames.put("ast", 42);
        validEntityNames.put("asymp", 8776);
        validEntityNames.put("asympeq", 8781);
        validEntityNames.put("atilde", 227);
        validEntityNames.put("auml", 228);
        validEntityNames.put("awconint", 8755);
        validEntityNames.put("awint", 10769);
        validEntityNames.put("bNot", 10989);
        validEntityNames.put("barvee", 8893);
        validEntityNames.put("barwed", 8965);
        validEntityNames.put("bbrk", 9141);
        validEntityNames.put("bbrktbrk", 9142);
        validEntityNames.put("bcong", 8780);
        validEntityNames.put("bcy", 1073);
        validEntityNames.put("becaus", 8757);
        validEntityNames.put("bemptyv", 10672);
        validEntityNames.put("bepsi", 1014);
        validEntityNames.put("bernou", 8492);
        validEntityNames.put("beta", 946);
        validEntityNames.put("beth", 8502);
        validEntityNames.put("bfr", 120095);
        validEntityNames.put("blank", 9251);
        validEntityNames.put("blk12", 9618);
        validEntityNames.put("blk14", 9617);
        validEntityNames.put("blk34", 9619);
        validEntityNames.put("block", 9608);
        validEntityNames.put("bnot", 8976);
        validEntityNames.put("bopf", 120147);
        validEntityNames.put("bottom", 8869);
        validEntityNames.put("bowtie", 8904);
        validEntityNames.put("boxDL", 9559);
        validEntityNames.put("boxDR", 9556);
        validEntityNames.put("boxDl", 9558);
        validEntityNames.put("boxDr", 9555);
        validEntityNames.put("boxH", 9552);
        validEntityNames.put("boxHD", 9574);
        validEntityNames.put("boxHU", 9577);
        validEntityNames.put("boxHd", 9572);
        validEntityNames.put("boxHu", 9575);
        validEntityNames.put("boxUL", 9565);
        validEntityNames.put("boxUR", 9562);
        validEntityNames.put("boxUl", 9564);
        validEntityNames.put("boxUr", 9561);
        validEntityNames.put("boxV", 9553);
        validEntityNames.put("boxVH", 9580);
        validEntityNames.put("boxVL", 9571);
        validEntityNames.put("boxVR", 9568);
        validEntityNames.put("boxVh", 9579);
        validEntityNames.put("boxVl", 9570);
        validEntityNames.put("boxVr", 9567);
        validEntityNames.put("boxbox", 10697);
        validEntityNames.put("boxdL", 9557);
        validEntityNames.put("boxdR", 9554);
        validEntityNames.put("boxdl", 9488);
        validEntityNames.put("boxdr", 9484);
        validEntityNames.put("boxh", 9472);
        validEntityNames.put("boxhD", 9573);
        validEntityNames.put("boxhU", 9576);
        validEntityNames.put("boxhd", 9516);
        validEntityNames.put("boxhu", 9524);
        validEntityNames.put("boxuL", 9563);
        validEntityNames.put("boxuR", 9560);
        validEntityNames.put("boxul", 9496);
        validEntityNames.put("boxur", 9492);
        validEntityNames.put("boxv", 9474);
        validEntityNames.put("boxvH", 9578);
        validEntityNames.put("boxvL", 9569);
        validEntityNames.put("boxvR", 9566);
        validEntityNames.put("boxvh", 9532);
        validEntityNames.put("boxvl", 9508);
        validEntityNames.put("boxvr", 9500);
        validEntityNames.put("bprime", 8245);
        validEntityNames.put("breve", 728);
        validEntityNames.put("brvbar", 166);
        validEntityNames.put("bscr", 119991);
        validEntityNames.put("bsemi", 8271);
        validEntityNames.put("bsim", 8765);
        validEntityNames.put("bsime", 8909);
        validEntityNames.put("bsol", 92);
        validEntityNames.put("bsolb", 10693);
        validEntityNames.put("bull", 8226);
        validEntityNames.put("bump", 8782);
        validEntityNames.put("bumpE", 10926);
        validEntityNames.put("bumpe", 8783);
        validEntityNames.put("cacute", 263);
        validEntityNames.put("cap", 8745);
        validEntityNames.put("capand", 10820);
        validEntityNames.put("capbrcup", 10825);
        validEntityNames.put("capcap", 10827);
        validEntityNames.put("capcup", 10823);
        validEntityNames.put("capdot", 10816);
        validEntityNames.put("caret", 8257);
        validEntityNames.put("caron", 711);
        validEntityNames.put("ccaps", 10829);
        validEntityNames.put("ccaron", 269);
        validEntityNames.put("ccedil", 231);
        validEntityNames.put("ccirc", 265);
        validEntityNames.put("ccups", 10828);
        validEntityNames.put("ccupssm", 10832);
        validEntityNames.put("cdot", 267);
        validEntityNames.put("cedil", 184);
        validEntityNames.put("cemptyv", 10674);
        validEntityNames.put("cent", 162);
        validEntityNames.put("cfr", 120096);
        validEntityNames.put("chcy", 1095);
        validEntityNames.put("check", 10003);
        validEntityNames.put("chi", 967);
        validEntityNames.put("cir", 9675);
        validEntityNames.put("cirE", 10691);
        validEntityNames.put("circ", 710);
        validEntityNames.put("cire", 8791);
        validEntityNames.put("cirfnint", 10768);
        validEntityNames.put("cirmid", 10991);
        validEntityNames.put("cirscir", 10690);
        validEntityNames.put("clubs", 9827);
        validEntityNames.put("colon", 58);
        validEntityNames.put("colone", 8788);
        validEntityNames.put("comma", 44);
        validEntityNames.put("commat", 64);
        validEntityNames.put("comp", 8705);
        validEntityNames.put("compfn", 8728);
        validEntityNames.put("cong", 8773);
        validEntityNames.put("congdot", 10861);
        validEntityNames.put("conint", 8750);
        validEntityNames.put("copf", 120148);
        validEntityNames.put("coprod", 8720);
        validEntityNames.put("copy", 169);
        validEntityNames.put("copysr", 8471);
        validEntityNames.put("crarr", 8629);
        validEntityNames.put("cross", 10007);
        validEntityNames.put("cscr", 119992);
        validEntityNames.put("csub", 10959);
        validEntityNames.put("csube", 10961);
        validEntityNames.put("csup", 10960);
        validEntityNames.put("csupe", 10962);
        validEntityNames.put("ctdot", 8943);
        validEntityNames.put("cudarrl", 10552);
        validEntityNames.put("cudarrr", 10549);
        validEntityNames.put("cuepr", 8926);
        validEntityNames.put("cuesc", 8927);
        validEntityNames.put("cularr", 8630);
        validEntityNames.put("cularrp", 10557);
        validEntityNames.put("cup", 8746);
        validEntityNames.put("cupbrcap", 10824);
        validEntityNames.put("cupcap", 10822);
        validEntityNames.put("cupcup", 10826);
        validEntityNames.put("cupdot", 8845);
        validEntityNames.put("cupor", 10821);
        validEntityNames.put("curarr", 8631);
        validEntityNames.put("curarrm", 10556);
        validEntityNames.put("curren", 164);
        validEntityNames.put("cuvee", 8910);
        validEntityNames.put("cuwed", 8911);
        validEntityNames.put("cwconint", 8754);
        validEntityNames.put("cwint", 8753);
        validEntityNames.put("cylcty", 9005);
        validEntityNames.put("dArr", 8659);
        validEntityNames.put("dHar", 10597);
        validEntityNames.put("dagger", 8224);
        validEntityNames.put("daleth", 8504);
        validEntityNames.put("darr", 8595);
        validEntityNames.put("dashv", 8867);
        validEntityNames.put("dblac", 733);
        validEntityNames.put("dcaron", 271);
        validEntityNames.put("dcy", 1076);
        validEntityNames.put("ddarr", 8650);
        validEntityNames.put("deg", 176);
        validEntityNames.put("delta", 948);
        validEntityNames.put("demptyv", 10673);
        validEntityNames.put("dfisht", 10623);
        validEntityNames.put("dfr", 120097);
        validEntityNames.put("dharl", 8643);
        validEntityNames.put("dharr", 8642);
        validEntityNames.put("diam", 8900);
        validEntityNames.put("diams", 9830);
        validEntityNames.put("disin", 8946);
        validEntityNames.put("divide", 247);
        validEntityNames.put("divonx", 8903);
        validEntityNames.put("djcy", 1106);
        validEntityNames.put("dlcorn", 8990);
        validEntityNames.put("dlcrop", 8973);
        validEntityNames.put("dollar", 36);
        validEntityNames.put("dopf", 120149);
        validEntityNames.put("dot", 729);
        validEntityNames.put("drcorn", 8991);
        validEntityNames.put("drcrop", 8972);
        validEntityNames.put("dscr", 119993);
        validEntityNames.put("dscy", 1109);
        validEntityNames.put("dsol", 10742);
        validEntityNames.put("dstrok", 273);
        validEntityNames.put("dtdot", 8945);
        validEntityNames.put("dtri", 9663);
        validEntityNames.put("dtrif", 9662);
        validEntityNames.put("duarr", 8693);
        validEntityNames.put("duhar", 10607);
        validEntityNames.put("dwangle", 10662);
        validEntityNames.put("dzcy", 1119);
        validEntityNames.put("dzigrarr", 10239);
        validEntityNames.put("eDDot", 10871);
        validEntityNames.put("eDot", 8785);
        validEntityNames.put("eacute", 233);
        validEntityNames.put("easter", 10862);
        validEntityNames.put("ecaron", 283);
        validEntityNames.put("ecir", 8790);
        validEntityNames.put("ecirc", 234);
        validEntityNames.put("ecolon", 8789);
        validEntityNames.put("ecy", 1101);
        validEntityNames.put("edot", 279);
        validEntityNames.put("efDot", 8786);
        validEntityNames.put("efr", 120098);
        validEntityNames.put("eg", 10906);
        validEntityNames.put("egrave", 232);
        validEntityNames.put("egs", 10902);
        validEntityNames.put("egsdot", 10904);
        validEntityNames.put("el", 10905);
        validEntityNames.put("elinters", 9191);
        validEntityNames.put("ell", 8467);
        validEntityNames.put("els", 10901);
        validEntityNames.put("elsdot", 10903);
        validEntityNames.put("emacr", 275);
        validEntityNames.put("empty", 8709);
        validEntityNames.put("emsp", 8195);
        validEntityNames.put("emsp13", 8196);
        validEntityNames.put("emsp14", 8197);
        validEntityNames.put("eng", 331);
        validEntityNames.put("ensp", 8194);
        validEntityNames.put("eogon", 281);
        validEntityNames.put("eopf", 120150);
        validEntityNames.put("epar", 8917);
        validEntityNames.put("eparsl", 10723);
        validEntityNames.put("eplus", 10865);
        validEntityNames.put("epsi", 1013);
        validEntityNames.put("epsiv", 949);
        validEntityNames.put("equals", 61);
        validEntityNames.put("equest", 8799);
        validEntityNames.put("equiv", 8801);
        validEntityNames.put("equivDD", 10872);
        validEntityNames.put("eqvparsl", 10725);
        validEntityNames.put("erDot", 8787);
        validEntityNames.put("erarr", 10609);
        validEntityNames.put("escr", 8495);
        validEntityNames.put("esdot", 8784);
        validEntityNames.put("esim", 8770);
        validEntityNames.put("eta", 951);
        validEntityNames.put("eth", 240);
        validEntityNames.put("euml", 235);
        validEntityNames.put("euro", 8364);
        validEntityNames.put("excl", 33);
        validEntityNames.put("exist", 8707);
        validEntityNames.put("fcy", 1092);
        validEntityNames.put("female", 9792);
        validEntityNames.put("ffilig", 64259);
        validEntityNames.put("fflig", 64256);
        validEntityNames.put("ffllig", 64260);
        validEntityNames.put("ffr", 120099);
        validEntityNames.put("filig", 64257);
        validEntityNames.put("flat", 9837);
        validEntityNames.put("fllig", 64258);
        validEntityNames.put("fltns", 9649);
        validEntityNames.put("fnof", 402);
        validEntityNames.put("fopf", 120151);
        validEntityNames.put("forall", 8704);
        validEntityNames.put("fork", 8916);
        validEntityNames.put("forkv", 10969);
        validEntityNames.put("fpartint", 10765);
        validEntityNames.put("frac12", 189);
        validEntityNames.put("frac13", 8531);
        validEntityNames.put("frac14", 188);
        validEntityNames.put("frac15", 8533);
        validEntityNames.put("frac16", 8537);
        validEntityNames.put("frac18", 8539);
        validEntityNames.put("frac23", 8532);
        validEntityNames.put("frac25", 8534);
        validEntityNames.put("frac34", 190);
        validEntityNames.put("frac35", 8535);
        validEntityNames.put("frac38", 8540);
        validEntityNames.put("frac45", 8536);
        validEntityNames.put("frac56", 8538);
        validEntityNames.put("frac58", 8541);
        validEntityNames.put("frac78", 8542);
        validEntityNames.put("frasl", 8260);
        validEntityNames.put("frown", 8994);
        validEntityNames.put("fscr", 119995);
        validEntityNames.put("gE", 8807);
        validEntityNames.put("gEl", 10892);
        validEntityNames.put("gacute", 501);
        validEntityNames.put("gamma", 947);
        validEntityNames.put("gammad", 989);
        validEntityNames.put("gap", 10886);
        validEntityNames.put("gbreve", 287);
        validEntityNames.put("gcirc", 285);
        validEntityNames.put("gcy", 1075);
        validEntityNames.put("gdot", 289);
        validEntityNames.put("ge", 8805);
        validEntityNames.put("gel", 8923);
        validEntityNames.put("ges", 10878);
        validEntityNames.put("gescc", 10921);
        validEntityNames.put("gesdot", 10880);
        validEntityNames.put("gesdoto", 10882);
        validEntityNames.put("gesdotol", 10884);
        validEntityNames.put("gesles", 10900);
        validEntityNames.put("gfr", 120100);
        validEntityNames.put("gimel", 8503);
        validEntityNames.put("gjcy", 1107);
        validEntityNames.put("gl", 8823);
        validEntityNames.put("glE", 10898);
        validEntityNames.put("gla", 10917);
        validEntityNames.put("glj", 10916);
        validEntityNames.put("gnE", 8809);
        validEntityNames.put("gnap", 10890);
        validEntityNames.put("gne", 10888);
        validEntityNames.put("gnsim", 8935);
        validEntityNames.put("gopf", 120152);
        validEntityNames.put("grave", 96);
        validEntityNames.put("gscr", 8458);
        validEntityNames.put("gsim", 8819);
        validEntityNames.put("gsime", 10894);
        validEntityNames.put("gsiml", 10896);
        validEntityNames.put("gt", 62);
        validEntityNames.put("gtcc", 10919);
        validEntityNames.put("gtcir", 10874);
        validEntityNames.put("gtdot", 8919);
        validEntityNames.put("gtlPar", 10645);
        validEntityNames.put("gtquest", 10876);
        validEntityNames.put("gtrarr", 10616);
        validEntityNames.put("hArr", 8660);
        validEntityNames.put("hairsp", 8202);
        validEntityNames.put("hamilt", 8459);
        validEntityNames.put("hardcy", 1098);
        validEntityNames.put("harr", 8596);
        validEntityNames.put("harrcir", 10568);
        validEntityNames.put("harrw", 8621);
        validEntityNames.put("hcirc", 293);
        validEntityNames.put("hearts", 9829);
        validEntityNames.put("hellip", 8230);
        validEntityNames.put("hercon", 8889);
        validEntityNames.put("hfr", 120101);
        validEntityNames.put("hoarr", 8703);
        validEntityNames.put("homtht", 8763);
        validEntityNames.put("hopf", 120153);
        validEntityNames.put("horbar", 8213);
        validEntityNames.put("hscr", 119997);
        validEntityNames.put("hstrok", 295);
        validEntityNames.put("hybull", 8259);
        validEntityNames.put("hyphen", 8208);
        validEntityNames.put("iacute", 237);
        validEntityNames.put("icirc", 238);
        validEntityNames.put("icy", 1080);
        validEntityNames.put("iecy", 1077);
        validEntityNames.put("iexcl", 161);
        validEntityNames.put("ifr", 120102);
        validEntityNames.put("igrave", 236);
        validEntityNames.put("iinfin", 10716);
        validEntityNames.put("iiota", 8489);
        validEntityNames.put("ijlig", 307);
        validEntityNames.put("imacr", 299);
        validEntityNames.put("image", 8465);
        validEntityNames.put("imath", 305);
        validEntityNames.put("imof", 8887);
        validEntityNames.put("imped", 437);
        validEntityNames.put("incare", 8453);
        validEntityNames.put("infin", 8734);
        validEntityNames.put("infintie", 10717);
        validEntityNames.put("int", 8747);
        validEntityNames.put("intcal", 8890);
        validEntityNames.put("integers", 8484);
        validEntityNames.put("intlarhk", 10775);
        validEntityNames.put("iocy", 1105);
        validEntityNames.put("iogon", 303);
        validEntityNames.put("iopf", 120154);
        validEntityNames.put("iota", 953);
        validEntityNames.put("iprod", 10812);
        validEntityNames.put("iquest", 191);
        validEntityNames.put("iscr", 119998);
        validEntityNames.put("isin", 8712);
        validEntityNames.put("isinE", 8953);
        validEntityNames.put("isindot", 8949);
        validEntityNames.put("isins", 8948);
        validEntityNames.put("isinsv", 8947);
        validEntityNames.put("itilde", 297);
        validEntityNames.put("iukcy", 1110);
        validEntityNames.put("iuml", 239);
        validEntityNames.put("jcirc", 309);
        validEntityNames.put("jcy", 1081);
        validEntityNames.put("jfr", 120103);
        validEntityNames.put("jmath", 567);
        validEntityNames.put("jopf", 120155);
        validEntityNames.put("jscr", 119999);
        validEntityNames.put("jsercy", 1112);
        validEntityNames.put("jukcy", 1108);
        validEntityNames.put("kappa", 954);
        validEntityNames.put("kappav", 1008);
        validEntityNames.put("kcedil", 311);
        validEntityNames.put("kcy", 1082);
        validEntityNames.put("kfr", 120104);
        validEntityNames.put("kgreen", 312);
        validEntityNames.put("khcy", 1093);
        validEntityNames.put("kjcy", 1116);
        validEntityNames.put("kopf", 120156);
        validEntityNames.put("kscr", 120000);
        validEntityNames.put("lAarr", 8666);
        validEntityNames.put("lArr", 8656);
        validEntityNames.put("lAtail", 10523);
        validEntityNames.put("lBarr", 10510);
        validEntityNames.put("lE", 8806);
        validEntityNames.put("lEg", 10891);
        validEntityNames.put("lHar", 10594);
        validEntityNames.put("lacute", 314);
        validEntityNames.put("laemptyv", 10676);
        validEntityNames.put("lambda", 955);
        validEntityNames.put("lang", 10216);
        validEntityNames.put("langd", 10641);
        validEntityNames.put("lap", 10885);
        validEntityNames.put("laquo", 171);
        validEntityNames.put("larr", 8592);
        validEntityNames.put("larrb", 8676);
        validEntityNames.put("larrbfs", 10527);
        validEntityNames.put("larrfs", 10525);
        validEntityNames.put("larrhk", 8617);
        validEntityNames.put("larrlp", 8619);
        validEntityNames.put("larrpl", 10553);
        validEntityNames.put("larrsim", 10611);
        validEntityNames.put("larrtl", 8610);
        validEntityNames.put("lat", 10923);
        validEntityNames.put("latail", 10521);
        validEntityNames.put("late", 10925);
        validEntityNames.put("lbarr", 10508);
        validEntityNames.put("lbbrk", 10098);
        validEntityNames.put("lbrke", 10635);
        validEntityNames.put("lbrksld", 10639);
        validEntityNames.put("lbrkslu", 10637);
        validEntityNames.put("lcaron", 318);
        validEntityNames.put("lcedil", 316);
        validEntityNames.put("lceil", 8968);
        validEntityNames.put("lcub", 123);
        validEntityNames.put("lcy", 1083);
        validEntityNames.put("ldca", 10550);
        validEntityNames.put("ldquo", 8220);
        validEntityNames.put("ldquor", 8222);
        validEntityNames.put("ldrdhar", 10599);
        validEntityNames.put("ldrushar", 10571);
        validEntityNames.put("ldsh", 8626);
        validEntityNames.put("le", 8804);
        validEntityNames.put("leg", 8922);
        validEntityNames.put("les", 10877);
        validEntityNames.put("lescc", 10920);
        validEntityNames.put("lesdot", 10879);
        validEntityNames.put("lesdoto", 10881);
        validEntityNames.put("lesdotor", 10883);
        validEntityNames.put("lesges", 10899);
        validEntityNames.put("lfisht", 10620);
        validEntityNames.put("lfloor", 8970);
        validEntityNames.put("lfr", 120105);
        validEntityNames.put("lg", 8822);
        validEntityNames.put("lgE", 10897);
        validEntityNames.put("lhard", 8637);
        validEntityNames.put("lharu", 8636);
        validEntityNames.put("lharul", 10602);
        validEntityNames.put("lhblk", 9604);
        validEntityNames.put("ljcy", 1113);
        validEntityNames.put("llarr", 8647);
        validEntityNames.put("llhard", 10603);
        validEntityNames.put("lltri", 9722);
        validEntityNames.put("lmidot", 320);
        validEntityNames.put("lmoust", 9136);
        validEntityNames.put("lnE", 8808);
        validEntityNames.put("lnap", 10889);
        validEntityNames.put("lne", 10887);
        validEntityNames.put("lnsim", 8934);
        validEntityNames.put("loang", 10220);
        validEntityNames.put("loarr", 8701);
        validEntityNames.put("lobrk", 10214);
        validEntityNames.put("lopar", 10629);
        validEntityNames.put("lopf", 120157);
        validEntityNames.put("loplus", 10797);
        validEntityNames.put("lotimes", 10804);
        validEntityNames.put("lowast", 8727);
        validEntityNames.put("lowbar", 95);
        validEntityNames.put("loz", 9674);
        validEntityNames.put("lozf", 10731);
        validEntityNames.put("lpar", 40);
        validEntityNames.put("lparlt", 10643);
        validEntityNames.put("lrarr", 8646);
        validEntityNames.put("lrhar", 8651);
        validEntityNames.put("lrhard", 10605);
        validEntityNames.put("lrm", 8206);
        validEntityNames.put("lrtri", 8895);
        validEntityNames.put("lsaquo", 8249);
        validEntityNames.put("lscr", 120001);
        validEntityNames.put("lsh", 8624);
        validEntityNames.put("lsim", 8818);
        validEntityNames.put("lsime", 10893);
        validEntityNames.put("lsimg", 10895);
        validEntityNames.put("lsqb", 91);
        validEntityNames.put("lsquo", 8216);
        validEntityNames.put("lsquor", 8218);
        validEntityNames.put("lstrok", 322);
        validEntityNames.put("lt", 60);
        validEntityNames.put("ltcc", 10918);
        validEntityNames.put("ltcir", 10873);
        validEntityNames.put("ltdot", 8918);
        validEntityNames.put("lthree", 8907);
        validEntityNames.put("ltimes", 8905);
        validEntityNames.put("ltlarr", 10614);
        validEntityNames.put("ltquest", 10875);
        validEntityNames.put("ltrPar", 10646);
        validEntityNames.put("ltri", 9667);
        validEntityNames.put("ltrie", 8884);
        validEntityNames.put("ltrif", 9666);
        validEntityNames.put("lurdshar", 10570);
        validEntityNames.put("luruhar", 10598);
        validEntityNames.put("mDDot", 8762);
        validEntityNames.put("macr", 175);
        validEntityNames.put("male", 9794);
        validEntityNames.put("malt", 10016);
        validEntityNames.put("map", 8614);
        validEntityNames.put("marker", 9646);
        validEntityNames.put("mcomma", 10793);
        validEntityNames.put("mcy", 1084);
        validEntityNames.put("mdash", 8212);
        validEntityNames.put("mfr", 120106);
        validEntityNames.put("mho", 8487);
        validEntityNames.put("micro", 181);
        validEntityNames.put("mid", 8739);
        validEntityNames.put("midcir", 10992);
        validEntityNames.put("middot", 183);
        validEntityNames.put("minus", 8722);
        validEntityNames.put("minusb", 8863);
        validEntityNames.put("minusd", 8760);
        validEntityNames.put("minusdu", 10794);
        validEntityNames.put("mlcp", 10971);
        validEntityNames.put("mnplus", 8723);
        validEntityNames.put("models", 8871);
        validEntityNames.put("mopf", 120158);
        validEntityNames.put("mscr", 120002);
        validEntityNames.put("mu", 956);
        validEntityNames.put("mumap", 8888);
        validEntityNames.put("nVDash", 8879);
        validEntityNames.put("nVdash", 8878);
        validEntityNames.put("nabla", 8711);
        validEntityNames.put("nacute", 324);
        validEntityNames.put("nap", 8777);
        validEntityNames.put("napos", 329);
        validEntityNames.put("natur", 9838);
        validEntityNames.put("nbsp", 160);
        validEntityNames.put("ncap", 10819);
        validEntityNames.put("ncaron", 328);
        validEntityNames.put("ncedil", 326);
        validEntityNames.put("ncong", 8775);
        validEntityNames.put("ncup", 10818);
        validEntityNames.put("ncy", 1085);
        validEntityNames.put("ndash", 8211);
        validEntityNames.put("ne", 8800);
        validEntityNames.put("neArr", 8663);
        validEntityNames.put("nearhk", 10532);
        validEntityNames.put("nearr", 8599);
        validEntityNames.put("nequiv", 8802);
        validEntityNames.put("nesear", 10536);
        validEntityNames.put("nexist", 8708);
        validEntityNames.put("nfr", 120107);
        validEntityNames.put("nge", 8817);
        validEntityNames.put("ngsim", 8821);
        validEntityNames.put("ngt", 8815);
        validEntityNames.put("nhArr", 8654);
        validEntityNames.put("nharr", 8622);
        validEntityNames.put("nhpar", 10994);
        validEntityNames.put("nis", 8956);
        validEntityNames.put("nisd", 8954);
        validEntityNames.put("niv", 8715);
        validEntityNames.put("njcy", 1114);
        validEntityNames.put("nlArr", 8653);
        validEntityNames.put("nlarr", 8602);
        validEntityNames.put("nldr", 8229);
        validEntityNames.put("nle", 8816);
        validEntityNames.put("nlsim", 8820);
        validEntityNames.put("nlt", 8814);
        validEntityNames.put("nltri", 8938);
        validEntityNames.put("nltrie", 8940);
        validEntityNames.put("nmid", 8740);
        validEntityNames.put("nopf", 120159);
        validEntityNames.put("not", 172);
        validEntityNames.put("notin", 8713);
        validEntityNames.put("notinvb", 8951);
        validEntityNames.put("notinvc", 8950);
        validEntityNames.put("notni", 8716);
        validEntityNames.put("notnivb", 8958);
        validEntityNames.put("notnivc", 8957);
        validEntityNames.put("npar", 8742);
        validEntityNames.put("npolint", 10772);
        validEntityNames.put("npr", 8832);
        validEntityNames.put("nprcue", 8928);
        validEntityNames.put("nrArr", 8655);
        validEntityNames.put("nrarr", 8603);
        validEntityNames.put("nrtri", 8939);
        validEntityNames.put("nrtrie", 8941);
        validEntityNames.put("nsc", 8833);
        validEntityNames.put("nsccue", 8929);
        validEntityNames.put("nscr", 120003);
        validEntityNames.put("nsim", 8769);
        validEntityNames.put("nsime", 8772);
        validEntityNames.put("nsqsube", 8930);
        validEntityNames.put("nsqsupe", 8931);
        validEntityNames.put("nsub", 8836);
        validEntityNames.put("nsube", 8840);
        validEntityNames.put("nsup", 8837);
        validEntityNames.put("nsupe", 8841);
        validEntityNames.put("ntgl", 8825);
        validEntityNames.put("ntilde", 241);
        validEntityNames.put("ntlg", 8824);
        validEntityNames.put("nu", 957);
        validEntityNames.put("num", 35);
        validEntityNames.put("numero", 8470);
        validEntityNames.put("numsp", 8199);
        validEntityNames.put("nvDash", 8877);
        validEntityNames.put("nvHarr", 10500);
        validEntityNames.put("nvdash", 8876);
        validEntityNames.put("nvinfin", 10718);
        validEntityNames.put("nvlArr", 10498);
        validEntityNames.put("nvrArr", 10499);
        validEntityNames.put("nwArr", 8662);
        validEntityNames.put("nwarhk", 10531);
        validEntityNames.put("nwarr", 8598);
        validEntityNames.put("nwnear", 10535);
        validEntityNames.put("oS", 9416);
        validEntityNames.put("oacute", 243);
        validEntityNames.put("oast", 8859);
        validEntityNames.put("ocir", 8858);
        validEntityNames.put("ocirc", 244);
        validEntityNames.put("ocy", 1086);
        validEntityNames.put("odash", 8861);
        validEntityNames.put("odblac", 337);
        validEntityNames.put("odiv", 10808);
        validEntityNames.put("odot", 8857);
        validEntityNames.put("odsold", 10684);
        validEntityNames.put("oelig", 339);
        validEntityNames.put("ofcir", 10687);
        validEntityNames.put("ofr", 120108);
        validEntityNames.put("ogon", 731);
        validEntityNames.put("ograve", 242);
        validEntityNames.put("ogt", 10689);
        validEntityNames.put("ohbar", 10677);
        validEntityNames.put("ohm", 8486);
        validEntityNames.put("olarr", 8634);
        validEntityNames.put("olcir", 10686);
        validEntityNames.put("olcross", 10683);
        validEntityNames.put("oline", 8254);
        validEntityNames.put("olt", 10688);
        validEntityNames.put("omacr", 333);
        validEntityNames.put("omega", 969);
        validEntityNames.put("omicron", 959);
        validEntityNames.put("omid", 10678);
        validEntityNames.put("ominus", 8854);
        validEntityNames.put("oopf", 120160);
        validEntityNames.put("opar", 10679);
        validEntityNames.put("operp", 10681);
        validEntityNames.put("oplus", 8853);
        validEntityNames.put("or", 8744);
        validEntityNames.put("orarr", 8635);
        validEntityNames.put("ord", 10845);
        validEntityNames.put("order", 8500);
        validEntityNames.put("ordf", 170);
        validEntityNames.put("ordm", 186);
        validEntityNames.put("origof", 8886);
        validEntityNames.put("oror", 10838);
        validEntityNames.put("orslope", 10839);
        validEntityNames.put("orv", 10843);
        validEntityNames.put("oslash", 248);
        validEntityNames.put("osol", 8856);
        validEntityNames.put("otilde", 245);
        validEntityNames.put("otimes", 8855);
        validEntityNames.put("otimesas", 10806);
        validEntityNames.put("ouml", 246);
        validEntityNames.put("ovbar", 9021);
        validEntityNames.put("par", 8741);
        validEntityNames.put("para", 182);
        validEntityNames.put("parsim", 10995);
        validEntityNames.put("parsl", 11005);
        validEntityNames.put("part", 8706);
        validEntityNames.put("pcy", 1087);
        validEntityNames.put("percnt", 37);
        validEntityNames.put("period", 46);
        validEntityNames.put("permil", 8240);
        validEntityNames.put("pertenk", 8241);
        validEntityNames.put("pfr", 120109);
        validEntityNames.put("phi", 966);
        validEntityNames.put("phmmat", 8499);
        validEntityNames.put("phone", 9742);
        validEntityNames.put("pi", 960);
        validEntityNames.put("piv", 982);
        validEntityNames.put("planck", 8463);
        validEntityNames.put("planckh", 8462);
        validEntityNames.put("plus", 43);
        validEntityNames.put("plusacir", 10787);
        validEntityNames.put("plusb", 8862);
        validEntityNames.put("pluscir", 10786);
        validEntityNames.put("plusdo", 8724);
        validEntityNames.put("plusdu", 10789);
        validEntityNames.put("pluse", 10866);
        validEntityNames.put("plusmn", 177);
        validEntityNames.put("plussim", 10790);
        validEntityNames.put("plustwo", 10791);
        validEntityNames.put("pointint", 10773);
        validEntityNames.put("popf", 120161);
        validEntityNames.put("pound", 163);
        validEntityNames.put("pr", 8826);
        validEntityNames.put("prE", 10931);
        validEntityNames.put("prap", 10935);
        validEntityNames.put("prcue", 8828);
        validEntityNames.put("pre", 10927);
        validEntityNames.put("prime", 8242);
        validEntityNames.put("prnE", 10933);
        validEntityNames.put("prnap", 10937);
        validEntityNames.put("prnsim", 8936);
        validEntityNames.put("prod", 8719);
        validEntityNames.put("profalar", 9006);
        validEntityNames.put("profline", 8978);
        validEntityNames.put("profsurf", 8979);
        validEntityNames.put("prop", 8733);
        validEntityNames.put("prsim", 8830);
        validEntityNames.put("prurel", 8880);
        validEntityNames.put("pscr", 120005);
        validEntityNames.put("psi", 968);
        validEntityNames.put("puncsp", 8200);
        validEntityNames.put("qfr", 120110);
        validEntityNames.put("qint", 10764);
        validEntityNames.put("qopf", 120162);
        validEntityNames.put("qprime", 8279);
        validEntityNames.put("qscr", 120006);
        validEntityNames.put("quaternions", 8461);
        validEntityNames.put("quatint", 10774);
        validEntityNames.put("quest", 63);
        validEntityNames.put("quot", 34);
        validEntityNames.put("rAarr", 8667);
        validEntityNames.put("rArr", 8658);
        validEntityNames.put("rAtail", 10524);
        validEntityNames.put("rBarr", 10511);
        validEntityNames.put("rHar", 10596);
        validEntityNames.put("race", 10714);
        validEntityNames.put("racute", 341);
        validEntityNames.put("radic", 8730);
        validEntityNames.put("raemptyv", 10675);
        validEntityNames.put("rang", 10217);
        validEntityNames.put("rangd", 10642);
        validEntityNames.put("range", 10661);
        validEntityNames.put("raquo", 187);
        validEntityNames.put("rarr", 8594);
        validEntityNames.put("rarrap", 10613);
        validEntityNames.put("rarrb", 8677);
        validEntityNames.put("rarrbfs", 10528);
        validEntityNames.put("rarrc", 10547);
        validEntityNames.put("rarrfs", 10526);
        validEntityNames.put("rarrhk", 8618);
        validEntityNames.put("rarrlp", 8620);
        validEntityNames.put("rarrpl", 10565);
        validEntityNames.put("rarrsim", 10612);
        validEntityNames.put("rarrtl", 8611);
        validEntityNames.put("rarrw", 8605);
        validEntityNames.put("ratail", 10522);
        validEntityNames.put("ratio", 8758);
        validEntityNames.put("rationals", 8474);
        validEntityNames.put("rbarr", 10509);
        validEntityNames.put("rbbrk", 10099);
        validEntityNames.put("rbrke", 10636);
        validEntityNames.put("rbrksld", 10638);
        validEntityNames.put("rbrkslu", 10640);
        validEntityNames.put("rcaron", 345);
        validEntityNames.put("rcedil", 343);
        validEntityNames.put("rceil", 8969);
        validEntityNames.put("rcub", 125);
        validEntityNames.put("rcy", 1088);
        validEntityNames.put("rdca", 10551);
        validEntityNames.put("rdldhar", 10601);
        validEntityNames.put("rdquo", 8221);
        validEntityNames.put("rdsh", 8627);
        validEntityNames.put("real", 8476);
        validEntityNames.put("reals", 8477);
        validEntityNames.put("rect", 9645);
        validEntityNames.put("reg", 174);
        validEntityNames.put("rfisht", 10621);
        validEntityNames.put("rfloor", 8971);
        validEntityNames.put("rfr", 120111);
        validEntityNames.put("rhard", 8641);
        validEntityNames.put("rharu", 8640);
        validEntityNames.put("rharul", 10604);
        validEntityNames.put("rho", 961);
        validEntityNames.put("rhov", 1009);
        validEntityNames.put("ring", 730);
        validEntityNames.put("rlarr", 8644);
        validEntityNames.put("rlhar", 8652);
        validEntityNames.put("rlm", 8207);
        validEntityNames.put("rmoust", 9137);
        validEntityNames.put("rnmid", 10990);
        validEntityNames.put("roang", 10221);
        validEntityNames.put("roarr", 8702);
        validEntityNames.put("robrk", 10215);
        validEntityNames.put("ropar", 10630);
        validEntityNames.put("ropf", 120163);
        validEntityNames.put("roplus", 10798);
        validEntityNames.put("rotimes", 10805);
        validEntityNames.put("rpar", 41);
        validEntityNames.put("rpargt", 10644);
        validEntityNames.put("rppolint", 10770);
        validEntityNames.put("rrarr", 8649);
        validEntityNames.put("rsaquo", 8250);
        validEntityNames.put("rscr", 120007);
        validEntityNames.put("rsh", 8625);
        validEntityNames.put("rsqb", 93);
        validEntityNames.put("rsquo", 8217);
        validEntityNames.put("rthree", 8908);
        validEntityNames.put("rtimes", 8906);
        validEntityNames.put("rtri", 9657);
        validEntityNames.put("rtrie", 8885);
        validEntityNames.put("rtrif", 9656);
        validEntityNames.put("rtriltri", 10702);
        validEntityNames.put("ruluhar", 10600);
        validEntityNames.put("rx", 8478);
        validEntityNames.put("sacute", 347);
        validEntityNames.put("sc", 8827);
        validEntityNames.put("scE", 10932);
        validEntityNames.put("scap", 10936);
        validEntityNames.put("scaron", 353);
        validEntityNames.put("sccue", 8829);
        validEntityNames.put("sce", 10928);
        validEntityNames.put("scedil", 351);
        validEntityNames.put("scirc", 349);
        validEntityNames.put("scnE", 10934);
        validEntityNames.put("scnap", 10938);
        validEntityNames.put("scnsim", 8937);
        validEntityNames.put("scpolint", 10771);
        validEntityNames.put("scsim", 8831);
        validEntityNames.put("scy", 1089);
        validEntityNames.put("sdot", 8901);
        validEntityNames.put("sdotb", 8865);
        validEntityNames.put("sdote", 10854);
        validEntityNames.put("seArr", 8664);
        validEntityNames.put("searhk", 10533);
        validEntityNames.put("searr", 8600);
        validEntityNames.put("sect", 167);
        validEntityNames.put("semi", 59);
        validEntityNames.put("seswar", 10537);
        validEntityNames.put("setmn", 8726);
        validEntityNames.put("sext", 10038);
        validEntityNames.put("sfr", 120112);
        validEntityNames.put("sharp", 9839);
        validEntityNames.put("shchcy", 1097);
        validEntityNames.put("shcy", 1096);
        validEntityNames.put("shy", 173);
        validEntityNames.put("sigma", 963);
        validEntityNames.put("sigmav", 962);
        validEntityNames.put("sim", 8764);
        validEntityNames.put("simdot", 10858);
        validEntityNames.put("sime", 8771);
        validEntityNames.put("simg", 10910);
        validEntityNames.put("simgE", 10912);
        validEntityNames.put("siml", 10909);
        validEntityNames.put("simlE", 10911);
        validEntityNames.put("simne", 8774);
        validEntityNames.put("simplus", 10788);
        validEntityNames.put("simrarr", 10610);
        validEntityNames.put("smashp", 10803);
        validEntityNames.put("smeparsl", 10724);
        validEntityNames.put("smile", 8995);
        validEntityNames.put("smt", 10922);
        validEntityNames.put("smte", 10924);
        validEntityNames.put("softcy", 1100);
        validEntityNames.put("sol", 47);
        validEntityNames.put("solb", 10692);
        validEntityNames.put("solbar", 9023);
        validEntityNames.put("sopf", 120164);
        validEntityNames.put("spades", 9824);
        validEntityNames.put("sqcap", 8851);
        validEntityNames.put("sqcup", 8852);
        validEntityNames.put("sqsub", 8847);
        validEntityNames.put("sqsube", 8849);
        validEntityNames.put("sqsup", 8848);
        validEntityNames.put("sqsupe", 8850);
        validEntityNames.put("squ", 9633);
        validEntityNames.put("squf", 9642);
        validEntityNames.put("sscr", 120008);
        validEntityNames.put("sstarf", 8902);
        validEntityNames.put("star", 9734);
        validEntityNames.put("starf", 9733);
        validEntityNames.put("straightphi", 981);
        validEntityNames.put("sub", 8834);
        validEntityNames.put("subE", 10949);
        validEntityNames.put("subdot", 10941);
        validEntityNames.put("sube", 8838);
        validEntityNames.put("subedot", 10947);
        validEntityNames.put("submult", 10945);
        validEntityNames.put("subnE", 10955);
        validEntityNames.put("subne", 8842);
        validEntityNames.put("subplus", 10943);
        validEntityNames.put("subrarr", 10617);
        validEntityNames.put("subsim", 10951);
        validEntityNames.put("subsub", 10965);
        validEntityNames.put("subsup", 10963);
        validEntityNames.put("sum", 8721);
        validEntityNames.put("sung", 9834);
        validEntityNames.put("sup", 8835);
        validEntityNames.put("sup1", 185);
        validEntityNames.put("sup2", 178);
        validEntityNames.put("sup3", 179);
        validEntityNames.put("supE", 10950);
        validEntityNames.put("supdot", 10942);
        validEntityNames.put("supdsub", 10968);
        validEntityNames.put("supe", 8839);
        validEntityNames.put("supedot", 10948);
        validEntityNames.put("suphsub", 10967);
        validEntityNames.put("suplarr", 10619);
        validEntityNames.put("supmult", 10946);
        validEntityNames.put("supnE", 10956);
        validEntityNames.put("supne", 8843);
        validEntityNames.put("supplus", 10944);
        validEntityNames.put("supsim", 10952);
        validEntityNames.put("supsub", 10964);
        validEntityNames.put("supsup", 10966);
        validEntityNames.put("swArr", 8665);
        validEntityNames.put("swarhk", 10534);
        validEntityNames.put("swarr", 8601);
        validEntityNames.put("swnwar", 10538);
        validEntityNames.put("szlig", 223);
        validEntityNames.put("target", 8982);
        validEntityNames.put("tau", 964);
        validEntityNames.put("tbrk", 9140);
        validEntityNames.put("tcaron", 357);
        validEntityNames.put("tcedil", 355);
        validEntityNames.put("tcy", 1090);
        validEntityNames.put("tdot", 8411);
        validEntityNames.put("telrec", 8981);
        validEntityNames.put("tfr", 120113);
        validEntityNames.put("there4", 8756);
        validEntityNames.put("theta", 952);
        validEntityNames.put("thetav", 977);
        validEntityNames.put("thinsp", 8201);
        validEntityNames.put("thorn", 254);
        validEntityNames.put("tilde", 732);
        validEntityNames.put("times", 215);
        validEntityNames.put("timesb", 8864);
        validEntityNames.put("timesbar", 10801);
        validEntityNames.put("timesd", 10800);
        validEntityNames.put("tint", 8749);
        validEntityNames.put("top", 8868);
        validEntityNames.put("topbot", 9014);
        validEntityNames.put("topcir", 10993);
        validEntityNames.put("topf", 120165);
        validEntityNames.put("topfork", 10970);
        validEntityNames.put("tprime", 8244);
        validEntityNames.put("trade", 8482);
        validEntityNames.put("tridot", 9708);
        validEntityNames.put("trie", 8796);
        validEntityNames.put("triminus", 10810);
        validEntityNames.put("triplus", 10809);
        validEntityNames.put("trisb", 10701);
        validEntityNames.put("tritime", 10811);
        validEntityNames.put("trpezium", 9186);
        validEntityNames.put("tscr", 120009);
        validEntityNames.put("tscy", 1094);
        validEntityNames.put("tshcy", 1115);
        validEntityNames.put("tstrok", 359);
        validEntityNames.put("twixt", 8812);
        validEntityNames.put("uArr", 8657);
        validEntityNames.put("uHar", 10595);
        validEntityNames.put("uacute", 250);
        validEntityNames.put("uarr", 8593);
        validEntityNames.put("ubrcy", 1118);
        validEntityNames.put("ubreve", 365);
        validEntityNames.put("ucirc", 251);
        validEntityNames.put("ucy", 1091);
        validEntityNames.put("udarr", 8645);
        validEntityNames.put("udblac", 369);
        validEntityNames.put("udhar", 10606);
        validEntityNames.put("ufisht", 10622);
        validEntityNames.put("ufr", 120114);
        validEntityNames.put("ugrave", 249);
        validEntityNames.put("uharl", 8639);
        validEntityNames.put("uharr", 8638);
        validEntityNames.put("uhblk", 9600);
        validEntityNames.put("ulcorn", 8988);
        validEntityNames.put("ulcrop", 8975);
        validEntityNames.put("ultri", 9720);
        validEntityNames.put("umacr", 363);
        validEntityNames.put("uogon", 371);
        validEntityNames.put("uopf", 120166);
        validEntityNames.put("uplus", 8846);
        validEntityNames.put("upsi", 965);
        validEntityNames.put("urcorn", 8989);
        validEntityNames.put("urcrop", 8974);
        validEntityNames.put("uring", 367);
        validEntityNames.put("urtri", 9721);
        validEntityNames.put("uscr", 120010);
        validEntityNames.put("utdot", 8944);
        validEntityNames.put("utilde", 361);
        validEntityNames.put("utri", 9653);
        validEntityNames.put("utrif", 9652);
        validEntityNames.put("uuarr", 8648);
        validEntityNames.put("uuml", 252);
        validEntityNames.put("uwangle", 10663);
        validEntityNames.put("vArr", 8661);
        validEntityNames.put("vBar", 10984);
        validEntityNames.put("vBarv", 10985);
        validEntityNames.put("vDash", 8872);
        validEntityNames.put("vangrt", 10652);
        validEntityNames.put("varr", 8597);
        validEntityNames.put("vcy", 1074);
        validEntityNames.put("vdash", 8866);
        validEntityNames.put("veebar", 8891);
        validEntityNames.put("veeeq", 8794);
        validEntityNames.put("vellip", 8942);
        validEntityNames.put("verbar", 124);
        validEntityNames.put("vfr", 120115);
        validEntityNames.put("vltri", 8882);
        validEntityNames.put("vopf", 120167);
        validEntityNames.put("vrtri", 8883);
        validEntityNames.put("vscr", 120011);
        validEntityNames.put("vzigzag", 10650);
        validEntityNames.put("wcirc", 373);
        validEntityNames.put("wedbar", 10847);
        validEntityNames.put("wedgeq", 8793);
        validEntityNames.put("weierp", 8472);
        validEntityNames.put("wfr", 120116);
        validEntityNames.put("wopf", 120168);
        validEntityNames.put("wreath", 8768);
        validEntityNames.put("wscr", 120012);
        validEntityNames.put("xcap", 8898);
        validEntityNames.put("xcirc", 9711);
        validEntityNames.put("xcup", 8899);
        validEntityNames.put("xdtri", 9661);
        validEntityNames.put("xfr", 120117);
        validEntityNames.put("xhArr", 10234);
        validEntityNames.put("xharr", 10231);
        validEntityNames.put("xi", 958);
        validEntityNames.put("xlArr", 10232);
        validEntityNames.put("xlarr", 10229);
        validEntityNames.put("xmap", 10236);
        validEntityNames.put("xnis", 8955);
        validEntityNames.put("xodot", 10752);
        validEntityNames.put("xopf", 120169);
        validEntityNames.put("xoplus", 10753);
        validEntityNames.put("xotime", 10754);
        validEntityNames.put("xrArr", 10233);
        validEntityNames.put("xrarr", 10230);
        validEntityNames.put("xscr", 120013);
        validEntityNames.put("xsqcup", 10758);
        validEntityNames.put("xuplus", 10756);
        validEntityNames.put("xutri", 9651);
        validEntityNames.put("xvee", 8897);
        validEntityNames.put("xwedge", 8896);
        validEntityNames.put("yacute", 253);
        validEntityNames.put("yacy", 1103);
        validEntityNames.put("ycirc", 375);
        validEntityNames.put("ycy", 1099);
        validEntityNames.put("yen", 165);
        validEntityNames.put("yfr", 120118);
        validEntityNames.put("yicy", 1111);
        validEntityNames.put("yopf", 120170);
        validEntityNames.put("yscr", 120014);
        validEntityNames.put("yucy", 1102);
        validEntityNames.put("yuml", 255);
        validEntityNames.put("zacute", 378);
        validEntityNames.put("zcaron", 382);
        validEntityNames.put("zcy", 1079);
        validEntityNames.put("zdot", 380);
        validEntityNames.put("zeta", 950);
        validEntityNames.put("zfr", 120119);
        validEntityNames.put("zhcy", 1078);
        validEntityNames.put("zigrarr", 8669);
        validEntityNames.put("zopf", 120171);
        validEntityNames.put("zscr", 120015);
        validEntityNames.put("zwj", 8205);
        validEntityNames.put("zwnj", 8204);
        VALID_ENTITY_NAMES = Collections.unmodifiableMap(validEntityNames);
    }

    public static class MyEscaper
    implements EscapingWriterFactory {
        public Writer createEscapingWriterFor(OutputStream theOut, String theEnc) throws UnsupportedEncodingException {
            return this.createEscapingWriterFor(new OutputStreamWriter(theOut, theEnc), theEnc);
        }

        public Writer createEscapingWriterFor(final Writer theW, String theEnc) {
            return new Writer(){

                @Override
                public void close() throws IOException {
                    theW.close();
                }

                @Override
                public void flush() throws IOException {
                    theW.flush();
                }

                @Override
                public void write(char[] theCbuf, int theOff, int theLen) throws IOException {
                    boolean hasEscapable = false;
                    block3: for (int i = 0; i < theLen && !hasEscapable; ++i) {
                        char nextChar = theCbuf[i + theOff];
                        switch (nextChar) {
                            case '\"': 
                            case '&': 
                            case '<': 
                            case '>': {
                                hasEscapable = true;
                                continue block3;
                            }
                        }
                    }
                    if (!hasEscapable) {
                        theW.write(theCbuf, theOff, theLen);
                        return;
                    }
                    String escaped = StringEscapeUtils.escapeXml10((String)new String(theCbuf, theOff, theLen));
                    theW.write(escaped.toCharArray());
                }
            };
        }
    }

    private static final class ExtendedEntityReplacingXmlResolver
    implements XMLResolver {
        private ExtendedEntityReplacingXmlResolver() {
        }

        @Override
        public Object resolveEntity(String thePublicID, String theSystemID, String theBaseURI, String theNamespace) {
            if (thePublicID == null && theSystemID == null && theNamespace != null && VALID_ENTITY_NAMES.containsKey(theNamespace)) {
                return new String(Character.toChars(VALID_ENTITY_NAMES.get(theNamespace)));
            }
            return null;
        }
    }
}

